/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.AbstractSMMob;
import sweetmagic.init.entity.projectile.EnderBall;
import sweetmagic.util.PlayerHelper;

public class EnderMage
extends AbstractSMMob {
    private int tickTime = 0;
    private int coolTime = 0;

    public EnderMage(Level world) {
        super(EntityInit.enderMage, world);
    }

    public EnderMage(EntityType<EnderMage> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 35;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.33).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22277_, 24.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new EnderAttack(this));
        super.m_8099_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        float rate = 1.0f + 0.375f * (float)this.getPotionLevel((LivingEntity)this, PotionInit.leader_flag);
        return super.m_6972_(pose).m_20388_(rate);
    }

    public boolean m_6469_(DamageSource src, float amount) {
        if (this.isSMMobSRC(src)) {
            return false;
        }
        amount = this.getDamageAmount((Entity)this, src, amount, 1.0f);
        Entity attackEntity = src.m_7640_();
        return super.m_6469_(src, amount);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.tickTime++ < 20 || this.isClient() || this.m_5448_() == null) {
            return;
        }
        this.tickTime = 0;
        if (this.coolTime > 0) {
            --this.coolTime;
            return;
        }
        List entityList = this.getEntityList(Monster.class, (Entity)this, e -> e.m_6084_() && !(e instanceof EnderMage) && e instanceof ISMMob, 7.5);
        if (entityList.isEmpty()) {
            if (this.m_5448_() == null) {
                this.m_5496_(SoundEvents.f_11887_, 1.0f, 1.175f);
                this.addPotion((LivingEntity)this, MobEffects.f_19600_, 400, 1);
            }
            return;
        }
        for (Monster entity : entityList) {
            this.addPotion((LivingEntity)entity, MobEffects.f_19600_, 400, 0);
            try {
                PlayerHelper.getEffectList((LivingEntity)entity, PotionInit.DEBUFF).forEach(p -> entity.m_21195_(p.m_19544_()));
            }
            catch (Throwable throwable) {}
        }
        this.coolTime = 30;
        this.m_5496_(SoundEvents.f_11887_, 1.0f, 1.175f);
    }

    @Override
    public void targetAIStep(LivingEntity target) {
        if (this.f_19797_ % 20 == 0 && !this.m_142582_((Entity)target)) {
            this.teleport(target);
        }
    }

    protected boolean teleport(LivingEntity target) {
        if (!this.isClient() && this.m_6084_()) {
            double x = target.m_20185_() + (this.rand.nextDouble() - 0.5) * 5.0;
            double y = target.m_20186_() + (double)(this.rand.nextInt(8) - 4);
            double z = target.m_20189_() + (this.rand.nextDouble() - 0.5) * 5.0;
            return this.teleport(x, y, z);
        }
        return false;
    }

    private static class EnderAttack
    extends Goal {
        private final EnderMage ender;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public EnderAttack(EnderMage ender) {
            this.ender = ender;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity entity = this.ender.m_5448_();
            return entity != null && entity.m_6084_() && this.ender.m_6779_(entity);
        }

        public void m_8056_() {
            this.attackStep = 0;
        }

        public void m_8041_() {
            this.lastSeen = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity target = this.ender.m_5448_();
            if (target == null) {
                return;
            }
            boolean flag = this.ender.m_21574_().m_148306_((Entity)target);
            this.lastSeen = flag ? 0 : (this.lastSeen = this.lastSeen + 1);
            double d0 = this.ender.m_20280_((Entity)target);
            if (d0 < 4.0) {
                if (!flag) {
                    return;
                }
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.ender.m_7327_((Entity)target);
                }
                this.ender.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
            } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                Level world = this.ender.m_9236_();
                double x = target.m_20185_() - this.ender.m_20185_();
                double y = target.m_20227_(0.3333333333333333) - this.ender.m_20186_();
                double z = target.m_20189_() - this.ender.m_20189_();
                double xz = Math.sqrt(x * x + z * z);
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 40;
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 13;
                    } else {
                        this.attackTime = 130;
                        this.attackStep = 0;
                    }
                    if (this.attackStep > 1) {
                        float damage;
                        boolean isWarden;
                        if (!this.ender.m_20067_()) {
                            world.m_5898_((Player)null, 1018, this.ender.m_20183_(), 0);
                        }
                        float shotSpeed = (isWarden = target instanceof Warden) ? 5.0f : 1.0f;
                        float f = damage = isWarden ? 16.0f : 0.0f;
                        if (isWarden || this.ender.isHard(world)) {
                            shotSpeed += 0.5f;
                            damage += 2.0f;
                        }
                        EnderBall entity = new EnderBall((LivingEntity)this.ender);
                        entity.m_6686_(x, y - xz * 0.065, z, shotSpeed, 2.0f);
                        entity.setAddDamage(entity.getAddDamage() + damage);
                        entity.isTeleport = !this.ender.m_21023_(PotionInit.resistance_blow);
                        this.ender.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
                        world.m_7967_((Entity)entity);
                    }
                }
                this.ender.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
            } else if (this.lastSeen < 5) {
                this.ender.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
            }
            super.m_8037_();
        }

        private double getFollowDistance() {
            return this.ender.m_21133_(Attributes.f_22277_);
        }
    }
}

