/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.entity.monster.AbstractSMMob;
import sweetmagic.init.entity.monster.EnderShadowMirage;

public class EnderShadow
extends AbstractSMMob {
    private int recastTime = 0;
    private int tickTime = 0;
    private int maxTickTime = 0;
    private static final EntityDataAccessor<Integer> SUMMON_COUNT = ISMMob.setData(EnderShadow.class, INT);

    public EnderShadow(Level world) {
        super(EntityInit.enderShadow, world);
    }

    public EnderShadow(EntityType<EnderShadow> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 200;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(SUMMON_COUNT, 0);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean m_6469_(DamageSource src, float amount) {
        Entity attackEntity;
        if (this.isSMMobSRC(src)) {
            return false;
        }
        Entity attacker = src.m_7639_();
        if (this.notMagicDamage(attacker, attackEntity = src.m_7640_())) {
            amount *= 0.25f;
        }
        if (!this.isLeader((LivingEntity)this)) {
            amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, 20.0f);
            this.defTime = 1;
        }
        return super.m_6469_(src, amount);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11899_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_11849_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    protected void m_6153_() {
        super.m_6153_();
        List entityList = this.getEntityList(EnderShadowMirage.class, (Entity)this, e -> e.m_6084_() && e.is((LivingEntity)this), 256.0);
        entityList.forEach(e -> e.m_21153_(0.0f));
    }

    public boolean m_7327_(Entity entity) {
        boolean flag = super.m_7327_(entity);
        if (flag && entity instanceof Warden) {
            Warden target = (Warden)entity;
            entity.m_6469_(this.getSRC(), 20.0f);
        }
        entity.f_19802_ = 0;
        this.teleport();
        return flag;
    }

    @Override
    public void targetAIStep(LivingEntity target) {
        if (this.f_19797_ % 20 == 0 && !this.m_142582_((Entity)target)) {
            this.teleport(target);
        }
        if (this.recastTime-- > 0 || this.isLeader((LivingEntity)this)) {
            return;
        }
        if (this.maxTickTime <= 0) {
            this.maxTickTime = this.rand.nextInt(150) + 100;
        }
        if (this.tickTime++ >= this.maxTickTime) {
            int summonCount = this.getSummon();
            if (summonCount < 3) {
                EnderShadowMirage entity = new EnderShadowMirage(this.m_9236_());
                entity.m_146884_(this.m_20183_().m_252807_());
                entity.m_21051_(Attributes.f_22276_).m_22100_((double)(this.m_21233_() / 4.0f));
                entity.m_21153_(entity.m_21233_());
                this.addEntity((Entity)entity);
                entity.teleport();
                entity.m_21373_();
                entity.m_20084_(this.m_20148_());
                this.setSummon(summonCount + 1);
                this.recastTime = 100;
                this.maxTickTime = this.rand.nextInt(150) + 100;
            } else {
                this.maxTickTime = Integer.MAX_VALUE;
            }
        }
    }

    protected boolean teleport(LivingEntity target) {
        if (!this.isClient() && this.m_6084_()) {
            double x = target.m_20185_() + (this.rand.nextDouble() - 0.5) * 5.0;
            double y = target.m_20186_() + (double)(this.rand.nextInt(8) - 4);
            double z = target.m_20189_() + (this.rand.nextDouble() - 0.5) * 5.0;
            return this.teleport(x, y, z);
        }
        return false;
    }

    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("isSummon", this.getSummon());
        tags.m_128405_("maxTickTime", this.maxTickTime);
        tags.m_128405_("recastTime", this.recastTime);
    }

    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setSummon(tags.m_128451_("isSummon"));
        this.maxTickTime = tags.m_128451_("maxTickTime");
        this.recastTime = tags.m_128451_("recastTime");
    }

    public int getSummon() {
        return (Integer)this.get(SUMMON_COUNT);
    }

    public void setSummon(int summonCount) {
        this.set(SUMMON_COUNT, summonCount);
    }
}

