/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.monster.AbstractOwnerMob;
import sweetmagic.init.entity.monster.AbstractSMMob;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.FireMagicShot;
import sweetmagic.init.entity.projectile.FrostMagicShot;
import sweetmagic.init.entity.projectile.LightMagicShot;

public class PixeVex
extends AbstractOwnerMob {
    private static final EntityDataAccessor<Integer> ELEMENT_TYPE = ISMMob.setData(PixeVex.class, INT);
    private int recastTime = 0;
    private static final int RAND_RECASTTIME = 60;

    public PixeVex(Level world) {
        super(EntityInit.pixeVex, world);
    }

    public PixeVex(EntityType<? extends AbstractSMMob> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 150;
        this.m_20242_(true);
        this.f_21342_ = new ISMMob.SMMoveControl((Mob)this);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new ISMMob.RandomMoveGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 96.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(ELEMENT_TYPE, 0);
    }

    public int getElementType() {
        return (Integer)this.get(ELEMENT_TYPE);
    }

    public void setElementType(int elementType) {
        this.set(ELEMENT_TYPE, elementType);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("elementType", this.getElementType());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setElementType(tags.m_128451_("elementType"));
    }

    public boolean m_6469_(DamageSource src, float amount) {
        if (this.isSMMobSRC(src)) {
            return false;
        }
        amount = this.getDamageAmount((Entity)this, src, amount, 1.0f);
        return super.m_6469_(src, Math.min(20.0f, amount));
    }

    public boolean m_142535_(float par1, float par2, DamageSource src) {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isClient() || this.f_19797_ % 30 != 0) {
            return;
        }
        Vec3 vec = this.m_20184_();
        SimpleParticleType par = ParticleTypes.f_123744_;
        switch (this.getElementType()) {
            case 1: {
                par = ParticleInit.FROST;
                break;
            }
            case 2: {
                par = ParticleInit.MAGICLIGHT;
            }
        }
        for (int i = 0; i < 4; ++i) {
            float x = (float)this.m_20185_() - 0.5f + this.rand.nextFloat();
            float y = (float)this.m_20186_() + this.rand.nextFloat() * 2.0f;
            float z = (float)this.m_20189_() - 0.5f + this.rand.nextFloat();
            float f1 = (float)(vec.f_82479_ + 0.5 - (double)this.rand.nextFloat()) * 0.2f;
            float f2 = (float)(vec.f_82480_ + 0.5 - (double)this.rand.nextFloat()) * 0.2f;
            float f3 = (float)(vec.f_82481_ + 0.5 - (double)this.rand.nextFloat()) * 0.2f;
            this.m_9236_().m_7106_((ParticleOptions)par, (double)x, (double)y, (double)z, (double)f1, (double)f2, (double)f3);
        }
    }

    @Override
    public void targetAIStep(LivingEntity target) {
        if (this.recastTime-- > 0) {
            return;
        }
        boolean isWarden = target instanceof Warden;
        this.recastTime = (int)((float)(this.rand.nextInt(60) + 60) * (isWarden ? 0.25f : 1.0f));
        AbstractMagicShot entity = this.getMagicShot(target, isWarden);
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        this.addEntity((Entity)entity);
    }

    public AbstractMagicShot getMagicShot(LivingEntity target, boolean isWarden) {
        float dama = isWarden ? 30.0f : 1.5f;
        float dameRate = isWarden ? 1.25f : 1.0f;
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20227_(0.3333333333333333) - this.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double xz = Math.sqrt(x * x + z * z);
        int level = isWarden ? 20 : 3;
        AbstractMagicShot entity = switch (this.getElementType()) {
            case 1 -> new FrostMagicShot((LivingEntity)this);
            case 2 -> new LightMagicShot((LivingEntity)this);
            default -> new FireMagicShot((LivingEntity)this);
        };
        entity.setWandLevel(level);
        entity.m_6686_(x, y - xz * 0.035, z, 3.35f, 0.0f);
        entity.setAddDamage((entity.getAddDamage() + dama) * dameRate);
        entity.setRange(1.0);
        return entity;
    }

    public void setMoveControl(ISMMob.SMMoveControl con) {
        this.f_21342_ = con;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ISMMob.SpawnInfo info) {
        this.setElementType(this.rand.nextInt(3));
        return super.finalizeSpawn(info);
    }
}

