/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.util.ISMTip;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.util.WorldHelper;

public abstract class AbstractSMBoss
extends Monster
implements ISMMob,
ISMTip {
    protected int tickTime = 0;
    protected int defTime = 0;
    protected int stanTime = 0;
    protected float healthO = -1.0f;
    protected float healthArmorO = -1.0f;
    private BlockPos spawnPos = null;
    public Random rand = new Random();
    private ServerBossEvent bossEvent = null;
    private static final EntityDataAccessor<Boolean> LECTERN = ISMMob.setData(AbstractSMBoss.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> HARD = ISMMob.setData(AbstractSMBoss.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> MAGIC = ISMMob.setData(AbstractSMBoss.class, BOOLEAN);
    protected static final EntityDataAccessor<Boolean> HALF_HEALTH = ISMMob.setData(AbstractSMBoss.class, BOOLEAN);
    protected static final EntityDataAccessor<Boolean> STAN = ISMMob.setData(AbstractSMBoss.class, BOOLEAN);
    private static final EntityDataAccessor<Integer> HEALTH_ARMOR_COUNT = ISMMob.setData(AbstractSMBoss.class, INT);
    private static final EntityDataAccessor<Integer> MAX_HEALTH_ARMOR_COUNT = ISMMob.setData(AbstractSMBoss.class, INT);
    private static final EntityDataAccessor<Float> HEALTH_ARMOR = ISMMob.setData(AbstractSMBoss.class, FLOAT);
    private static final EntityDataAccessor<Float> MAX_HEALTH_ARMOR = ISMMob.setData(AbstractSMBoss.class, FLOAT);

    public AbstractSMBoss(EntityType<? extends AbstractSMBoss> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 500;
        this.m_274367_(1.25f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(LECTERN, false);
        this.define(HARD, false);
        this.define(MAGIC, false);
        this.define(HALF_HEALTH, false);
        this.define(STAN, false);
        this.define(HEALTH_ARMOR_COUNT, 0);
        this.define(MAX_HEALTH_ARMOR_COUNT, 0);
        this.define(HEALTH_ARMOR, Float.valueOf(0.0f));
        this.define(MAX_HEALTH_ARMOR, Float.valueOf(0.0f));
    }

    @Override
    public void refreshInfo() {
        this.m_20090_();
        this.m_6210_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new TargetMoveGoal(this, 1.0, 4.0f, 24.0f));
        this.f_21345_.m_25352_(5, (Goal)new TargetLookGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new SMRandomLookGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    public SynchedEntityData getData() {
        return this.m_20088_();
    }

    public boolean getLectern() {
        return (Boolean)this.get(LECTERN);
    }

    public void setLectern(boolean isLectern) {
        this.set(LECTERN, isLectern);
    }

    public boolean getMagic() {
        return (Boolean)this.get(MAGIC);
    }

    public void setMagic(boolean isMagic) {
        this.set(MAGIC, isMagic);
    }

    public boolean getHard() {
        return (Boolean)this.get(HARD);
    }

    public void setHard(boolean isHard) {
        this.set(HARD, isHard);
    }

    public boolean getHalfHealthFlag() {
        return (Boolean)this.get(HALF_HEALTH);
    }

    public void setHalfHealth(boolean halfHealth) {
        this.set(HALF_HEALTH, halfHealth);
    }

    public boolean getStan() {
        return (Boolean)this.get(STAN);
    }

    public void setStan(boolean stan) {
        this.set(STAN, stan);
    }

    public int getHealthArmorCount() {
        return (Integer)this.get(HEALTH_ARMOR_COUNT);
    }

    public void setHealthArmorCount(int armor) {
        this.set(HEALTH_ARMOR_COUNT, armor);
        if (armor > 0 && this.getMaxHealthArmorCount() == 0) {
            this.setMaxHealthArmorCount(armor);
        }
    }

    public int getMaxHealthArmorCount() {
        return (Integer)this.get(MAX_HEALTH_ARMOR_COUNT);
    }

    public void setMaxHealthArmorCount(int armor) {
        this.set(MAX_HEALTH_ARMOR_COUNT, armor);
    }

    public float getHealthArmor() {
        return ((Float)this.get(HEALTH_ARMOR)).floatValue();
    }

    public void setHealthArmor(float armor) {
        this.set(HEALTH_ARMOR, Float.valueOf(armor));
    }

    public float getMaxHealthArmor() {
        return ((Float)this.get(MAX_HEALTH_ARMOR)).floatValue();
    }

    public void setMaxHealthArmor(float armor) {
        this.set(MAX_HEALTH_ARMOR, Float.valueOf(armor));
    }

    public BlockPos getSpawnPos() {
        return this.spawnPos;
    }

    public void setSpawnPos(BlockPos spawnPos) {
        this.spawnPos = spawnPos;
    }

    public boolean m_20145_() {
        return this.getMagic();
    }

    public <T extends Player> List<T> getPlayer(Class<T> enClass) {
        return this.getEntityList(enClass, (Entity)this, p -> !p.m_5833_() && p.m_6084_(), 64.0);
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, double range) {
        return this.getEntityList(enClass, (Entity)this, p -> !p.m_5833_() && p.m_6084_(), range);
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Predicate<T> filter, double range) {
        return this.getEntityList(enClass, (Entity)this, filter, range);
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, AABB aabb) {
        return WorldHelper.getEntityList((Entity)this, enClass, p -> !p.m_5833_() && p.m_6084_(), aabb);
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Predicate<T> filter, AABB aabb) {
        return WorldHelper.getEntityList((Entity)this, enClass, filter, aabb);
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Vec3 vec, double range) {
        return WorldHelper.getEntityList((Entity)this, enClass, this.getAABB(vec, range));
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Predicate<T> filter, Vec3 vec, double range) {
        return WorldHelper.getEntityList((Entity)this, enClass, filter, this.getAABB(vec, range));
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, BlockPos pos, double range) {
        return WorldHelper.getEntityList((Entity)this, enClass, this.getAABB(pos, range));
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Predicate<T> filter, BlockPos pos, double range) {
        return WorldHelper.getEntityList((Entity)this, enClass, filter, this.getAABB(pos, range));
    }

    public void addEntity(Entity entity) {
        this.m_9236_().m_7967_(entity);
    }

    public AABB getAABB(double range) {
        BlockPos pos = this.m_20183_();
        return new AABB(WorldHelper.offset(pos, -range, -range, -range), WorldHelper.offset(pos, range, range, range));
    }

    @Override
    public AABB getAABB(BlockPos pos, double range) {
        return new AABB(WorldHelper.offset(pos, -range, -range, -range), WorldHelper.offset(pos, range, range, range));
    }

    public AABB getAABB(Vec3 vec, double range) {
        return new AABB(vec.f_82479_ - range, vec.f_82480_ - range, vec.f_82481_ - range, vec.f_82479_ + range, vec.f_82480_ + range, vec.f_82481_ + range);
    }

    public List<LivingEntity> getPlayerList(LivingEntity target) {
        return this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer((Entity)target)), 48.0);
    }

    public float getPlayerCount(LivingEntity target) {
        return this.getPlayerCount(this.getPlayerList(target));
    }

    public float getPlayerCount(List<LivingEntity> targetList) {
        float count = 0.0f;
        for (LivingEntity target : targetList) {
            count += target instanceof Player ? 1.0f : 0.5f;
        }
        return count;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.defTime > 0) {
            --this.defTime;
        }
        if (this.f_19797_ % 20 == 0 && !this.isClient()) {
            this.checkSpawnPos();
        }
    }

    public void checkSpawnPos() {
        BlockPos pos = this.getSpawnPos();
        if (pos == null) {
            return;
        }
        double dis = this.m_20238_(pos.m_252807_());
        if (dis >= this.getDistance() || this.m_5448_() != null && !this.m_142582_((Entity)this.m_5448_()) && dis >= this.getDistance() * 0.5) {
            this.teleportSpawnPos(pos);
        }
    }

    public double getDistance() {
        return 1500.0;
    }

    public void animationAction(AnimationState anima) {
        if (anima.m_216984_()) {
            anima.m_216973_();
        } else {
            anima.m_216977_(this.f_19797_);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance dif, MobSpawnType spawn, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(world, dif, spawn, data, tag);
        this.clearInfo();
        this.spawnAction();
        this.addPotion((LivingEntity)this, PotionInit.resistance_blow, 99999, 10);
        this.addPotion((LivingEntity)this, PotionInit.reflash_effect, 99999, 0);
        this.setSpawnPos(this.m_20183_().m_7494_());
        return this.finalizeSpawn(new ISMMob.SpawnInfo(world, dif, spawn, data, tag));
    }

    public SpawnGroupData finalizeSpawn(ISMMob.SpawnInfo info) {
        return info.data();
    }

    public boolean isBossBarView() {
        return this.getBossEvent() != null;
    }

    public void setBossEvent(BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay) {
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_6).m_7003_(true);
    }

    public ServerBossEvent getBossEvent() {
        return this.bossEvent;
    }

    public void m_6593_(@Nullable Component tip) {
        super.m_6593_(tip);
        if (this.isBossBarView()) {
            this.getBossEvent().m_6456_(this.m_5446_());
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        ServerBossEvent event = this.getBossEvent();
        if (this.isBossBarView() && event != null) {
            event.m_6543_(player);
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        if (this.isBossBarView()) {
            this.getBossEvent().m_6539_(player);
        }
    }

    public void initBossBar() {
        if (!this.isBossBarView()) {
            return;
        }
        ServerBossEvent event = this.getBossEvent();
        float armor = this.getHealthArmor();
        if (armor > 0.0f) {
            if (this.healthArmorO == -1.0f) {
                this.healthArmorO = armor;
            } else if (this.healthArmorO != armor) {
                this.healthArmorO = Math.max(armor, this.healthArmorO - this.getMaxHealthArmor() * 0.025f);
            }
            event.m_142711_(this.healthArmorO / this.getMaxHealthArmor());
            event.m_6451_(BossEvent.BossBarColor.YELLOW);
            event.m_6456_((Component)this.getTipArray(new Object[]{this.m_5446_(), " (", this.getArmorName(), ")"}));
            return;
        }
        float health = this.m_21223_();
        if (this.healthO == -1.0f) {
            this.healthO = health;
        } else if (this.healthO != health) {
            this.healthO = Math.max(health, this.healthO - this.m_21233_() * 0.015f);
        }
        event.m_142711_(this.healthO / this.m_21233_());
        if (this.isHalfHealth((LivingEntity)this)) {
            event.m_6451_(BossEvent.BossBarColor.RED);
            event.m_6456_(this.m_5446_());
        }
    }

    public int getHealthArmorProgress(int value) {
        return this.isHalfHealth((LivingEntity)this) ? (int)((float)value * (this.getHealthArmor() / this.getMaxHealthArmor())) : 0;
    }

    public MutableComponent getArmorName() {
        return this.getText("damage_armor");
    }

    public void checkPotion(MobEffect potion, int time, int level) {
        if (!this.m_21023_(potion)) {
            this.addPotion((LivingEntity)this, potion, time, level);
        }
    }

    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("tickTime", this.tickTime);
        tags.m_128379_("isLectern", this.getLectern());
        tags.m_128379_("isHard", this.getHard());
        tags.m_128379_("isMagic", this.getMagic());
        tags.m_128379_("halfHealth", this.getHalfHealthFlag());
        tags.m_128379_("stan", this.getStan());
        tags.m_128405_("health_armor_count", this.getHealthArmorCount());
        tags.m_128405_("max_health_armor_count", this.getMaxHealthArmorCount());
        tags.m_128350_("health_armor", this.getHealthArmor());
        tags.m_128350_("max_health_armor", this.getMaxHealthArmor());
        BlockPos spawnPos = this.getSpawnPos();
        if (spawnPos != null) {
            tags.m_128405_("spawnPosX", spawnPos.m_123341_());
            tags.m_128405_("spawnPosY", spawnPos.m_123342_());
            tags.m_128405_("spawnPosZ", spawnPos.m_123343_());
        }
    }

    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.tickTime = tags.m_128451_("tickTime");
        this.setLectern(tags.m_128471_("isLectern"));
        this.setHard(tags.m_128471_("isHard"));
        this.setHalfHealth(tags.m_128471_("halfHealth"));
        this.setStan(tags.m_128471_("stan"));
        this.setMagic(tags.m_128471_("isMagic"));
        this.setHealthArmorCount(tags.m_128451_("health_armor_count"));
        this.setMaxHealthArmorCount(tags.m_128451_("max_health_armor_count"));
        this.setHealthArmor(tags.m_128457_("health_armor"));
        this.setMaxHealthArmor(tags.m_128457_("max_health_armor"));
        if (tags.m_128441_("spawnPosX")) {
            this.setSpawnPos(new BlockPos(tags.m_128451_("spawnPosX"), tags.m_128451_("spawnPosY"), tags.m_128451_("spawnPosZ")));
        }
        if (this.m_8077_() && this.isBossBarView()) {
            this.getBossEvent().m_6456_(this.m_5446_());
        }
    }

    public boolean m_6469_(DamageSource src, float amount) {
        float armor = this.getHealthArmor();
        if (armor > 0.0f) {
            this.setHealthArmor(armor - amount);
            amount = 0.0f;
            if (this.getHealthArmor() > 0.0f) {
                this.m_5496_(SoundEvents.f_11704_, 0.67f, 1.25f);
            } else {
                this.armorBreak();
                this.m_5496_(SoundEvents.f_12018_, 2.0f, 1.0f);
            }
        }
        return super.m_6469_(src, amount);
    }

    public void armorBreak() {
    }

    protected void m_8024_() {
        super.m_8024_();
        this.initBossBar();
        LivingEntity target = this.m_5448_();
        if (target != null) {
            this.checkPotion(PotionInit.resistance_blow, 99999, 10);
            if (this.isHalfHealth((LivingEntity)this) && !this.getHalfHealthFlag()) {
                this.halfHealthAction(target);
            }
            this.targetAIStep(target);
        } else {
            this.targetEmptyStep();
        }
    }

    public void halfHealthAction(LivingEntity target) {
        this.setHalfHealth(true);
        int count = this.getHealthArmorCount();
        if (count > 0) {
            this.armorHealthSet(target, count);
            this.setHealthArmorCount(0);
        }
    }

    public void armorHealthSet(LivingEntity target, int count) {
        this.setMaxHealthArmor(this.m_21233_() * (0.2f + this.getPlayerCount(target) * 0.01f) * (float)count);
        this.setHealthArmor(this.getMaxHealthArmor());
    }

    public void targetEmptyStep() {
    }

    public void targetAIStep(LivingEntity target) {
    }

    protected void teleportSpawnPos(BlockPos pos) {
        if (this.m_6084_()) {
            double x = (double)pos.m_123341_() + (this.rand.nextDouble() - 0.5) * 10.0;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + (this.rand.nextDouble() - 0.5) * 10.0;
            if (this.m_9236_().m_46859_(pos)) {
                this.m_6034_(x, y, z);
            }
        }
    }

    protected boolean teleport() {
        BlockPos spawnPos = this.getSpawnPos();
        if (!this.isClient() && this.m_6084_() && spawnPos != null) {
            double x = (double)spawnPos.m_123341_() + (this.rand.nextDouble() - 0.5) * 20.0;
            double y = spawnPos.m_123342_();
            double z = (double)spawnPos.m_123343_() + (this.rand.nextDouble() - 0.5) * 20.0;
            return this.teleport(x, y, z);
        }
        return false;
    }

    protected boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        boolean flag = this.m_9236_().m_8055_((BlockPos)pos).m_280555_();
        if (!flag) {
            return false;
        }
        EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
        if (event.isCanceled()) {
            return false;
        }
        BlockPos beforePos = this.m_20183_();
        boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
        if (flag2) {
            this.m_9236_().m_214171_(GameEvent.f_238175_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
            if (!this.m_20067_()) {
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            this.teleportParticle((ParticleOptions)ParticleTypes.f_123760_, this.m_9236_(), beforePos, this.m_20183_());
        }
        return flag2;
    }

    public void teleportParticle(ParticleOptions par, Level world, BlockPos beforePos, BlockPos afterPos) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)level;
        float pX = afterPos.m_123341_() - beforePos.m_123341_();
        float pY = afterPos.m_123342_() - beforePos.m_123342_();
        float pZ = afterPos.m_123343_() - beforePos.m_123343_();
        float count = Math.abs((int)(pX + pZ));
        int i = 0;
        while ((float)i < count) {
            for (int k = 0; k < 16; ++k) {
                float randX = this.getRandFloat(1.5f);
                float randY = this.getRandFloat(1.5f);
                float randZ = this.getRandFloat(1.5f);
                float x = (float)beforePos.m_123341_() + 0.5f + randX + pX * ((float)i / count);
                float y = (float)beforePos.m_123342_() + 1.25f + randY + pY * ((float)i / count);
                float z = (float)beforePos.m_123343_() + 0.5f + randZ + pZ * ((float)i / count);
                sever.m_8767_(par, (double)x, (double)y, (double)z, 0, 0.0, 0.0, 0.0, 1.0);
            }
            ++i;
        }
    }

    protected void spawnParticleCycle(BlockPos pos, double range) {
        this.spawnParticleCycle((ParticleOptions)ParticleInit.CYCLE_ELECTRIC, pos, range);
    }

    protected void spawnParticleCycle(ParticleOptions par, BlockPos pos, double range) {
        ServerLevel server;
        block4: {
            block3: {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) break block3;
                server = (ServerLevel)level;
                if (pos != null) break block4;
            }
            return;
        }
        int count = 18;
        for (int i = 0; i < count; ++i) {
            this.spawnParticleCycle(server, par, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, Direction.UP, range, (float)i * 20.0f, false);
        }
    }

    protected void spawnParticleCycle(ServerLevel server, ParticleOptions par, double x, double y, double z, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 1;
        server.m_8767_(par, x, y, z, 0, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * 6.0f), 1.0);
    }

    public void spawnParticleRing(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double addY, double ySpeed, double moveValue) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0 + addY;
        double z = (double)pos.m_123343_() + 0.5;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.25) {
            double rate = range * 0.75;
            server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, 0.0, ySpeed, 0.0, 1.0);
        }
    }

    public void spawnParticleRing(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double addY) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0 + addY;
        double z = (double)pos.m_123343_() + 0.5;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.25) {
            double rate = range * 0.75;
            server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, Math.cos(degree) * 0.65, 0.0, Math.sin(degree) * 0.65, 1.0);
        }
    }

    public boolean checkDistances(BlockPos basePos, BlockPos pos, double range) {
        double z;
        double y;
        double x = basePos.m_123341_() - pos.m_123341_();
        return x * x + (y = (double)(basePos.m_123342_() - pos.m_123342_())) * y + (z = (double)(basePos.m_123343_() - pos.m_123343_())) * z <= range;
    }

    public int randRange(int range) {
        return range - this.rand.nextInt(range) * 2;
    }

    public float getRandFloat(float rate) {
        return (this.rand.nextFloat() - this.rand.nextFloat()) * rate;
    }

    public boolean checkDistance(BlockPos targetPos, BlockPos pos, double range) {
        return (double)Math.abs(targetPos.m_123341_() - pos.m_123341_() + targetPos.m_123343_() - pos.m_123343_()) <= range;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        this.deathEffect();
        if (this.f_20919_ >= this.getMaxDeathTime() && !this.isClient()) {
            this.deathFinish();
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (this.isBossBarView()) {
            this.getBossEvent().m_142711_(0.0f);
        }
    }

    public void deathEffect() {
        if (this.f_20919_ % 11 == 0 && this.f_20919_ < this.getMaxDeathTime()) {
            this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)level;
                sever.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 2, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public int getMaxDeathTime() {
        return 66;
    }

    protected void deathFinish() {
    }

    public boolean m_142535_(float par1, float par2, DamageSource src) {
        return false;
    }

    public DamageSource getSRC() {
        return this.getMagicDamage((Entity)this);
    }

    public void specialDamageCut(DamageSource src, List<Player> playerList, String text) {
        Player player;
        Entity entity;
        this.teleport();
        this.m_5496_(SoundEvents.f_11704_, 2.0f, 0.85f);
        if (!this.isClient() && (entity = src.m_7639_()) instanceof Player && !playerList.contains(player = (Player)entity)) {
            playerList.add(player);
            player.m_213846_((Component)this.getText(text).m_130940_(RED));
        }
    }

    public void halfHealthTeleport() {
        if (this.isHalfHealth((LivingEntity)this) && this.rand.nextFloat() >= 0.34f) {
            this.teleport();
        }
    }

    @Override
    public boolean isLowRank() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public Predicate<LivingEntity> getFilter(boolean isPlayer) {
        return e -> !e.m_5833_() && e.m_6084_() && (isPlayer ? e instanceof Player || e instanceof AbstractSummonMob : !(e instanceof Player)) && !(e instanceof ISMMob);
    }

    public float getBuffPower() {
        int level;
        float damage = 0.0f;
        if (this.m_21023_(MobEffects.f_19600_)) {
            level = this.m_21124_(MobEffects.f_19600_).m_19564_() + 1;
            damage += (float)(level * 2);
        }
        if (this.m_21023_(MobEffects.f_19613_)) {
            level = this.m_21124_(MobEffects.f_19613_).m_19564_() + 1;
            damage -= (float)level;
        }
        return damage;
    }

    public void sendMSG(List<Player> playerList, Component com) {
        playerList.forEach(p -> p.m_213846_(com));
    }

    public void attackDamage(List<LivingEntity> entityList, DamageSource src, float damage) {
        entityList.forEach(e -> this.attackDamage((Entity)e, src, damage));
    }

    public void attackDamage(Entity entity, DamageSource src, float damage) {
        entity.m_6469_(src, entity instanceof Warden ? damage * 5.0f : damage);
        entity.f_19802_ = 0;
    }

    public boolean isClient() {
        return this.m_9236_().m_5776_();
    }

    public void setOwnerID(LivingEntity entity) {
    }

    public void startInfo() {
        if (this.getBossEvent() == null) {
            this.setBossEvent(BC_BLUE, NOTCHED_6);
        } else {
            this.setSpawnPos(this.m_20183_().m_7494_());
        }
    }

    public void setAttribute(Attribute att, double rate) {
        this.m_21051_(att).m_22100_(this.m_21133_(att) * rate);
    }

    public void spawnAction() {
    }

    public abstract void clearInfo();

    public boolean isArmorEmpty() {
        return true;
    }

    public class TargetMoveGoal
    extends Goal {
        private final AbstractSMBoss mob;
        private final double speed;
        private final float minDist;
        private final float maxDist;

        public TargetMoveGoal(AbstractSMBoss mob, double speed, float minDis, float maxDis) {
            this.mob = mob;
            this.speed = speed;
            this.minDist = minDis * minDis;
            this.maxDist = maxDis * maxDis;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            return target != null && target.m_6084_();
        }

        public void m_8056_() {
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target == null || !target.m_6084_()) {
                return;
            }
            if (this.mob.isFloat()) {
                this.floatMove(target);
            } else {
                this.groundMove(target);
            }
        }

        public void groundMove(LivingEntity target) {
            double dist = this.mob.m_20280_((Entity)target);
            double spawnDist = this.mob.m_20238_(this.mob.getSpawnPos().m_252807_());
            if (spawnDist > this.mob.getDistance() * 0.85) {
                PathNavigation path = this.mob.m_21573_();
                path.m_26536_(path.m_7864_(this.mob.getSpawnPos(), 1), this.speed);
            } else if (dist > (double)this.maxDist) {
                this.mob.m_21573_().m_5624_((Entity)target, this.speed);
            } else if (dist < (double)this.minDist) {
                Vec3 mobPos = this.mob.m_20182_();
                Vec3 direction = mobPos.m_82546_(target.m_20182_()).m_82541_();
                Vec3 retreatPos = mobPos.m_82549_(direction.m_82490_(2.0));
                this.mob.m_21573_().m_26519_(retreatPos.f_82479_, retreatPos.f_82480_, retreatPos.f_82481_, this.speed);
            } else {
                this.mob.m_21573_().m_26573_();
            }
        }

        public void floatMove(LivingEntity target) {
            double dist = this.mob.m_20280_((Entity)target);
            if (dist > (double)this.maxDist) {
                Vec3 vec = new Vec3(target.f_19854_ - this.mob.f_19854_, 0.0, target.f_19856_ - this.mob.f_19856_);
                this.mob.m_20256_(this.mob.m_20184_().m_82549_(vec.m_82490_(0.05 / vec.m_82553_())));
                Vec3 vec1 = this.mob.m_20184_();
                this.mob.m_146922_(-((float)Mth.m_14136_((double)vec1.f_82479_, (double)vec1.f_82481_)) * 57.295776f);
                this.mob.f_20883_ = this.mob.m_146908_();
            }
        }

        public boolean m_8045_() {
            LivingEntity target = this.mob.m_5448_();
            return target != null && target.m_6084_();
        }
    }

    public class TargetLookGoal
    extends Goal {
        private final AbstractSMBoss mob;

        public TargetLookGoal(AbstractSMBoss mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            return target != null && target.m_6084_();
        }

        public void m_8056_() {
        }

        public void m_8037_() {
            this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
        }
    }

    public static class SMRandomLookGoal
    extends RandomLookAroundGoal {
        private final Monster mob;

        public SMRandomLookGoal(Monster mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() == null && this.mob.m_217043_().m_188501_() > 0.95f;
        }
    }
}

