/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.PixeVex;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.PoisonMagicShot;
import sweetmagic.util.SMDamage;

public class AncientFairy
extends AbstractSMBoss {
    private int summonVexTime = 170;
    private static final int MAX_SUMMONVEXTIME = 200;
    private int eatVexTime = 0;
    private static final int MAX_EATVEXTIME = 300;
    private int poisonShotTime = 200;
    private static final int MAX_POISONSHOT = 300;
    private int poisonFogTime = 0;
    private static final int MAX_POISONFOG = 400;
    private static final EntityDataAccessor<Boolean> SUMMON = ISMMob.setData(AncientFairy.class, BOOLEAN);

    public AncientFairy(Level world) {
        super(EntityInit.ancientFairy, world);
    }

    public AncientFairy(EntityType<? extends AbstractSMBoss> enType, Level world) {
        super(enType, world);
        this.m_20242_(true);
        this.f_21342_ = new ISMMob.SMMoveControl((Mob)this);
        this.setBossEvent(BC_BLUE, NOTCHED_6);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 96.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new ISMMob.RandomMoveGoal((Mob)this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(SUMMON, false);
    }

    public boolean getSummon() {
        return (Boolean)this.get(SUMMON);
    }

    public void setSummon(boolean isSummon) {
        this.set(SUMMON, isSummon);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("isSummon", this.getSummon());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setSummon(tags.m_128471_("isSummon"));
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (this.isSMMobSRC(src)) {
            return false;
        }
        int n = this.defTime = (amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, 7.0f)) > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, this.getSRC(), amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        return super.m_6469_(src, amount);
    }

    public void m_7023_(Vec3 vec) {
        if (this.poisonFogTime > 0) {
            return;
        }
        super.m_7023_(vec);
    }

    @Override
    public void targetAIStep(LivingEntity target) {
        this.firstAttack(target);
        if (this.isHalfHealth((LivingEntity)this)) {
            this.secondAttack(target);
        }
    }

    public void firstAttack(LivingEntity target) {
        if (!this.getSummon()) {
            if (this.m_21223_() >= this.m_21233_() * 0.2f && this.summonVexTime++ >= 200) {
                this.summonVex(target);
                this.summonVexTime -= this.rand.nextInt(150) + 300;
                this.m_21153_(this.m_21223_() - this.m_21233_() * 0.1f);
            }
        } else {
            this.vexAction(target);
        }
        if (this.poisonShotTime++ >= 300) {
            this.poisonShot(target);
            this.poisonShotTime -= this.rand.nextInt(75) + 150;
        }
    }

    public void secondAttack(LivingEntity target) {
        if (this.poisonFogTime++ >= 0) {
            this.poisonFog(target);
        }
    }

    public void summonVex(LivingEntity target) {
        int summonSize = (int)Math.min(10.0f, 1.0f + this.getPlayerCount(target) * 2.0f);
        for (int i = 0; i < summonSize; ++i) {
            PixeVex entity = new PixeVex(this.m_9236_());
            entity.m_6034_(this.m_20185_() + 0.5, this.m_20186_() + 0.5 + (double)this.getRandFloat(4.0f), this.m_20189_() + 0.5);
            entity.m_21373_();
            entity.setOwnerID((LivingEntity)this);
            entity.m_20242_(true);
            entity.setMoveControl(new ISMMob.SMMoveControl((Mob)entity));
            entity.setElementType(this.rand.nextInt(3));
            this.addEntity((Entity)entity);
        }
        this.setSummon(true);
    }

    public void eatVex(LivingEntity target) {
        List<PixeVex> targetList = this.getVexList();
        if (targetList.isEmpty()) {
            return;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int count = (int)((float)this.eatVexTime / 300.0f * 8.0f);
            BlockPos pos = this.m_20183_();
            SimpleParticleType par = ParticleInit.BLOOD;
            for (PixeVex vex : targetList) {
                float entityX = (float)vex.m_20185_();
                float entityY = (float)vex.m_20186_();
                float entityZ = (float)vex.m_20189_();
                for (int i = 0; i < count; ++i) {
                    float randX = this.getRandFloat(1.0f);
                    float randY = this.getRandFloat(1.0f);
                    float randZ = this.getRandFloat(1.0f);
                    float x = entityX + 0.5f + randX;
                    float y = entityY + 1.5f + randY;
                    float z = entityZ + 0.5f + randZ;
                    float xSpeed = ((float)pos.m_123341_() - entityX - randX) * 0.115f;
                    float ySpeed = ((float)pos.m_123342_() - entityY - randY) * 0.115f;
                    float zSpeed = ((float)pos.m_123343_() - entityZ - randZ) * 0.115f;
                    server.m_8767_((ParticleOptions)par, (double)x, (double)y, (double)z, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 1.0);
                }
            }
        }
        if (this.eatVexTime >= 300) {
            int count = 0;
            for (PixeVex vex : targetList) {
                vex.m_21153_(0.1f);
                vex.m_6469_(this.getDamage((Entity)this, SMDamage.poisonDamage), 20.0f);
                ++count;
            }
            this.m_5634_(this.m_21233_() * 0.01f * (float)count * 5.0f);
            this.eatVexTime = 0;
            this.m_21195_(PotionInit.aether_armor);
            this.m_21195_(PotionInit.aether_barrier);
        }
    }

    public void poisonShot(LivingEntity target) {
        float dama = 3.0f;
        List<LivingEntity> targetList = this.getPlayerList(target);
        for (LivingEntity entity : targetList) {
            PoisonMagicShot magic = new PoisonMagicShot((LivingEntity)this);
            double x = entity.m_20185_() - this.m_20185_();
            double y = entity.m_20227_(0.3333333333333333) - this.m_20186_();
            double z = entity.m_20189_() - this.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            int level = 5;
            magic.setWandLevel(level);
            magic.m_6686_(x, y - xz * 0.035, z, 3.35f, 0.0f);
            magic.setAddDamage(magic.getAddDamage() + dama);
            magic.setRange(2.0);
            this.addEntity((Entity)magic);
        }
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
    }

    public void poisonFog(LivingEntity target) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        List<LivingEntity> targetList = this.getPlayerList(target);
        double range = 10.0 + Math.min(15.0, (double)this.getPlayerCount(targetList) * 2.0);
        BlockPos pos = this.m_20183_();
        if (this.f_19797_ % 30 == 0) {
            this.spawnParticleCycle((ParticleOptions)ParticleInit.CYCLE_TOXIC, pos, range + 1.15);
        }
        if (this.poisonFogTime < 400) {
            if (this.poisonFogTime < 370) {
                for (int i = 0; i < 2; ++i) {
                    float randX = this.randRange(6);
                    float randY = this.randRange(6);
                    float randZ = this.randRange(6);
                    float x = (float)this.m_20185_() + randX;
                    float y = (float)this.m_20186_() + 2.0f + randY;
                    float z = (float)this.m_20189_() + randZ;
                    float xSpeed = -randX * 0.115f;
                    float ySpeed = -randY * 0.115f;
                    float zSpeed = -randZ * 0.115f;
                    server.m_8767_((ParticleOptions)ParticleInit.TOXIC_SMOKY, (double)x, (double)y, (double)z, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 1.0);
                }
            }
            return;
        }
        for (LivingEntity entity : targetList) {
            if (!this.checkDistances(pos, entity.m_20183_(), range * range)) continue;
            boolean hasEffect = entity.m_21023_(PotionInit.reflash_effect);
            float rate = hasEffect ? 0.25f : 0.5f;
            entity.m_21153_(entity.m_21223_() * rate);
            entity.m_6469_(this.getSRC(), 0.1f);
        }
        float x = (float)this.m_20185_();
        float y = (float)this.m_20186_() + 2.0f;
        float z = (float)this.m_20189_();
        for (int i = 0; i < 64; ++i) {
            float randX = this.randRange(6);
            float randY = this.randRange(6);
            float randZ = this.randRange(6);
            float xSpeed = randX * 0.25f;
            float ySpeed = randY * 0.25f;
            float zSpeed = randZ * 0.25f;
            server.m_8767_((ParticleOptions)ParticleInit.TOXIC_SMOKY, (double)x, (double)y, (double)z, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 1.0);
        }
        this.poisonFogTime = -(this.rand.nextInt(100) + 200);
        this.m_5496_(SoundEvents.f_215771_, 2.0f, 1.25f);
    }

    public void vexAction(LivingEntity target) {
        if (this.f_19797_ % 30 == 0) {
            boolean isEmpty = this.getVexList().isEmpty();
            this.setSummon(isEmpty);
            if (isEmpty) {
                this.eatVexTime = 0;
                this.m_21195_(PotionInit.aether_armor);
                this.m_21195_(PotionInit.aether_barrier);
            } else {
                this.addPotion((LivingEntity)this, PotionInit.aether_armor, 200, 4);
                this.addPotion((LivingEntity)this, PotionInit.aether_barrier, 200, 4);
            }
        }
        if (this.eatVexTime++ >= 150) {
            this.eatVex(target);
        }
    }

    @Override
    public void clearInfo() {
        this.tickTime = 0;
    }

    public List<PixeVex> getVexList() {
        return this.getEntityList(PixeVex.class, (T e) -> e.m_6084_() && e.is((LivingEntity)this), 64.0);
    }
}

