/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.BlockInit;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.animal.StellaWizard;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.BelialFlameShot;
import sweetmagic.init.entity.projectile.BelialSword;
import sweetmagic.util.SMDamage;
import sweetmagic.util.WorldHelper;

public class DemonsBelial
extends AbstractSMBoss {
    private int heartAnimation;
    private int heartAnimationO;
    private int attackType = 0;
    private int attackTime = 0;
    private int recastTime = 0;
    private boolean isGround = false;
    private double aX;
    private double aY;
    private double aZ;
    public AnimationState defalutAttackAnim = new AnimationState();
    public AnimationState landingAnim = new AnimationState();
    public AnimationState laserAnim = new AnimationState();
    public AnimationState swingAnim = new AnimationState();
    public AnimationState meteorAnim = new AnimationState();
    public AnimationState downAnim = new AnimationState();
    private static final BlockState FLAME = BlockInit.belial_flame.m_49966_();
    private static final EntityDataAccessor<Boolean> NOMOVE = ISMMob.setData(DemonsBelial.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> LASER = ISMMob.setData(DemonsBelial.class, BOOLEAN);

    public DemonsBelial(Level world) {
        super(EntityInit.demonsBelial, world);
    }

    public DemonsBelial(EntityType<DemonsBelial> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 1200;
        this.setBossEvent(BC_BLUE, NOTCHED_6);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 1024.0).m_22268_(Attributes.f_22279_, 0.375).m_22268_(Attributes.f_22281_, 30.0).m_22268_(Attributes.f_22284_, 40.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(NOMOVE, false);
        this.define(LASER, false);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_215776_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_215763_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_215779_;
    }

    public boolean getNoMove() {
        return (Boolean)this.get(NOMOVE);
    }

    public void setNoMove(boolean noMove) {
        this.set(NOMOVE, noMove);
    }

    public boolean getLaser() {
        return (Boolean)this.get(LASER);
    }

    public void setLaser(boolean laser) {
        this.set(LASER, laser);
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("attackType", this.attackType);
        tags.m_128405_("attackTime", this.attackTime);
        tags.m_128405_("recastTime", this.recastTime);
        tags.m_128379_("noMove", this.getNoMove());
        tags.m_128379_("laser", this.getLaser());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.attackType = tags.m_128451_("attackType");
        this.attackTime = tags.m_128451_("attackTime");
        this.recastTime = tags.m_128451_("recastTime");
        this.setNoMove(tags.m_128471_("noMove"));
        this.setLaser(tags.m_128471_("laser"));
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (this.isSMMobSRC(src)) {
            return false;
        }
        float cap = this.isHalfHealth((LivingEntity)this) ? 3.0f : 4.0f;
        amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, this.getHealthArmor() > 0.0f ? cap * 0.75f : cap);
        int n = this.defTime = amount > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, this.getSRC(), amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        return super.m_6469_(src, amount);
    }

    public void m_7822_(byte par1) {
        switch (par1) {
            case 4: {
                this.defalutAttackAnim.m_216973_();
                this.landingAnim.m_216973_();
                this.laserAnim.m_216973_();
                this.swingAnim.m_216973_();
                this.meteorAnim.m_216973_();
                break;
            }
            case 5: {
                this.defalutAttackAnim.m_216977_(this.f_19797_);
                break;
            }
            case 6: {
                this.landingAnim.m_216977_(this.f_19797_);
                break;
            }
            case 7: {
                this.laserAnim.m_216977_(this.f_19797_);
                break;
            }
            case 8: {
                this.meteorAnim.m_216977_(this.f_19797_);
                break;
            }
            case 9: {
                this.swingAnim.m_216977_(this.f_19797_);
                break;
            }
            case 10: {
                this.downAnim.m_216977_(this.f_19797_);
                break;
            }
            default: {
                super.m_7822_(par1);
            }
        }
    }

    @Override
    public void checkSpawnPos() {
        BlockPos pos = this.getSpawnPos();
        if (pos == null) {
            return;
        }
        double dis = this.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        if (dis >= 1500.0 && !this.getNoMove()) {
            this.teleportSpawnPos(pos);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isClient()) {
            return;
        }
        int heartInterval = this.isHalfHealth((LivingEntity)this) ? 15 : 30;
        this.heartAnimationO = this.heartAnimation;
        if (this.heartAnimation > 0) {
            --this.heartAnimation;
        } else if (this.f_19797_ % heartInterval == 0) {
            this.heartAnimation = 10;
        }
        if (this.getLaser()) {
            this.heartAnimation = 10;
        }
    }

    @Override
    public void targetEmptyStep() {
        if (this.f_19797_ % 20 == 0) {
            this.clearInfo();
        }
    }

    @Override
    public void targetAIStep(LivingEntity target) {
        if (this.recastTime-- > 0) {
            return;
        }
        this.firstAttack(target);
    }

    public void firstAttack(LivingEntity target) {
        ++this.attackTime;
        Level world = this.m_9236_();
        if (this.attackTime == 1) {
            this.attackType = this.rand.nextInt(4);
            if (this.attackType == 3 && this.rand.nextFloat() > 0.5f) {
                this.attackType = this.rand.nextInt(3);
            }
            world.m_7605_((Entity)this, (byte)4);
        }
        switch (this.attackType) {
            case 0: {
                this.defalutAttack(world, target);
                break;
            }
            case 1: {
                this.landingAttack(world, target);
                break;
            }
            case 2: {
                this.meteorAttack(world, target);
                break;
            }
            case 3: {
                this.swingAttack(world, target);
            }
        }
    }

    public void defalutAttack(Level world, LivingEntity target) {
        if (this.checkTime(1, 201)) {
            if (this.attackTime == 1) {
                this.m_6021_(target.m_20185_(), target.m_20186_() + 8.0, target.m_20189_());
                world.m_7605_((Entity)this, (byte)5);
                this.setNoMove(true);
                this.isGround = false;
            }
            if (this.attackTime % 5 == 0) {
                double x = this.m_20185_() + Math.min(0.1, target.m_20185_() - this.m_20185_());
                double y = this.m_20186_() + Math.min(0.1, target.m_20186_() + 8.0 - this.m_20186_());
                double z = this.m_20189_() + Math.min(0.1, target.m_20189_() - this.m_20189_());
                this.m_6021_(x, y, z);
            }
            this.m_20256_(new Vec3(0.0, 0.0, 0.0));
        } else if (this.checkTime(201, 241)) {
            this.m_20256_(new Vec3(0.0, 0.0, 0.0));
        } else if (this.checkTime(241, 522)) {
            if (this.attackTime == 241) {
                this.m_20256_(new Vec3(0.0, -1.0, 0.0));
            } else if (this.m_20096_() && !this.isGround) {
                float effectRange = 64.0f;
                Iterable posList = this.getPosRangeList(this.m_20183_(), 8.0);
                for (BlockPos pos : posList) {
                    if (this.rand.nextFloat() <= 0.67f || !world.m_46859_(pos) || world.m_46859_(pos.m_7495_()) || !this.checkDistance(pos, effectRange)) continue;
                    world.m_7731_(pos, FLAME, 3);
                }
                this.isGround = true;
                this.aX = this.m_20185_();
                this.aY = this.m_20186_();
                this.aZ = this.m_20189_();
                float amount = 60.0f + this.getBuffPower();
                double range = 24.0 + (double)this.getPlayerCount(target) * 0.5;
                List<LivingEntity> attackList = this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer((Entity)target)), range);
                this.attackDamage(attackList, this.getSRC(), amount);
                this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
                if (!(world instanceof ServerLevel)) {
                    return;
                }
                ServerLevel server = (ServerLevel)world;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                int count = 128;
                float rate = 0.5f;
                BlockPos pos = this.m_20183_();
                float x = (float)pos.m_123341_() + this.getRandFloat(0.5f);
                float y = (float)pos.m_123342_() + this.getRandFloat(0.5f);
                float z = (float)pos.m_123343_() + this.getRandFloat(0.5f);
                SimpleParticleType par = ParticleInit.BELIAL_FLAME;
                for (int i = 0; i < count; ++i) {
                    server.m_8767_((ParticleOptions)par, (double)x, (double)y, (double)z, 8, 0.0, 0.0, 0.0, (double)rate);
                }
            } else if (this.isGround) {
                if ((this.aX != this.m_20185_() || this.aY != this.m_20186_() || this.aZ != this.m_20189_()) && this.aX != 0.0 && this.aY != 0.0 && this.aZ != 0.0) {
                    this.m_6021_(this.aX, this.aY, this.aZ);
                }
                if (this.attackTime == 464) {
                    this.m_5496_(SoundEvents.f_215771_, 2.0f, 1.25f);
                    if (!(world instanceof ServerLevel)) {
                        return;
                    }
                    ServerLevel server = (ServerLevel)world;
                    BlockPos pos = this.m_20183_();
                    for (int range = 0; range < 3; ++range) {
                        for (int i = 0; i < 4; ++i) {
                            this.spawnParticleRing(server, (ParticleOptions)ParticleInit.BELIAL_FLAME, 2 + range * 4, pos, -0.25 + (double)i * 0.5);
                        }
                        if (!(this.rand.nextFloat() >= 0.67f)) continue;
                        this.spawnParticleRing(server, (ParticleOptions)ParticleTypes.f_123796_, 2 + range * 4, pos, 0.0);
                    }
                    Iterable posList = this.getPosRangeList(this.m_20183_(), 32.0);
                    for (BlockPos p : posList) {
                        if (world.m_8055_(p).m_60734_() != FLAME.m_60734_()) continue;
                        world.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
                    }
                } else if (this.attackTime == 469) {
                    List<LivingEntity> entityList = this.getPlayerList(target);
                    for (LivingEntity entity : entityList) {
                        entity.m_21153_(Math.max(0.1f, entity.m_21223_() - entity.m_21233_() * 0.1f));
                        this.attackDamage((Entity)entity, this.getSRC(), 30.0f);
                    }
                } else if (this.attackTime == 521) {
                    this.clearInfo();
                    this.recastTime = 50;
                }
            }
        }
    }

    public void landingAttack(Level world, LivingEntity target) {
        if (this.checkTime(1, 282)) {
            if (this.attackTime == 1) {
                world.m_7605_((Entity)this, (byte)6);
                this.setNoMove(true);
                this.isGround = false;
            } else if (this.attackTime == 11) {
                this.m_6021_(target.m_20185_(), target.m_20186_() + 8.0, target.m_20189_());
                this.m_20256_(new Vec3(0.0, 0.0, 0.0));
            } else if (!this.isGround && this.attackTime < 51) {
                this.m_20256_(new Vec3(0.0, 0.0, 0.0));
            } else if (this.attackTime == 51) {
                this.m_20256_(new Vec3(0.0, -1.0, 0.0));
            } else if (this.m_20096_() && !this.isGround) {
                this.isGround = true;
                this.aX = this.m_20185_();
                this.aY = this.m_20186_();
                this.aZ = this.m_20189_();
                this.m_5496_(SoundEvents.f_12089_, 1.0f, 1.0f);
                double range = 32.0 + (double)this.getPlayerCount(target) * 0.75;
                float damage = 35.0f + this.getBuffPower() * 0.67f;
                List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer((Entity)target)), range);
                if (entityList.isEmpty()) {
                    return;
                }
                for (LivingEntity entity : entityList) {
                    int addDamage = (int)(Math.max(1.0, 24.0 - (double)entity.m_20270_((Entity)this)) / 3.0) + 1;
                    for (int i = 0; i < addDamage; ++i) {
                        this.attackDamage((Entity)entity, this.getSRC(), damage);
                    }
                }
                if (!(world instanceof ServerLevel)) {
                    return;
                }
                ServerLevel server = (ServerLevel)world;
                BlockPos pos = this.m_20183_();
                for (int ran = 0; ran < 3; ++ran) {
                    this.spawnParticleRing(server, (ParticleOptions)ParticleTypes.f_123796_, 2 + ran * 4, pos, 0.0);
                }
            } else if (this.isGround) {
                if ((this.aX != this.m_20185_() || this.aY != this.m_20186_() || this.aZ != this.m_20189_()) && this.aX != 0.0 && this.aY != 0.0 && this.aZ != 0.0) {
                    this.m_6021_(this.aX, this.aY, this.aZ);
                }
                if (this.attackTime == 121) {
                    world.m_7605_((Entity)this, (byte)7);
                } else if (this.checkTime(122, 180)) {
                    if (this.attackTime == 122) {
                        this.m_5496_(SoundEvents.f_215772_, 1.0f, 1.0f);
                    }
                    if (!(world instanceof ServerLevel)) {
                        return;
                    }
                    ServerLevel server = (ServerLevel)world;
                    int count = 1 + (this.attackTime - 120) / 10;
                    SimpleParticleType par = ParticleInit.BLOOD;
                    for (int i = 0; i < count; ++i) {
                        float randX = this.randRange(4);
                        float randY = this.getRandFloat(3.0f);
                        float randZ = this.randRange(4);
                        float x = (float)this.m_20185_() + randX;
                        float y = (float)this.m_20186_() + 1.5f + randY;
                        float z = (float)this.m_20189_() + randZ;
                        float xSpeed = -randX * 0.115f;
                        float ySpeed = -randY * 0.115f;
                        float zSpeed = -randZ * 0.115f;
                        server.m_8767_((ParticleOptions)par, (double)x, (double)y, (double)z, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 1.0);
                    }
                } else if (this.checkTime(190, 280)) {
                    if (this.attackTime == 200) {
                        this.m_5496_(SoundEvents.f_215771_, 1.0f, 1.0f);
                    }
                    Vec3 look = this.m_20252_(1.0f);
                    Vec3 src = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82520_(0.0, (double)(this.m_20192_() / 2.0f), 0.0);
                    if (world instanceof ServerLevel) {
                        ServerLevel server = (ServerLevel)world;
                        for (int i = 0; i < 20; ++i) {
                            Vec3 dest = src.m_82520_(look.f_82479_ * (double)i, look.f_82480_, look.f_82481_ * (double)i);
                            float f1 = (float)dest.f_82479_ - 0.5f + this.rand.nextFloat();
                            float f2 = (float)dest.f_82480_ - 1.0f + this.rand.nextFloat();
                            float f3 = (float)dest.f_82481_ - 0.5f + this.rand.nextFloat();
                            float x = (float)(dest.f_82479_ - this.m_20185_()) / 10.0f;
                            float y = (float)(dest.f_82480_ - this.m_20186_()) / 10.0f;
                            float z = (float)(dest.f_82481_ - this.m_20189_()) / 10.0f;
                            server.m_8767_((ParticleOptions)ParticleInit.BELIAL_FLAME, (double)f1, (double)f2, (double)f3, 0, (double)x, (double)y, (double)z, 1.0);
                            if (i % 2 != 0 || this.attackTime != 200) continue;
                            server.m_8767_((ParticleOptions)ParticleInit.CYCLONE, dest.f_82479_, dest.f_82480_, dest.f_82481_, 0, 0.0, 0.0, 0.0, 1.0);
                        }
                    }
                    if (this.attackTime % 5 == 0) {
                        float damage = 10.0f + this.getBuffPower() * 0.5f;
                        boolean isPlayer = this.isPlayer((Entity)target);
                        ArrayList<LivingEntity> entityAllList = new ArrayList<LivingEntity>();
                        for (double i = 0.0; i < 30.0; i += 0.5) {
                            Vec3 dest = src.m_82520_(look.f_82479_ * i, look.f_82480_ * i, look.f_82481_ * i);
                            List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer, entityAllList), dest, 1.0);
                            entityAllList.addAll(entityList);
                            this.attackDamage(entityList, this.getDamage((Entity)this, SMDamage.flameDamage), damage);
                        }
                    }
                } else if (this.attackTime == 281) {
                    this.clearInfo();
                    this.recastTime = 50;
                }
            }
        }
    }

    public void meteorAttack(Level world, LivingEntity target) {
        block14: {
            block9: {
                block11: {
                    ServerLevel server;
                    block13: {
                        block12: {
                            block10: {
                                if (!this.checkTime(1, 120)) break block9;
                                if (this.attackTime != 1) break block10;
                                world.m_7605_((Entity)this, (byte)8);
                                this.setNoMove(true);
                                this.aX = this.m_20185_();
                                this.aY = this.m_20186_();
                                this.aZ = this.m_20189_();
                                break block11;
                            }
                            if (!this.checkTime(40, 101)) break block11;
                            if (this.attackTime == 40) {
                                this.m_5496_(SoundEvents.f_11705_, 1.0f, 0.67f);
                            }
                            float damage = 15.0f;
                            int countUp = 0;
                            BlockPos targetPos = WorldHelper.offset(this.m_20183_(), this.getRandFloat(32.0f), 24.0, this.getRandFloat(32.0f));
                            while (world.m_46859_(targetPos = targetPos.m_7494_()) && ++countUp < 24) {
                            }
                            BelialFlameShot magic = new BelialFlameShot((LivingEntity)this);
                            magic.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, 0.0f, 0.0f);
                            magic.setRange(5.0);
                            magic.m_6034_(targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_());
                            magic.setAddDamage(magic.getAddDamage() + damage);
                            magic.m_20256_(new Vec3(0.0, -1.0, 0.0));
                            magic.setAddDamage(magic.getAddDamage() + 30.0f + this.getBuffPower() * 0.67f);
                            magic.setHitDead(false);
                            this.addEntity((Entity)magic);
                            if (!(world instanceof ServerLevel)) break block12;
                            server = (ServerLevel)world;
                            if (this.attackTime % 6 == 0) break block13;
                        }
                        return;
                    }
                    int count = 16;
                    BlockPos pos = this.m_20183_();
                    SimpleParticleType par = ParticleInit.CYCLE_BELIAL_TORNADO;
                    for (int y = -40; y < 8; ++y) {
                        for (int i = 0; i < count; ++i) {
                            this.spawnParticleCycle(server, (ParticleOptions)par, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.5 + this.rand.nextDouble() * 1.5 + (double)y * 0.5, (double)pos.m_123343_() + 0.5, Direction.UP, 2.0, (float)i * 16.0f + (float)(y * 15), false);
                        }
                    }
                }
                if ((this.aX != this.m_20185_() || this.aY != this.m_20186_() || this.aZ != this.m_20189_()) && this.aX != 0.0 && this.aY != 0.0 && this.aZ != 0.0) {
                    this.m_6021_(this.aX, this.aY, this.aZ);
                }
                break block14;
            }
            this.clearInfo();
            this.recastTime = 30;
        }
    }

    public void swingAttack(Level world, LivingEntity target) {
        if (this.checkTime(1, 80)) {
            if (this.attackTime == 1) {
                world.m_7605_((Entity)this, (byte)9);
                this.setNoMove(true);
                this.aX = this.m_20185_();
                this.aY = this.m_20186_();
                this.aZ = this.m_20189_();
            } else if (this.attackTime == 35) {
                List<BelialSword> swordList = this.getEntityList(BelialSword.class, (T e) -> e.m_19749_() == this, 64.0);
                swordList.forEach(e -> e.m_146870_());
                double x = target.m_20185_() - this.m_20185_();
                double y = target.m_20227_(0.3333333333333333) - this.m_20186_() - 5.0;
                double z = target.m_20189_() - this.m_20189_();
                double xz = Math.sqrt(x * x + z * z);
                BelialSword sword = new BelialSword((LivingEntity)this);
                sword.m_6686_(x, y - xz * 0.065, z, 2.0f, 0.0f);
                sword.m_6034_(this.m_20185_(), this.m_20186_() + 6.0, this.m_20189_());
                sword.setAddDamage(sword.getAddDamage() + 60.0f + this.getBuffPower());
                sword.setHitDead(false);
                sword.setCharge(true);
                this.addEntity((Entity)sword);
            } else if (this.attackTime == 72) {
                List<BelialSword> swordList = this.getEntityList(BelialSword.class, (T e) -> e.m_19749_() == this && e.getCharge(), 64.0);
                swordList.get(0).setCharge(false);
                this.m_5496_(SoundInit.KNIFE_SHOT, 0.5f, 0.9f);
            }
            if ((this.aX != this.m_20185_() || this.aY != this.m_20186_() || this.aZ != this.m_20189_()) && this.aX != 0.0 && this.aY != 0.0 && this.aZ != 0.0) {
                this.m_6021_(this.aX, this.aY, this.aZ);
            }
        } else {
            this.clearInfo();
            this.recastTime = 20;
        }
    }

    @Override
    public void attackDamage(Entity entity, DamageSource src, float damage) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            damage = living.m_21023_(PotionInit.belial_flame) ? 1.5f : 1.0f;
        }
        entity.m_6469_(src, entity instanceof Warden ? damage * 5.0f : damage);
        entity.f_19802_ = 0;
    }

    @Override
    public float getBuffPower() {
        float baseDamage = (float)this.m_21133_(Attributes.f_22281_);
        baseDamage = this.getHalfHealthFlag() ? baseDamage * 2.5f : baseDamage;
        return super.getBuffPower() + baseDamage;
    }

    public boolean checkTime(int start, int end) {
        return this.attackTime >= start && this.attackTime < end;
    }

    public float getHeartAnimation(float patTick) {
        return Mth.m_14179_((float)patTick, (float)this.heartAnimationO, (float)this.heartAnimation) / 10.0f;
    }

    @Override
    public void spawnParticleRing(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double addY) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0 + addY;
        double z = (double)pos.m_123343_() + 0.5;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.25) {
            double rate = range * 0.75;
            server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, Math.cos(degree) * 0.85, (double)(this.rand.nextFloat() * 0.25f), Math.sin(degree) * 0.85, 1.0);
        }
    }

    @Override
    public void deathEffect() {
        Level level;
        if (this.f_20919_ == 1) {
            this.recastTime = 12;
            this.m_9236_().m_7605_((Entity)this, (byte)10);
        }
        if (this.f_20919_ >= this.getMaxDeathTime() - 10) {
            return;
        }
        float rate = (float)this.f_20919_ / (float)this.getMaxDeathTime();
        if (this.recastTime-- <= 0) {
            this.m_5496_(SoundEvents.f_215762_, 3.0f * (1.25f - rate), 1.0f);
            int n = this.recastTime = this.f_20919_ <= 90 ? 12 : 12 + this.f_20919_ / 10;
        }
        if (this.f_20919_ % 5 != 0 || !((level = this.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)level;
        SimpleParticleType par = ParticleInit.DIVINE;
        BlockPos pos = this.m_20183_();
        for (int i = 0; i < 16; ++i) {
            float x = (float)pos.m_123341_() + 0.5f + this.getRandFloat(2.25f);
            float y = (float)pos.m_123342_() + 0.5f + this.getRandFloat(1.0f);
            float z = (float)pos.m_123343_() + 0.5f + this.getRandFloat(2.25f);
            sever.m_8767_((ParticleOptions)par, (double)x, (double)y, (double)z, 0, (double)this.getRandFloat(0.3f), (double)(0.25f + this.rand.nextFloat() * 0.5f), (double)this.getRandFloat(0.3f), 1.0);
        }
    }

    @Override
    public int getMaxDeathTime() {
        return 240;
    }

    @Override
    public void clearInfo() {
        this.setNoMove(false);
        this.attackTime = 0;
        this.isGround = false;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
    }

    public boolean checkDistance(BlockPos pos, double range) {
        return this.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) <= range;
    }

    public Predicate<LivingEntity> getFilter(boolean isPlayer, List<LivingEntity> entityAllList) {
        return e -> !e.m_5833_() && e.m_6084_() && !(e instanceof ISMMob) && (isPlayer ? e instanceof Player || e instanceof AbstractSummonMob : !(e instanceof Player)) && !entityAllList.contains(e);
    }

    public void m_6667_(DamageSource src) {
        super.m_6667_(src);
        List<BelialSword> targetList = this.getEntityList(BelialSword.class, 64.0);
        targetList.forEach(e -> e.m_146870_());
        List<StellaWizard> wizardList = this.getEntityList(StellaWizard.class, (T e) -> e.getDemons(), 64.0);
        wizardList.forEach(e -> e.setMaxLifeTime(e.f_19797_));
    }
}

