/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.BlockInit;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.monster.GemStone;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.BubleFrogshot;
import sweetmagic.init.entity.projectile.GemShot;

public class GemFrog
extends AbstractSMBoss {
    public boolean isNotGround = false;
    public final AnimationState jumpState = new AnimationState();
    public final AnimationState gemState = new AnimationState();
    public final AnimationState eatState = new AnimationState();
    public final AnimationState bubleState = new AnimationState();
    public int attackType = -1;
    public int secondAttackType = -1;
    public int jumpAttackTime = 140;
    public static final int MAX_JUMPATTACK_TIME = 200;
    public int gemAttackTime = 110;
    public static final int MAX_GEMATTACK_TIME = 150;
    public int secondAttackTime = 0;
    public static final int MAX_SECONDATTACK_TIME = 300;
    private static final EntityDataAccessor<Boolean> GEMARMOR = ISMMob.setData(AbstractSMBoss.class, BOOLEAN);

    public GemFrog(Level world) {
        super(EntityInit.gemFrog, world);
    }

    public GemFrog(EntityType<? extends AbstractSMBoss> enType, Level world) {
        super(enType, world);
        this.setBossEvent(BC_BLUE, NOTCHED_6);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 600.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 96.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(GEMARMOR, false);
    }

    public void setGemArmor(boolean gemArmor) {
        this.set(GEMARMOR, gemArmor);
    }

    public boolean getGemArmor() {
        return (Boolean)this.get(GEMARMOR);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("gemArmor", this.getGemArmor());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setGemArmor(tags.m_128471_("gemArmor"));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_215690_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_215693_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_215691_;
    }

    protected void m_267689_(float par) {
        float f = 0.0f;
        if (!this.jumpState.m_216984_()) {
            f = Math.min(par * 25.0f, 1.0f);
        }
        this.f_267362_.m_267566_(f, 0.4f);
    }

    public void m_7822_(byte par1) {
        switch (par1) {
            case 4: {
                this.jumpState.m_216973_();
                this.gemState.m_216973_();
                this.eatState.m_216973_();
                this.bubleState.m_216973_();
                break;
            }
            case 5: {
                this.animationAction(this.jumpState);
                break;
            }
            case 6: {
                this.animationAction(this.gemState);
                break;
            }
            case 7: {
                this.animationAction(this.eatState);
                break;
            }
            case 8: {
                this.animationAction(this.bubleState);
                break;
            }
            default: {
                super.m_7822_(par1);
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (this.isSMMobSRC(src)) {
            return false;
        }
        int n = this.defTime = (amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, 6.0f)) > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, this.getSRC(), amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        return super.m_6469_(src, amount);
    }

    public void m_7023_(Vec3 vec) {
        if (this.m_20096_() && this.getStan()) {
            return;
        }
        super.m_7023_(vec);
    }

    @Override
    public void targetAIStep(LivingEntity target) {
        if (this.f_19797_ % 10 == 0 && this.getStan()) {
            Level level;
            if (this.stanTime++ > 40) {
                this.setStan(false);
                this.stanTime = 0;
            }
            if (this.f_19797_ % 30 == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                int count = 16;
                BlockPos pos = this.m_20183_().m_6630_(5);
                Random rand = new Random();
                SimpleParticleType par = ParticleInit.CYCLE_REFLASH;
                for (int i = 0; i < count; ++i) {
                    this.spawnParticleCycle(server, (ParticleOptions)par, this.m_20185_(), this.m_20186_() + 2.5, this.m_20189_(), Direction.UP, 2.5, (float)i * 22.5f, false);
                }
            }
        }
        this.firstAttack(target);
        if (this.isHalfHealth((LivingEntity)this)) {
            this.secondAttack(target);
        }
    }

    public void firstAttack(LivingEntity target) {
        Level world = this.m_9236_();
        if (this.attackType == -1) {
            this.attackType = this.rand.nextInt(2);
            if (this.attackType == 1) {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
        }
        switch (this.attackType) {
            case 0: {
                this.jumpAttack(world, target);
                break;
            }
            case 1: {
                this.gemAttack(world, target);
            }
        }
    }

    public void secondAttack(LivingEntity target) {
        if (this.secondAttackTime == 1) {
            List<GemStone> gemList = this.getEntityList(GemStone.class, 48.0);
            this.secondAttackType = !gemList.isEmpty() && !this.getGemArmor() && this.getHealthArmor() <= 0.0f ? 1 : 0;
            this.m_9236_().m_7605_((Entity)this, (byte)4);
        }
        if (this.secondAttackType == 0 && this.secondAttackTime == 180) {
            this.m_9236_().m_7605_((Entity)this, (byte)8);
        } else if (this.secondAttackType == 1 && this.secondAttackTime == 280) {
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        }
        if (this.secondAttackTime++ < 300) {
            return;
        }
        Level world = this.m_9236_();
        switch (this.secondAttackType) {
            case 0: {
                this.bubleAttack(world, target);
                break;
            }
            case 1: {
                this.gemEatAttack(world, target);
            }
        }
    }

    public void jumpAttack(Level world, LivingEntity target) {
        if (this.jumpAttackTime++ < 200) {
            return;
        }
        if (this.jumpAttackTime == 201) {
            world.m_7605_((Entity)this, (byte)5);
            double x = (target.f_19854_ - this.f_19854_) * 0.11;
            double z = (target.f_19856_ - this.f_19856_) * 0.11;
            this.m_20256_(new Vec3(x, 1.5, z));
        } else if (this.jumpAttackTime >= 202) {
            if (!this.m_20096_()) {
                this.isNotGround = true;
            } else if (this.m_20096_() && this.isNotGround) {
                int i;
                this.jumpAttackTime = 0;
                this.attackType = -1;
                this.isNotGround = false;
                world.m_7605_((Entity)this, (byte)4);
                float amount = 40.0f + this.getBuffPower();
                double range = 6.0 + (double)this.getPlayerCount(target) * 0.5;
                List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer((Entity)target)), range);
                entityList.forEach(e -> this.attackDamage((Entity)e, this.getSRC(), amount));
                List<GemStone> gemList = this.getEntityList(GemStone.class, 48.0);
                if (this.isHalfHealth((LivingEntity)this) && !this.getGemArmor() && gemList.isEmpty()) {
                    List<LivingEntity> targetList = this.getPlayerList(target);
                    int count = (int)Math.min(10.0f, 3.0f + this.getPlayerCount(targetList) * 2.0f);
                    BlockPos pos = this.getSpawnPos();
                    for (i = 0; i < count; ++i) {
                        int setPosCount = 0;
                        BlockPos targetPos = new BlockPos(pos.m_123341_() + this.getRand(this.rand, 16), pos.m_123342_(), pos.m_123343_() + this.getRand(this.rand, 16));
                        GemStone gem = new GemStone(world);
                        while (!world.m_46859_(targetPos) && !world.m_8055_(targetPos).m_60713_(BlockInit.rune_character)) {
                            targetPos = new BlockPos(targetPos.m_123341_() + this.getRand(this.rand, 3), targetPos.m_123342_(), targetPos.m_123343_() + this.getRand(this.rand, 3));
                            if (setPosCount++ < 16) continue;
                        }
                        gem.m_6034_((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5);
                        gem.setOwnerID((LivingEntity)this);
                        if (this.isClient()) continue;
                        this.addEntity((Entity)gem);
                        gem.m_5496_(SoundEvents.f_144048_, 1.0f, 0.8f + this.rand.nextFloat() * 0.4f);
                    }
                }
                this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
                if (!(world instanceof ServerLevel)) {
                    return;
                }
                ServerLevel server = (ServerLevel)world;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                BlockPos attackPos = this.m_20183_();
                BlockParticleOption par = new BlockParticleOption(ParticleTypes.f_123794_, world.m_8055_(attackPos.m_7495_()));
                for (i = 0; i < 4; ++i) {
                    this.spawnParticleRing(server, (ParticleOptions)par, 6.5, new BlockPos(attackPos.m_123341_(), attackPos.m_123342_() - 2 + i, attackPos.m_123343_()), 1.25, 0.25, 0.0);
                }
            }
        }
    }

    public void gemAttack(Level world, LivingEntity target) {
        if (this.gemAttackTime++ < 150) {
            return;
        }
        this.gemAttackTime = 0;
        this.attackType = -1;
        world.m_7605_((Entity)this, (byte)4);
        float damage = 20.0f + this.getBuffPower();
        float shotSpeed = 0.75f;
        int shotRange = 90;
        int count = 15;
        int angle = 12 * (count - 1) / 2;
        world.m_7605_((Entity)this, (byte)6);
        for (int i = 0; i < count; ++i) {
            GemShot entity = new GemShot((LivingEntity)this);
            double x = target.m_20185_() - this.m_20185_();
            double z = target.m_20189_() - this.m_20189_();
            double y = target.m_20227_(0.3333333333333333) - this.m_20186_() - 2.0;
            Vector3f vec = this.getShotVector((Mob)this, new Vec3(x, y, z), -angle + i * angle / 2);
            entity.m_6686_(vec.x(), vec.y(), vec.z(), shotSpeed, 0.0f);
            entity.setAddDamage(entity.getAddDamage() + damage);
            entity.setMaxLifeTime(shotRange);
            entity.setRange(5.0);
            this.addEntity((Entity)entity);
        }
    }

    public void bubleAttack(Level world, LivingEntity target) {
        world.m_7605_((Entity)this, (byte)8);
        this.secondAttackTime = 0;
        float amount = 50.0f + this.getBuffPower();
        double range = 24.0 + (double)this.getPlayerCount(target) * 0.5;
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer((Entity)target)), range);
        for (LivingEntity entity : entityList) {
            double x = entity.m_20185_() - this.m_20185_();
            double y = entity.m_20227_(0.3333333333333333) - this.m_20186_();
            double z = entity.m_20189_() - this.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            BubleFrogshot magic = new BubleFrogshot((LivingEntity)this);
            magic.m_6686_(x, y - xz * 0.065, z, 1.5f, 0.75f);
            magic.setAddDamage(magic.getAddDamage() + 10.0f);
            magic.setTarget((Entity)entity);
            magic.setRange(2.0);
            this.addEntity((Entity)magic);
        }
    }

    public void gemEatAttack(Level world, LivingEntity target) {
        List<GemStone> gemList = this.getEntityList(GemStone.class, 48.0);
        int count = gemList.size();
        gemList.forEach(e -> e.m_146870_());
        this.setHealthArmor(this.m_21233_() * (0.1f * (float)count));
        this.setMaxHealthArmor(this.getHealthArmor());
        this.setGemArmor(true);
        this.secondAttackTime = 0;
        world.m_7605_((Entity)this, (byte)7);
        this.addPotion((LivingEntity)this, MobEffects.f_19600_, 2400, 1);
    }

    @Override
    public void armorBreak() {
        this.setStan(true);
        this.setGemArmor(false);
        this.secondAttackTime = 0;
        this.gemAttackTime = 0;
        this.jumpAttackTime = 0;
        this.stanTime = 0;
    }

    public boolean isEmptyArmor() {
        return this.getMaxHealthArmor() > 0.0f && this.getHealthArmor() <= 0.0f;
    }

    @Override
    public void clearInfo() {
        this.tickTime = 0;
    }

    protected int getRand(Random rand, int range) {
        return rand.nextInt(range) - rand.nextInt(range);
    }
}

