/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.CycloneMagicShot;
import sweetmagic.init.entity.projectile.DigMagicShot;
import sweetmagic.init.entity.projectile.FireMagicShot;
import sweetmagic.init.entity.projectile.FrostMagicShot;
import sweetmagic.init.entity.projectile.GravityMagicShot;
import sweetmagic.init.entity.projectile.KnifeShot;
import sweetmagic.init.entity.projectile.SickleShot;

public class WhiteButler
extends AbstractSMBoss {
    private UUID ownerID;
    private LivingEntity owner;
    public int attackCount = 0;
    public int rifleCount = 0;
    private int knifeTick = 0;
    private static final int MAX_KNIFE_TICK = 140;
    private int sickleTick = 0;
    private static final int MAX_SICKLE_TICK = 360;
    private int rifleTick = 0;
    private static final int MAX_RIFLE_TICK = 320;
    private static final EntityDataAccessor<Boolean> ALIVE = ISMMob.setData(WhiteButler.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> KNIFE = ISMMob.setData(WhiteButler.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> SICKLE = ISMMob.setData(WhiteButler.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> RIFLE = ISMMob.setData(WhiteButler.class, BOOLEAN);

    public WhiteButler(Level world) {
        super(EntityInit.whiteButler, world);
    }

    public WhiteButler(EntityType<? extends AbstractSMBoss> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 400;
        this.setBossEvent(BC_BLUE, NOTCHED_6);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 64.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(ALIVE, false);
        this.define(KNIFE, false);
        this.define(SICKLE, false);
        this.define(RIFLE, false);
    }

    public boolean getAlive() {
        return (Boolean)this.get(ALIVE);
    }

    public void setAlive(boolean isAlive) {
        this.set(ALIVE, isAlive);
    }

    public boolean getKnife() {
        return (Boolean)this.get(KNIFE);
    }

    public void setKnife(boolean hasKnife) {
        this.set(KNIFE, hasKnife);
    }

    public boolean getSickle() {
        return (Boolean)this.get(SICKLE);
    }

    public void setSickle(boolean hasSickle) {
        this.set(SICKLE, hasSickle);
    }

    public boolean getRifle() {
        return (Boolean)this.get(RIFLE);
    }

    public void setRifle(boolean hasRifle) {
        this.set(RIFLE, hasRifle);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("isAlive", this.m_6084_());
        tags.m_128379_("hasKnife", this.getKnife());
        tags.m_128379_("hasSickle", this.getSickle());
        tags.m_128379_("hasRifle", this.getRifle());
        tags.m_128379_("isHalfHealth", this.getHalfHealthFlag());
        if (this.getOwnerID() != null) {
            tags.m_128362_("ownerID", this.getOwnerID());
        }
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.m_20282_(tags.m_128471_("isAlive"));
        this.setKnife(tags.m_128471_("hasKnife"));
        this.setSickle(tags.m_128471_("hasSickle"));
        this.setRifle(tags.m_128471_("hasRifle"));
        this.setHalfHealth(tags.m_128471_("isHalfHealth"));
        if (tags.m_128441_("ownerID")) {
            this.setOwnerID(tags.m_128342_("ownerID"));
        }
    }

    public UUID getOwnerID() {
        return this.ownerID;
    }

    @Override
    public void setOwnerID(LivingEntity entity) {
        this.ownerID = entity.m_20148_();
    }

    public void setOwnerID(UUID id) {
        this.ownerID = id;
    }

    public LivingEntity getEntity() {
        Level level;
        LivingEntity entity = this.owner;
        if (entity == null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            entity = (LivingEntity)server.m_8791_(this.getOwnerID());
        }
        return entity;
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (this.isSMMobSRC(src)) {
            return false;
        }
        int n = this.defTime = (amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, 8.0f)) > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, this.getSRC(), amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (amount > 1.0f) {
            ++this.knifeTick;
            ++this.rifleTick;
        }
        return super.m_6469_(src, amount);
    }

    @Override
    public void targetAIStep(LivingEntity target) {
        if (this.isHalfHealth((LivingEntity)this) && !this.getHalfHealthFlag()) {
            this.setHalfHealth(true);
        }
        this.firstAttack(target);
        if (this.isHalfHealth((LivingEntity)this) || this.getHalfHealthFlag()) {
            this.secondAttack(target);
        }
        if (!this.m_6084_()) {
            ++this.knifeTick;
            ++this.sickleTick;
            ++this.rifleTick;
        }
        if (this.m_21023_(PotionInit.recast_reduction)) {
            ++this.knifeTick;
            ++this.sickleTick;
            ++this.rifleTick;
        }
    }

    public void firstAttack(LivingEntity target) {
        if (this.knifeTick > 40 && !this.getKnife()) {
            this.setKnife(true);
        }
        if (this.knifeTick++ >= 140) {
            this.knifeAttack(target);
        }
        if (this.sickleTick > 200 && !this.getSickle()) {
            this.setSickle(true);
        }
        if (this.attackCount > 3 && this.sickleTick++ >= 360) {
            this.sickleAttack(target);
        }
    }

    public void secondAttack(LivingEntity target) {
        if (this.rifleTick > 0 && !this.getRifle()) {
            this.setRifle(true);
        }
        if (this.rifleTick++ >= 320 && this.f_19797_ % 12 == 0) {
            this.rifleAttack(target);
        }
        if (this.f_19797_ % 10 == 0 && this.getOwnerID() != null && this.getAlive()) {
            LivingEntity entity = this.getEntity();
            if (entity != null && entity.m_6084_()) {
                return;
            }
            this.setAlive(false);
            this.m_5634_(this.m_21233_() * 0.5f);
            this.addPotion((LivingEntity)this, MobEffects.f_19600_, 9999, 2);
        }
    }

    public void knifeAttack(LivingEntity target) {
        List<LivingEntity> targetList = this.getPlayerList(target);
        if (targetList.isEmpty()) {
            return;
        }
        for (LivingEntity entity : targetList) {
            double x = entity.m_20185_() - this.m_20185_();
            double y = entity.m_20227_(0.3333333333333333) - this.m_20186_();
            double z = entity.m_20189_() - this.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            KnifeShot knife = new KnifeShot((LivingEntity)this);
            knife.setHitDead(false);
            knife.m_6686_(x, y - xz * 0.065, z, 1.5f, 2.0f);
            knife.setAddDamage(knife.getAddDamage() + 6.0f);
            this.addEntity((Entity)knife);
        }
        this.attackCount += targetList.size();
        this.knifeTick = 0;
        this.setKnife(false);
        this.m_5496_(SoundInit.KNIFE_SHOT, 0.5f, 0.9f);
    }

    public void sickleAttack(LivingEntity target) {
        double range = 3.5 + (double)this.attackCount * 0.25 + (double)this.getPlayerCount(target) * 0.1;
        double x = target.m_20185_() - this.m_20185_();
        double z = target.m_20189_() - this.m_20189_();
        SickleShot entity = new SickleShot((LivingEntity)this);
        entity.setHitDead(false);
        entity.m_6686_(x, 0.0, z, 1.75f, 2.0f);
        entity.setAddDamage(entity.getAddDamage() + 12.0f);
        entity.setRange(range);
        entity.setMaxLifeTime(500);
        this.addEntity((Entity)entity);
        this.attackCount = 0;
        this.sickleTick = 0;
        this.setSickle(false);
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
    }

    public void rifleAttack(LivingEntity target) {
        this.m_5496_(SoundInit.RIFLE_SHOT, 0.2f, 0.85f);
        this.getPlayerList(target).forEach(e -> this.addEntity((Entity)this.getMagicShot((LivingEntity)e, this.rifleCount, e instanceof Warden)));
        if (this.rifleCount++ >= 5) {
            this.rifleCount = 0;
            this.rifleTick = 0;
            this.setRifle(false);
        }
    }

    public AbstractMagicShot getMagicShot(LivingEntity target, int count, boolean isWarden) {
        float dama = isWarden ? 30.0f : 5.0f;
        float dameRate = isWarden ? 1.5f : 1.0f;
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20227_(0.3333333333333333) - this.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double xz = Math.sqrt(x * x + z * z);
        int level = isWarden ? 20 : 5;
        AbstractMagicShot entity = switch (count) {
            case 1 -> new FrostMagicShot((LivingEntity)this);
            case 2 -> new GravityMagicShot((LivingEntity)this);
            case 3 -> new CycloneMagicShot((LivingEntity)this);
            case 4 -> new DigMagicShot((LivingEntity)this);
            default -> new FireMagicShot((LivingEntity)this);
        };
        entity.setWandLevel(level);
        entity.m_6686_(x, y - xz * 0.065, z, 1.75f, 2.0f);
        entity.setAddDamage((entity.getAddDamage() + dama) * dameRate);
        entity.setHitDead(false);
        return entity;
    }

    @Override
    public void startInfo() {
        super.startInfo();
        this.knifeTick = 120;
        this.sickleTick = 400;
        this.rifleTick = 200;
    }

    @Override
    public void clearInfo() {
    }
}

