/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.ai.BubleExplosionGoal;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class BubbleMagicShot
extends AbstractMagicShot {
    public BubbleMagicShot(EntityType<? extends BubbleMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public BubbleMagicShot(double x, double y, double z, Level world) {
        this((EntityType<? extends BubbleMagicShot>)EntityInit.bubbleMagic, world);
        this.m_6034_(x, y, z);
    }

    public BubbleMagicShot(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(info);
    }

    public BubbleMagicShot(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void entityHit(LivingEntity living) {
        int time = 10 * this.getWandLevel();
        if (this.canTargetEffect(living, this.m_19749_())) {
            this.addPotion(living, PotionInit.bubble, time, this.getData());
        } else {
            living.m_21195_(PotionInit.bubble);
        }
        this.m_5496_(SoundInit.BUBBLE, 0.1f, 1.0f);
        if (this.getData() == 3 && living instanceof Mob) {
            Mob mob = (Mob)living;
            List<WrappedGoal> goalList = mob.f_21345_.m_148105_().stream().filter(e -> e.m_26015_() instanceof BubleExplosionGoal).toList();
            if (goalList.isEmpty()) {
                mob.f_21345_.m_25352_(0, (Goal)new BubleExplosionGoal(mob, this.m_19749_(), (Entity)this, this.getDamage(), time - 1));
            } else {
                BubleExplosionGoal goal = (BubleExplosionGoal)goalList.get(0).m_26015_();
                goal.clearInfo(time - 1, goal.damage * 1.25f);
            }
        }
        if (this.getKey() && this.getData() > 3) {
            this.addAttack(living, this.getDamage(), 1 + (int)(this.getRange() / 2.0));
        }
        if (this.isBoss((Entity)living)) {
            this.addAttack(living, this.getDamage(), 1 + this.getData());
        }
    }

    @Override
    protected void spawnParticleShort(ServerLevel sever, BlockPos pos) {
        float x = (float)pos.m_123341_() + this.getRandFloat(0.5f);
        float y = (float)pos.m_123342_() + this.getRandFloat(0.5f);
        float z = (float)pos.m_123343_() + this.getRandFloat(0.5f);
        for (int i = 0; i < 4; ++i) {
            sever.m_8767_((ParticleOptions)ParticleInit.BUBBLE, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.15f);
        }
    }

    @Override
    public int getMinParticleTick() {
        return 3;
    }

    @Override
    protected void spawnParticle() {
        Random rand = new Random();
        Vec3 vec = this.m_20184_();
        for (int i = 0; i < 5; ++i) {
            float x = (float)(-vec.f_82479_) / 20.0f + this.getRandFloat(0.085f);
            float y = (float)(-vec.f_82480_) / 20.0f + this.getRandFloat(0.085f);
            float z = (float)(-vec.f_82481_) / 20.0f + this.getRandFloat(0.085f);
            float f1 = (float)(this.m_20185_() - 0.5 + (double)rand.nextFloat() + vec.f_82479_ * (double)i * 0.25);
            float f2 = (float)(this.m_20186_() - 0.25 + (double)rand.nextFloat() * 0.5 + vec.f_82480_ * (double)i * 0.25);
            float f3 = (float)(this.m_20189_() - 0.5 + (double)rand.nextFloat() + vec.f_82481_ * (double)i * 0.25);
            this.addParticle((ParticleOptions)ParticleInit.BUBBLE, f1, f2, f3, x, y, z);
        }
    }

    @Override
    public SMElement getElement() {
        return SMElement.WATER;
    }

    @Override
    public SMElement getSubElement() {
        return this.getData() >= 3 ? SMElement.BLAST : null;
    }
}

