/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class BubleFrogshot
extends AbstractMagicShot {
    private static final EntityDataAccessor<Integer> TARGET = BubleFrogshot.setEntityData(ISMMob.INT);

    public BubleFrogshot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public BubleFrogshot(double x, double y, double z, Level world) {
        this(EntityInit.bubleFrogShot, world);
        this.m_6034_(x, y, z);
    }

    public BubleFrogshot(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(TARGET, -1);
    }

    @Override
    public void m_8119_() {
        Entity target;
        if (!this.isClient()) {
            this.updateTarget();
        }
        if ((target = this.getTarget()) != null) {
            Vec3 vec = this.m_20184_();
            double mX = vec.m_7096_();
            double mY = vec.m_7098_();
            double mZ = vec.m_7094_();
            Vec3 arrowVec = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            Vec3 lookVec = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_()).m_82546_(arrowVec);
            Vec3 arrowMotion = new Vec3(mX, mY, mZ);
            double theta = this.wrap180Radian(this.angleBetween(arrowMotion, lookVec));
            theta = this.clampAbs(theta, 1.5707963267948966);
            Vec3 crossVec = arrowMotion.m_82537_(lookVec).m_82541_();
            Vec3 adjustedVec = this.transform(crossVec, theta, arrowMotion);
            this.m_6686_(adjustedVec.f_82479_, adjustedVec.f_82480_, adjustedVec.f_82481_, 1.0f, 0.0f);
            this.m_20256_(this.m_20184_().m_82490_((double)1.1f));
        }
        super.m_8119_();
    }

    private void updateTarget() {
        Entity target = this.getTarget();
        if (target != null && !target.m_6084_()) {
            target = null;
            this.setTarget(null);
        }
        if (target != null) {
            return;
        }
        Entity owner = this.m_19749_();
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> this.canTargetEffect((LivingEntity)e, owner) && e.m_6084_(), this.getRange());
        if (entityList.isEmpty()) {
            return;
        }
        double distance = this.getRange() + 1.0;
        for (LivingEntity entity : entityList) {
            if (!(distance >= (double)entity.m_20270_((Entity)this))) continue;
            this.setTarget((Entity)entity);
        }
    }

    @Nullable
    public Entity getTarget() {
        return this.m_9236_().m_6815_(this.get(TARGET).intValue());
    }

    public void setTarget(Entity entity) {
        this.set(TARGET, entity == null ? -1 : entity.m_19879_());
    }

    @Override
    protected void entityHit(LivingEntity target) {
        this.rangeAttack(target.m_20183_(), this.getDamage(), this.getRange());
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        this.rangeAttack(result.m_82425_().m_7494_(), this.getDamage() * 0.67f, this.getRange() * (double)0.67f);
        this.m_146870_();
    }

    public void rangeAttack(BlockPos pos, float dame, double range) {
        List<LivingEntity> entityList;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123812_, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), 2, 0.0, 0.0, 0.0, 0.0);
        }
        if ((entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range)).isEmpty()) {
            return;
        }
        double effectRange = range * range;
        this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
        for (LivingEntity entity : entityList) {
            if (!this.checkDistance(entity.m_20183_(), effectRange)) continue;
            this.attackDamage(entity, dame, false);
        }
    }

    @Override
    protected void spawnParticle() {
        Random rand = new Random();
        Vec3 vec = this.m_20184_();
        for (int i = 0; i < 5; ++i) {
            float x = (float)(-vec.f_82479_) / 20.0f + this.getRandFloat(0.085f);
            float y = (float)(-vec.f_82480_) / 20.0f + this.getRandFloat(0.085f);
            float z = (float)(-vec.f_82481_) / 20.0f + this.getRandFloat(0.085f);
            float f1 = (float)(this.m_20185_() - 0.5 + (double)rand.nextFloat() + vec.f_82479_ * (double)i * 0.25);
            float f2 = (float)(this.m_20186_() - 0.25 + (double)rand.nextFloat() * 0.5 + vec.f_82480_ * (double)i * 0.25);
            float f3 = (float)(this.m_20189_() - 0.5 + (double)rand.nextFloat() + vec.f_82481_ * (double)i * 0.25);
            this.addParticle((ParticleOptions)ParticleInit.BUBBLE, f1, f2, f3, x, y, z);
        }
    }

    @Override
    public SMElement getElement() {
        return SMElement.BLAST;
    }
}

