/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class CommetBulet
extends AbstractMagicShot {
    private static final EntityDataAccessor<Integer> TARGET = CommetBulet.setEntityData(ISMMob.INT);
    private static final EntityDataAccessor<Boolean> CHARGE = CommetBulet.setEntityData(ISMMob.BOOLEAN);
    private Direction moveFace;
    private int step;
    private double targetX;
    private double targetY;
    private double targetZ;

    public CommetBulet(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
        this.setBlockPenetration(true);
        this.setMaxLifeTime(200);
    }

    public CommetBulet(double x, double y, double z, Level world) {
        this(EntityInit.commetBulet, world);
        this.m_6034_(x, y, z);
    }

    public CommetBulet(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(TARGET, -1);
        this.define(CHARGE, false);
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        this.rangeAttack(null, 0.75);
        super.m_8060_(result);
    }

    @Override
    protected void entityHit(LivingEntity living) {
        this.rangeAttack(living, 1.5);
    }

    public void rangeAttack(LivingEntity living, double range) {
        this.m_5496_(SoundEvents.f_11913_, 2.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range);
        entityList.forEach(e -> this.attackDamage((LivingEntity)e, 5.0f, false));
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sever = (ServerLevel)level;
            sever.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 2, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void m_8119_() {
        Entity target;
        super.m_8119_();
        if (this.getCharge()) {
            this.ownerMove();
            return;
        }
        if (!this.isClient()) {
            this.updateTarget();
        }
        if ((target = this.getTarget()) != null) {
            this.moveComet(target);
        }
        this.spawnParticleSever();
    }

    public void ownerMove() {
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        this.checkOwner();
        if (this.step-- <= 0) {
            float size = 0.015f;
            Vec3 vec3 = this.m_20184_();
            Vec3 newVec = new Vec3(vec3.f_82479_ + (double)this.getRandFloat(size), vec3.f_82480_ + (double)this.getRandFloat(size), vec3.f_82481_ + (double)this.getRandFloat(size));
            if ((double)this.m_20270_(owner) > 4.0) {
                float range = 0.1f;
                newVec = new Vec3((owner.f_19854_ - this.f_19854_ + (double)this.getRandFloat(range)) * (double)size, (owner.f_19855_ + 3.5 - this.f_19855_ + (double)this.getRandFloat(range)) * (double)size, (owner.f_19856_ - this.f_19856_ + (double)this.getRandFloat(range)) * (double)size);
            }
            this.m_20256_(newVec);
            this.step = 3;
        }
        this.lifeTime = 0;
    }

    public void moveComet(Entity target) {
        if (this.step >= 0 && this.step-- == 0) {
            this.selectNextMoveDirection(target, this.moveFace == null ? null : this.moveFace.m_122434_());
        }
        if (this.moveFace == null) {
            return;
        }
        BlockPos pos = this.m_20183_();
        Direction.Axis face = this.moveFace.m_122434_();
        if (this.m_9236_().m_46575_(pos.m_121945_(this.moveFace), (Entity)this)) {
            this.selectNextMoveDirection(target, face);
        } else {
            BlockPos pos1 = target.m_20183_();
            if (face == Direction.Axis.X && pos.m_123341_() == pos1.m_123341_() || face == Direction.Axis.Z && pos.m_123343_() == pos1.m_123343_() || face == Direction.Axis.Y && pos.m_123342_() == pos1.m_123342_()) {
                this.selectNextMoveDirection(target, face);
            }
        }
        this.targetX = Mth.m_14008_((double)(this.targetX * 1.1), (double)-1.25, (double)1.25);
        this.targetY = Mth.m_14008_((double)(this.targetY * 1.1), (double)-1.25, (double)1.25);
        this.targetZ = Mth.m_14008_((double)(this.targetZ * 1.1), (double)-1.25, (double)1.25);
        Vec3 vec3 = this.m_20184_();
        this.m_20256_(vec3.m_82520_((this.targetX - vec3.f_82479_) * 1.25, (this.targetY - vec3.f_82480_) * 1.25, (this.targetZ - vec3.f_82481_) * 1.25));
    }

    private void updateTarget() {
        Entity target = this.getTarget();
        if (target != null && !target.m_6084_()) {
            target = null;
            this.setTarget(null);
        }
        if (target != null) {
            return;
        }
        Entity owner = this.m_19749_();
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> this.canTargetEffect((LivingEntity)e, owner) && e.m_6084_(), 32.0);
        if (entityList.isEmpty()) {
            return;
        }
        double distance = 33.0;
        for (LivingEntity entity : entityList) {
            if (!(distance >= (double)entity.m_20270_((Entity)this))) continue;
            this.setTarget((Entity)entity);
        }
    }

    private void selectNextMoveDirection(Entity target, Direction.Axis axis) {
        double h = (double)target.m_20206_() * 0.5;
        BlockPos pos = new BlockPos((int)target.m_20185_(), (int)(target.m_20186_() + h), (int)target.m_20189_());
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + h;
        double z = (double)pos.m_123343_() + 0.5;
        RandomSource rand = this.getRandom();
        Level world = this.m_9236_();
        Direction face = null;
        if (!pos.m_203195_((Position)this.m_20182_(), 2.0)) {
            BlockPos pos1 = this.m_20183_();
            ArrayList facelist = Lists.newArrayList();
            if (axis != Direction.Axis.X) {
                if (pos1.m_123341_() < pos.m_123341_() && world.m_46859_(pos1.m_122029_())) {
                    facelist.add(Direction.EAST);
                } else if (pos1.m_123341_() > pos.m_123341_() && world.m_46859_(pos1.m_122024_())) {
                    facelist.add(Direction.WEST);
                }
            }
            if (axis != Direction.Axis.Y) {
                if (pos1.m_123342_() < pos.m_123342_() && world.m_46859_(pos1.m_7494_())) {
                    facelist.add(Direction.UP);
                } else if (pos1.m_123342_() > pos.m_123342_() && world.m_46859_(pos1.m_7495_())) {
                    facelist.add(Direction.DOWN);
                }
            }
            if (axis != Direction.Axis.Z) {
                if (pos1.m_123343_() < pos.m_123343_() && world.m_46859_(pos1.m_122019_())) {
                    facelist.add(Direction.SOUTH);
                } else if (pos1.m_123343_() > pos.m_123343_() && world.m_46859_(pos1.m_122012_())) {
                    facelist.add(Direction.NORTH);
                }
            }
            face = Direction.m_235672_((RandomSource)rand);
            if (facelist.isEmpty()) {
                for (int i = 5; !world.m_46859_(pos1.m_121945_(face)) && i > 0; --i) {
                    face = Direction.m_235672_((RandomSource)rand);
                }
            } else {
                face = (Direction)facelist.get(rand.m_188503_(facelist.size()));
            }
            x = this.m_20185_() + (double)face.m_122429_();
            y = this.m_20186_() + (double)face.m_122430_();
            z = this.m_20189_() + (double)face.m_122431_();
        }
        this.setFace(face);
        double d6 = x - this.m_20185_();
        double d7 = y - this.m_20186_();
        double d4 = z - this.m_20189_();
        double d5 = Math.sqrt(d6 * d6 + d7 * d7 + d4 * d4);
        if (d5 == 0.0) {
            this.targetZ = 0.0;
            this.targetY = 0.0;
            this.targetX = 0.0;
        } else {
            this.targetX = d6 / d5 * 0.15;
            this.targetY = d7 / d5 * 0.15;
            this.targetZ = d4 / d5 * 0.15;
        }
        this.f_19812_ = true;
        this.step = 10 + rand.m_188503_(4) * 6;
    }

    @Nullable
    private Entity getTarget() {
        return this.m_9236_().m_6815_(this.get(TARGET).intValue());
    }

    public void setTarget(Entity entity) {
        this.set(TARGET, entity == null ? -1 : entity.m_19879_());
    }

    public void setCharge(boolean isCharge) {
        this.set(CHARGE, isCharge);
    }

    public boolean getCharge() {
        return this.get(CHARGE);
    }

    @Nullable
    private Direction getFace() {
        return this.moveFace;
    }

    private void setFace(Direction face) {
        this.moveFace = face;
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        if (this.moveFace != null) {
            tags.m_128405_("Dir", this.moveFace.m_122411_());
        }
        tags.m_128405_("Steps", this.step);
        tags.m_128347_("TXD", this.targetX);
        tags.m_128347_("TYD", this.targetY);
        tags.m_128347_("TZD", this.targetZ);
        tags.m_128379_("isCharge", this.getCharge());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.step = tags.m_128451_("Steps");
        this.targetX = tags.m_128459_("TXD");
        this.targetY = tags.m_128459_("TYD");
        this.targetZ = tags.m_128459_("TZD");
        this.setCharge(tags.m_128471_("isCharge"));
        if (tags.m_128425_("Dir", 99)) {
            this.moveFace = Direction.m_122376_((int)tags.m_128451_("Dir"));
        }
    }

    protected void spawnParticleSever() {
        Level level;
        if (this.f_19797_ < 3 || this.f_19797_ % 2 != 0 || !((level = this.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)level;
        sever.m_8767_((ParticleOptions)ParticleInit.ORB, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 1.0, 0.9058823585510254, 0.4431372582912445, 1.0);
    }

    @Override
    public SMElement getElement() {
        return SMElement.SHINE;
    }
}

