/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class CriticalMagicShot
extends AbstractMagicShot {
    public CriticalMagicShot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public CriticalMagicShot(double x, double y, double z, Level world) {
        this(EntityInit.criticalMagic, world);
        this.m_6034_(x, y, z);
    }

    public CriticalMagicShot(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = info.getStack();
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        double range = this.getRange() * (double)0.67f;
        if (range <= 0.0 || !this.getCritical()) {
            this.m_146870_();
            return;
        }
        float dame = this.getDamage() * 0.67f;
        this.rangeAttack(result.m_82425_().m_7494_(), dame, range);
        this.m_146870_();
    }

    @Override
    protected void entityHit(LivingEntity living) {
        double range = this.getRange();
        if (range <= 0.0 || !this.getCritical()) {
            return;
        }
        float dame = this.getDamage();
        this.rangeAttack(living.m_20183_(), dame, range);
    }

    public void rangeAttack(BlockPos pos, float dame, double range) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.rangeParticle(server, pos, range, range * range, this.getData() >= 2, this.getData() >= 3);
        }
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range);
        entityList.forEach(e -> this.attackDamage((LivingEntity)e, dame, false));
    }

    public void rangeParticle(ServerLevel server, BlockPos bPos, double range, double effectRange, boolean isTier3, boolean isTier4) {
        Random rand = this.rand;
        boolean isChange = this.getChangeParticle();
        Iterable<BlockPos> pList = this.getPosRangeList(bPos, range);
        SimpleParticleType par = ParticleInit.SHINE;
        if (!isChange) {
            for (BlockPos pos : pList) {
                if (!this.checkDistance(pos, effectRange)) continue;
                double x = (double)pos.m_123341_() + rand.nextDouble() * 1.5 - 0.75;
                double y = (double)pos.m_123342_() + rand.nextDouble() * 0.25 + 0.25;
                double z = (double)pos.m_123343_() + rand.nextDouble() * 1.5 - 0.75;
                float xSpeed = this.getRandFloat(0.5f);
                float ySpeed = 0.25f + rand.nextFloat() * 0.25f;
                float zSpeed = this.getRandFloat(0.5f);
                server.m_8767_((ParticleOptions)par, x, y, z, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 0.25);
            }
        }
        if (!isTier3) {
            return;
        }
        if (isTier4) {
            BlockPos pos;
            int count = 16;
            pos = this.m_20183_();
            SimpleParticleType cyc = ParticleInit.CYCLE_SHINE_TORNADO;
            for (int y = -40; y < 8; ++y) {
                for (int i = 0; i < count; ++i) {
                    this.spawnParticleCycle(server, (ParticleOptions)cyc, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.5 + rand.nextDouble() * 1.5 + (double)y * 0.5, (double)pos.m_123343_() + 0.5, Direction.UP, 3.0, (float)i * 16.0f + (float)(y * 15), false);
                }
            }
        } else {
            double ran = isChange ? 0.5 : 1.0;
            for (int i = 0; i < 4; ++i) {
                this.spawnParticleRingY(server, (ParticleOptions)par, ran, bPos.m_6630_(3 + i), range / 15.0, -0.3);
                this.spawnParticleRingY(server, (ParticleOptions)par, ran, bPos.m_6630_(2 + i), range / 30.0, -0.2);
                this.spawnParticleRingY(server, (ParticleOptions)par, ran, bPos.m_6630_(1 + i), range / 60.0, -0.125);
            }
        }
    }

    @Override
    public int getMinParticleTick() {
        return 2;
    }

    @Override
    protected void spawnParticle() {
        Random rand = this.rand;
        Vec3 vec = this.m_20184_();
        float addX = (float)(-vec.f_82479_ / 20.0);
        float addY = (float)(-vec.f_82480_ / 20.0);
        float addZ = (float)(-vec.f_82481_ / 20.0);
        for (int i = 0; i < 3; ++i) {
            float x = addX + this.getRandFloat(0.075f);
            float y = addY + this.getRandFloat(0.075f);
            float z = addZ + this.getRandFloat(0.075f);
            float f1 = (float)(this.m_20185_() - 0.5 + (double)rand.nextFloat() + vec.f_82479_ * (double)i / 4.0);
            float f2 = (float)(this.m_20186_() - 0.5 + (double)rand.nextFloat() + vec.f_82480_ * (double)i / 4.0);
            float f3 = (float)(this.m_20189_() - 0.5 + (double)rand.nextFloat() + vec.f_82481_ * (double)i / 4.0);
            this.addParticle((ParticleOptions)ParticleInit.SHINE, f1, f2, f3, x, y, z);
        }
    }

    public void hitToSpawnParticle() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        BlockPos pos = this.m_20183_();
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.m_123341_() + this.rand.nextDouble() * 3.0 - 1.5;
            double y = (double)pos.m_123342_() + this.rand.nextDouble() * 1.5 - 0.75;
            double z = (double)pos.m_123343_() + this.rand.nextDouble() * 3.0 - 1.5;
            server.m_8767_((ParticleOptions)ParticleInit.SHINE, x, y, z, 0, 0.0, 0.0, 0.0, (double)0.1f);
        }
    }

    protected void spawnParticleCycle(ServerLevel server, ParticleOptions par, double x, double y, double z, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 1;
        server.m_8767_(par, x, y, z, 0, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * 6.0f) - (double)(this.f_19797_ * 5), 1.0);
    }

    @Override
    public SMElement getElement() {
        return SMElement.NON;
    }
}

