/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class CycloneMagicShot
extends AbstractMagicShot {
    public CycloneMagicShot(EntityType<? extends CycloneMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public CycloneMagicShot(double x, double y, double z, Level world) {
        this((EntityType<? extends CycloneMagicShot>)EntityInit.cycloneMagic, world);
        this.m_6034_(x, y, z);
    }

    public CycloneMagicShot(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(info);
        this.setRange(6.0);
    }

    public CycloneMagicShot(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
        this.setRange(5.0);
    }

    @Override
    protected void entityHit(LivingEntity living) {
        Level level;
        Vec3 vec3;
        int level2;
        LivingKnockBackEvent event;
        if (this.canTargetEffect(living, this.m_19749_()) && !(event = ForgeHooks.onLivingKnockBack((LivingEntity)living, (float)((float)this.knockback * (1.0f + (float)(level2 = this.getWandLevel()) * 0.1f)), (double)1.0, (double)1.0)).isCanceled() && (vec3 = this.m_20184_().m_82542_(event.getRatioX(), 0.0, event.getRatioZ()).m_82541_().m_82490_((double)event.getStrength())).m_82556_() > 0.0) {
            living.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.spawnParticleShort(server, living.m_20183_());
        }
        double range = this.getRange() / 0.67;
        float dame = 0.5f + 0.67f * (float)this.getWandLevel() * this.getDamageRate();
        this.rangeAttack(living.m_20183_(), dame, range);
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        double range = this.getRange();
        float dame = 0.5f + 0.5f * (float)this.getWandLevel() * this.getDamageRate();
        this.rangeAttack(result.m_82425_().m_7494_(), dame, range);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.spawnParticleShort(server, result.m_82425_().m_7494_());
        }
        this.m_146870_();
    }

    public void rangeAttack(BlockPos bPos, float dame, double range) {
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range);
        if (entityList.isEmpty()) {
            return;
        }
        boolean isTier3 = this.getData() >= 2;
        boolean isTier4 = this.getData() >= 3;
        int time = 60 * (this.getWandLevel() + 1);
        int addLevel = isTier4 ? 2 : 1;
        for (LivingEntity entity : entityList) {
            int level;
            Vec3 vec3;
            LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)entity, (float)((float)this.knockback * 1.0f), (double)1.0, (double)1.0);
            if (!event.isCanceled() && (vec3 = this.m_20184_().m_82542_(event.getRatioX(), 0.0, event.getRatioZ()).m_82541_().m_82490_((double)event.getStrength())).m_82556_() > 0.0) {
                entity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
            }
            this.attackDamage(entity, dame, false);
            if (!isTier3) continue;
            int n = level = entity.m_21023_(PotionInit.bleeding) ? entity.m_21124_(PotionInit.bleeding).m_19564_() + addLevel : addLevel - 1;
            if (level > 0) {
                entity.m_21195_(PotionInit.bleeding);
            }
            if (this.addPotion(entity, PotionInit.bleeding, time, Math.max(0, level))) {
                this.notHasDebuffAddAttack(entity, time);
            }
            if (!entity.m_21023_(PotionInit.bleeding)) continue;
            MobEffectInstance effect = entity.m_21124_(PotionInit.bleeding);
            int pLevel = effect.m_19564_();
            int pTime = effect.m_19557_();
            if (!isTier4 || pLevel < 4) continue;
            entity.m_21195_(PotionInit.bleeding);
            this.addPotion(entity, PotionInit.bleeding, time, 0);
            float rate = 1.0f + (float)pTime / 300.0f;
            this.addAttack(entity, dame * rate, pLevel * 3);
        }
    }

    public float getDamageRate() {
        return switch (this.getData()) {
            case 0 -> 1.0f;
            case 1 -> 1.5f;
            case 2 -> 1.75f;
            default -> 2.0f;
        };
    }

    @Override
    protected void spawnParticleShort(ServerLevel sever, BlockPos pos) {
        int count = 16;
        float rate = 0.15f;
        float x = (float)pos.m_123341_() + this.getRandFloat(0.5f);
        float y = (float)pos.m_123342_() + this.getRandFloat(0.5f);
        float z = (float)pos.m_123343_() + this.getRandFloat(0.5f);
        if (this.getData() >= 3) {
            count = 64;
            rate = 0.25f;
        }
        for (int i = 0; i < count; ++i) {
            sever.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)rate);
        }
    }

    @Override
    public int getMinParticleTick() {
        return 3;
    }

    @Override
    protected void spawnParticle() {
        Vec3 vec = this.m_20184_();
        float x = (float)(-vec.f_82479_) / 30.0f;
        float y = (float)(-vec.f_82480_) / 30.0f;
        float z = (float)(-vec.f_82481_) / 30.0f;
        this.addParticle((ParticleOptions)ParticleInit.CYCLONE, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), x, y, z);
    }

    @Override
    public SMElement getElement() {
        return SMElement.CYCLON;
    }
}

