/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class ElectricSphere
extends AbstractMagicShot {
    private static final EntityDataAccessor<Integer> COUNT = ElectricSphere.setEntityData(ISMMob.INT);

    public ElectricSphere(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public ElectricSphere(double x, double y, double z, Level world) {
        this(EntityInit.electricSphere, world);
        this.m_6034_(x, y, z);
    }

    public ElectricSphere(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(COUNT, 0);
    }

    public void setCount(int count) {
        this.set(COUNT, count);
    }

    public int getCount() {
        return this.get(COUNT);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.inGround) {
            Vec3 vec = this.m_20184_();
            float down = this.getCount() == 2 ? 0.075f : 0.015f;
            this.m_20256_(new Vec3(vec.f_82479_, vec.f_82480_ - (double)down, vec.f_82481_));
        }
    }

    @Override
    protected void entityHit(LivingEntity target) {
        double range = this.getRange() / 0.67;
        float dame = 0.5f + 0.67f * (float)this.getWandLevel();
        this.rangeAttack(target.m_20183_(), dame, range);
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        if (this.isClient()) {
            this.setHitDead(false);
        }
        this.setLifeTime(0);
        double range = this.getRange();
        float dame = 0.5f + 0.5f * (float)this.getWandLevel();
        if (this.getCount() > 0) {
            this.setCount(this.getCount() - 1);
            Vec3 look = this.m_20184_();
            Vec3 dest = this.getCount() == 1 ? new Vec3(look.f_82479_ * 0.25, (double)0.1f, look.f_82481_ * 0.25) : new Vec3(look.f_82479_, (double)0.1f, look.f_82481_);
            this.m_20256_(dest);
            this.m_5496_(SoundEvents.f_12384_, 0.5f, 1.0f);
            float rate = 0.33f + (float)(1 - this.getCount()) * 0.34f;
            this.rangeAttack(result.m_82425_().m_7494_(), dame, (float)(range * (double)rate));
        } else {
            this.rangeAttack(result.m_82425_().m_7494_(), dame, (float)(range * 2.0));
            this.m_5496_(SoundEvents.f_12384_, 0.5f, 1.0f);
            this.m_146870_();
        }
    }

    public void rangeAttack(BlockPos bPos, float dame, double range) {
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range);
        entityList.forEach(e -> this.attackDamage((LivingEntity)e, dame, false));
    }

    @Override
    public SMElement getElement() {
        return SMElement.LIGHTNING;
    }
}

