/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class EnderBall
extends AbstractMagicShot {
    public boolean isTeleport = true;

    public EnderBall(EntityType<? extends EnderBall> entityType, Level world) {
        super(entityType, world);
    }

    public EnderBall(double x, double y, double z, Level world) {
        this((EntityType<? extends EnderBall>)EntityInit.enderBall, world);
        this.m_6034_(x, y, z);
    }

    public EnderBall(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockPos pos = result.m_82425_().m_121945_(result.m_82434_());
            if (this.checkBlock(pos)) {
                this.teleportPos((Entity)player, player.m_20183_(), pos);
            }
        }
        super.m_8060_(result);
    }

    @Override
    protected void entityHit(LivingEntity target) {
        if (target instanceof ISMMob) {
            if (target instanceof ISMMob || this.isClient() || !this.isTeleport) {
                return;
            }
            Random rand = this.rand;
            for (int i = 0; i < 16; ++i) {
                double d3 = this.m_20185_() + (rand.nextDouble() - 0.5) * 16.0;
                double d4 = this.m_20186_() + 0.5;
                double d5 = this.m_20189_() + (rand.nextDouble() - 0.5) * 16.0;
                if (target.m_20159_()) {
                    target.m_8127_();
                }
                Vec3 vec3 = this.m_20182_();
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)target));
                EntityTeleportEvent.ChorusFruit event = ForgeEventFactory.onChorusFruitTeleport((LivingEntity)target, (double)d3, (double)d4, (double)d5);
                if (event.isCanceled()) {
                    return;
                }
                if (!target.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
                this.m_5496_(SoundEvents.f_11757_, 1.0f, 1.0f);
                break;
            }
        } else {
            Entity owner = this.m_19749_();
            if (!(target instanceof LivingEntity) || owner == null) {
                return;
            }
            BlockPos targetPos = target.m_20183_();
            BlockPos ownerPos = owner.m_20183_();
            this.teleportPos((Entity)target, targetPos, ownerPos);
            this.teleportPos(owner, ownerPos, targetPos);
        }
    }

    public void teleportPos(Entity entity, BlockPos basePos, BlockPos targetPos) {
        Player player;
        entity.m_6021_((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_());
        if (this.m_9236_().m_46859_(targetPos.m_7495_()) && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.addPotion(living, PotionInit.resistance_blow, 70, 0);
        }
        this.m_5496_(SoundEvents.f_11757_, 1.0f, 1.0f);
        if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
            player.m_36399_((float)Math.sqrt(basePos.m_123331_((Vec3i)targetPos) * (double)0.02f));
        }
    }

    public boolean checkBlock(BlockPos pos) {
        Level world = this.m_9236_();
        if (this.checkAABB(world, pos)) {
            return true;
        }
        return this.checkAABB(world, pos.m_7495_()) || this.checkAABB(world, pos.m_7494_());
    }

    public boolean checkAABB(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        BlockState underState = world.m_8055_(pos.m_7495_());
        VoxelShape aabb = state.m_60734_().m_7947_(state, (BlockGetter)world, pos);
        VoxelShape underAABB = underState.m_60734_().m_7947_(underState, (BlockGetter)world, pos.m_7495_());
        return aabb.equals(Shapes.m_83040_()) && underAABB.equals(Shapes.m_83040_());
    }

    @Override
    protected void spawnParticle() {
        Vec3 vec = this.m_20184_();
        float x = (float)(-vec.f_82479_) / 80.0f;
        float y = (float)(-vec.f_82480_) / 80.0f;
        float z = (float)(-vec.f_82481_) / 80.0f;
        Random rand = this.rand;
        for (int i = 0; i < 6; ++i) {
            float f1 = (float)(this.m_20185_() - 0.5 + (double)rand.nextFloat() + vec.f_82479_ * (double)i / 4.0);
            float f2 = (float)(this.m_20186_() - 0.25 + (double)rand.nextFloat() * 0.5 + vec.f_82480_ * (double)i / 4.0);
            float f3 = (float)(this.m_20189_() - 0.5 + (double)rand.nextFloat() + vec.f_82481_ * (double)i / 4.0);
            this.addParticle((ParticleOptions)ParticleTypes.f_123760_, f1, f2, f3, x, y, z);
        }
    }

    @Override
    public SMElement getElement() {
        return SMElement.TIME;
    }
}

