/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class FrostMagicShot
extends AbstractMagicShot {
    private static final BlockState STATE = Blocks.f_50568_.m_49966_();

    public FrostMagicShot(EntityType<? extends FrostMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public FrostMagicShot(double x, double y, double z, Level world) {
        this((EntityType<? extends FrostMagicShot>)EntityInit.frostMagic, world);
        this.m_6034_(x, y, z);
    }

    public FrostMagicShot(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(info);
    }

    public FrostMagicShot(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void entityHit(LivingEntity living) {
        int time = 60 * (this.getWandLevel() + 1);
        if (this.canTargetEffect(living, this.m_19749_())) {
            if (this.addPotion(living, PotionInit.frost, time, this.getData())) {
                this.notHasDebuffAddAttack(living, time);
            }
        } else {
            living.m_21195_(PotionInit.frost);
        }
        if (this.getRange() > 0.0) {
            this.rangeAttack(living.m_20183_(), this.getDamage(), this.getRange());
        }
        this.m_5496_(SoundInit.FROST, 0.0625f, 1.0f);
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        if (this.getChangeParticle()) {
            this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.1f);
        }
        if (this.getRange() > 0.0) {
            this.rangeAttack(result.m_82425_().m_7494_(), this.getDamage(), this.getRange());
        }
        super.m_8060_(result);
        this.m_146870_();
    }

    public void rangeAttack(BlockPos bPos, float dame, double range) {
        List<LivingEntity> entityList;
        Level level;
        boolean isTier3 = this.getData() >= 2;
        boolean isTier4 = this.getData() >= 3;
        double effectRange = range * range;
        if (isTier3 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.rangeParticle(server, bPos, range, effectRange, isTier3, isTier4);
        }
        if ((entityList = this.getEntityList(LivingEntity.class, range)).isEmpty()) {
            return;
        }
        Entity owner = this.m_19749_();
        int time = 60 * (this.getWandLevel() + 1);
        int level2 = isTier4 ? 1 : 0;
        for (LivingEntity entity : entityList) {
            if (!this.canTargetEffect(entity, owner) || !this.checkDistance(entity.m_20183_(), effectRange)) continue;
            this.attackDamage(entity, dame, false);
            if (!isTier3) continue;
            this.addPotion(entity, PotionInit.flost_water_vulnerable, 1200, level2);
            if (!this.addPotion(entity, PotionInit.frost, time, 2 + level2)) continue;
            this.notHasDebuffAddAttack(entity, time);
        }
    }

    public void rangeParticle(ServerLevel server, BlockPos bPos, double range, double effectRange, boolean isTier3, boolean isTier4) {
        Random rand = this.rand;
        boolean isChange = this.getChangeParticle();
        SimpleParticleType par = ParticleInit.FROST;
        Iterable<BlockPos> pList = this.getPosRangeList(bPos, range);
        if (!isChange) {
            for (BlockPos pos : pList) {
                if (!this.checkDistance(pos, effectRange)) continue;
                double x = (double)pos.m_123341_() + rand.nextDouble() * 1.5 - 0.75;
                double y = (double)pos.m_123342_() + rand.nextDouble() * 0.25 + 0.25;
                double z = (double)pos.m_123343_() + rand.nextDouble() * 1.5 - 0.75;
                float xSpeed = this.getRandFloat(0.5f);
                float ySpeed = 0.25f + rand.nextFloat() * 0.25f;
                float zSpeed = this.getRandFloat(0.5f);
                server.m_8767_((ParticleOptions)par, x, y, z, 0, (double)xSpeed, (double)ySpeed, (double)zSpeed, 0.25);
            }
            for (int i = 0; i < 16; ++i) {
                server.m_8767_((ParticleOptions)this.getParticle(STATE), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 1.0);
            }
        }
        if (isTier4) {
            BlockPos pos;
            int count = 16;
            pos = this.m_20183_();
            SimpleParticleType par2 = ParticleInit.CYCLE_FROST_TORNADO;
            for (int y = -40; y < 8; ++y) {
                for (int i = 0; i < count; ++i) {
                    this.spawnParticleCycle(server, (ParticleOptions)par2, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.5 + rand.nextDouble() * 1.5 + (double)y * 0.5, (double)pos.m_123343_() + 0.5, Direction.UP, 3.0, (float)i * 16.0f + (float)(y * 15), false);
                }
            }
            this.m_5496_(SoundEvents.f_11715_, 3.0f, 1.0f);
        } else {
            double ran = isChange ? 0.5 : 1.0;
            for (int i = 0; i < 4; ++i) {
                this.spawnParticleRingY(server, (ParticleOptions)par, ran, bPos.m_6630_(3 + i), range / 15.0, -0.3);
                this.spawnParticleRingY(server, (ParticleOptions)par, ran, bPos.m_6630_(2 + i), range / 30.0, -0.2);
                this.spawnParticleRingY(server, (ParticleOptions)par, ran, bPos.m_6630_(1 + i), range / 60.0, -0.125);
            }
        }
        this.m_5496_(SoundInit.FROST, 0.25f, 1.0f);
    }

    @Override
    protected void spawnParticleShort(ServerLevel sever, BlockPos pos) {
        float x = (float)pos.m_123341_() + this.getRandFloat(0.25f);
        float y = (float)pos.m_123342_() + this.getRandFloat(0.25f);
        float z = (float)pos.m_123343_() + this.getRandFloat(0.25f);
        for (int i = 0; i < 3; ++i) {
            sever.m_8767_((ParticleOptions)ParticleInit.FROST, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.15f);
        }
    }

    @Override
    public int getMinParticleTick() {
        return 3;
    }

    @Override
    protected void spawnParticle() {
        Vec3 vec = this.m_20184_();
        float x = (float)(-vec.f_82479_) / 20.0f;
        float y = (float)(-vec.f_82480_) / 20.0f;
        float z = (float)(-vec.f_82481_) / 20.0f;
        if (this.getChangeParticle()) {
            if (this.lifeTime > 1) {
                return;
            }
            this.addParticle((ParticleOptions)ParticleInit.CRYSTAL, this.m_20185_() - 0.5, this.m_20186_() - 10.5, this.m_20189_() - 0.5, x, vec.f_82480_, z);
        } else {
            boolean isArrow = this.getArrow() && this.m_20096_();
            Random rand = this.rand;
            if (isArrow && rand.nextFloat() >= 0.1f) {
                return;
            }
            int count = isArrow ? 1 : 4;
            for (int i = 0; i < count; ++i) {
                float f1 = (float)(this.m_20185_() - 0.5 + (double)rand.nextFloat() + vec.f_82479_ * (double)i / 4.0);
                float f2 = (float)(this.m_20186_() - 0.25 + (double)rand.nextFloat() * 0.5 + vec.f_82480_ * (double)i / 4.0);
                float f3 = (float)(this.m_20189_() - 0.5 + (double)rand.nextFloat() + vec.f_82481_ * (double)i / 4.0);
                this.addParticle((ParticleOptions)ParticleInit.FROST, f1, f2, f3, x + this.getRandFloat(0.075f), y + this.getRandFloat(0.075f), z + this.getRandFloat(0.075f));
            }
        }
    }

    protected void spawnParticleCycle(ServerLevel server, ParticleOptions par, double x, double y, double z, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 1;
        server.m_8767_(par, x, y, z, 0, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * 6.0f) - (double)(this.f_19797_ * 5), 1.0);
    }

    @Override
    public SMElement getElement() {
        return SMElement.FROST;
    }
}

