/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.boss.IgnisKnight;
import sweetmagic.init.entity.projectile.AbstractBossMagic;

public class IgnisBlastMagic
extends AbstractBossMagic {
    private boolean isGround = false;
    private int groundTime = 0;
    private int chargeTime = 0;
    private static final int MAX_CHARGETIME = 50;
    private List<LivingEntity> entityList = new ArrayList<LivingEntity>();

    public IgnisBlastMagic(EntityType<? extends IgnisBlastMagic> entityType, Level world) {
        super((EntityType<? extends AbstractBossMagic>)entityType, world);
    }

    public IgnisBlastMagic(double x, double y, double z, Level world) {
        this((EntityType<? extends IgnisBlastMagic>)EntityInit.ignisBlast, world);
        this.m_6034_(x, y, z);
    }

    public IgnisBlastMagic(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(info);
    }

    @Override
    public void onUpdate() {
        if (this.target != null) {
            this.setRotInit();
            if (this.chargeTime++ < 50) {
                return;
            }
            if (this.entityList.isEmpty()) {
                this.entityList = this.setTarget(false);
                if (this.entityList.size() > 1) {
                    this.entityList = this.entityList.stream().sorted((s1, s2) -> this.sortEntity((Entity)this, (Entity)s1, (Entity)s2)).toList();
                    this.target = this.entityList.get(0);
                }
            }
            this.attackMagic(this.target);
        }
        if (!(this.target != null && this.target.m_6084_() || this.f_19797_ % 8 != 0)) {
            this.setTarget(true);
        }
    }

    public void attackMagic(LivingEntity target) {
        ++this.tickTime;
        IgnisKnight ignis = this.getIgnis();
        ignis.setBlast(true);
        ignis.setAttackType(2);
        if (this.tickTime == 10) {
            BlockPos beforePos = this.m_20183_();
            this.targetTeleport(ignis, target);
            this.teleportParticle((ParticleOptions)ParticleTypes.f_123745_, this.m_9236_(), beforePos, this.m_20183_());
        } else if (this.tickTime > 10 && this.tickTime <= 50) {
            this.ignisJump(ignis, target);
        } else if (this.tickTime > 50) {
            if (!this.inGround) {
                this.notOnGround(ignis, target);
            } else {
                int data = this.getData();
                if (!this.isGround) {
                    this.groundBlastAttack(ignis, target, data);
                } else {
                    this.groundRingAttack(ignis, target, data);
                }
            }
        }
    }

    public void targetTeleport(IgnisKnight ignis, LivingEntity target) {
        BlockPos targetPos = new BlockPos((int)target.m_20185_(), (int)target.m_20186_() + 5, (int)target.m_20189_());
        while (!this.m_9236_().m_46859_(targetPos)) {
            targetPos = targetPos.m_7495_();
        }
        this.m_6021_(targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_());
    }

    public void ignisJump(IgnisKnight ignis, LivingEntity target) {
        Level range2;
        Vec3 vec = this.m_20184_();
        if (vec.f_82480_ < 0.0) {
            this.m_20256_(new Vec3(0.0, 0.0, 0.0));
        }
        if (this.tickTime == 50) {
            ignis.setSwing(true);
        }
        if (this.tickTime == 11 || this.tickTime == 41) {
            BlockPos pos = target.m_20183_();
            double range2 = 10.0 + (double)this.entityList.size() * 0.5;
            for (int i = 1; i <= 4; ++i) {
                this.spawnParticleCycle(pos, range2 * 0.25 * (double)i, this.rand);
            }
        }
        if (!((range2 = this.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)range2;
        for (int i = 0; i < 4; ++i) {
            float x = (float)this.m_20185_() + this.getRandFloat(0.5f);
            float y = (float)this.m_20186_() + this.getRandFloat(0.5f);
            float z = (float)this.m_20189_() + this.getRandFloat(0.5f);
            float aX = this.getRandFloat(0.75f);
            float aY = 0.1f + this.rand.nextFloat() * 0.2f;
            float aZ = this.getRandFloat(0.75f);
            sever.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)x, (double)y, (double)z, 0, (double)aX, (double)aY, (double)aZ, 1.0);
        }
    }

    public void notOnGround(IgnisKnight ignis, LivingEntity target) {
        ignis.setSwing(true);
        this.m_20256_(new Vec3(0.0, -1.5, 0.0));
    }

    public void groundBlastAttack(IgnisKnight ignis, LivingEntity target, int data) {
        LivingEntity entity2;
        if (!this.m_9236_().m_46859_(this.m_20183_())) {
            this.m_6021_(this.m_20185_(), this.m_20186_() + 1.75, this.m_20189_());
        }
        ignis.setSwing(true);
        float amount = (data == 1 ? 35.0f : 25.0f) + this.getAddDamage();
        double range = (data == 1 ? 15.0 : 10.0) + (double)this.entityList.size() * 0.5;
        List<LivingEntity> attackList = this.getEntityList(LivingEntity.class, (T e) -> e instanceof Enemy && e.m_6084_(), range);
        for (LivingEntity entity2 : attackList) {
            this.attackDamage(entity2, amount, true);
            if (data != 1) continue;
            this.addPotion(entity2, PotionInit.flame, 0, 600);
        }
        this.isGround = true;
        this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
        this.sortEntityList(ignis);
        entity2 = this.m_9236_();
        if (!(entity2 instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)entity2;
        sever.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
        float x = (float)this.m_20185_() + this.getRandFloat(0.5f);
        float y = (float)this.m_20186_() + this.getRandFloat(0.5f);
        float z = (float)this.m_20189_() + this.getRandFloat(0.5f);
        for (int i = 0; i < 16; ++i) {
            sever.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.15f);
        }
    }

    public void groundRingAttack(IgnisKnight ignis, LivingEntity target, int data) {
        LivingEntity entity2;
        if (this.groundTime++ < 19 || this.groundTime % 20 != 0) {
            return;
        }
        float amount = (data == 1 ? 15.0f : 10.0f) + this.getAddDamage() * 0.5f;
        double ran = (data == 1 ? 20.0 : 14.0) + (double)this.entityList.size() * 2.0;
        this.m_5496_(SoundEvents.f_11705_, 1.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
        List<LivingEntity> attackList = this.getEntityList(LivingEntity.class, (T e) -> e instanceof Enemy && e.m_6084_(), ran);
        for (LivingEntity entity2 : attackList) {
            this.attackDamage(entity2, amount, true);
            if (data != 1 || !entity2.m_21023_(PotionInit.flame)) continue;
            this.addAttack(entity2, amount, 3);
        }
        this.sortEntityList(ignis);
        if (this.groundTime >= 60) {
            this.clearInfo(ignis);
        }
        if (!((entity2 = this.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)entity2;
        BlockPos pos = this.m_20183_();
        for (int range = 0; range < 3; ++range) {
            for (int i = 0; i < 3; ++i) {
                this.spawnParticleRing(sever, (ParticleOptions)ParticleTypes.f_123745_, 2 + range * 4, pos, -0.25 + (double)i * 0.5);
            }
        }
    }

    public void sortEntityList(IgnisKnight ignis) {
        this.entityList = this.entityList.stream().filter(e -> e.m_6084_()).toList();
        if (this.entityList.isEmpty()) {
            this.clearInfo(ignis);
        } else {
            this.target = this.entityList.get(0);
        }
    }

    public List<LivingEntity> setTarget(boolean isSetTarget) {
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> e instanceof Enemy && e.m_6084_(), 48.0);
        if (!isSetTarget) {
            return entityList;
        }
        double dis = 0.0;
        this.target = null;
        for (LivingEntity entity : entityList) {
            if (this.target == null) {
                this.target = entity;
                dis = this.m_20280_((Entity)this.target);
                continue;
            }
            if (!(dis < this.m_20280_((Entity)entity))) continue;
            this.target = entity;
            dis = this.m_20280_((Entity)this.target);
        }
        return entityList;
    }

    public void clearInfo(IgnisKnight ignis) {
        this.chargeTime = 0;
        this.tickTime = 0;
        this.groundTime = 0;
        this.entityList = new ArrayList<LivingEntity>();
        this.isGround = false;
        this.inGround = false;
        ignis.setAttackType(0);
        ignis.setSwing(false);
        ignis.setRush(false);
        ignis.setAttack(false);
        ignis.setBlast(false);
    }

    @Override
    public void spawnParticleRing(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double addY) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0 + addY;
        double z = (double)pos.m_123343_() + 0.5;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.25) {
            double rate = range * 0.75;
            server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, Math.cos(degree) * 0.65, 0.0, Math.sin(degree) * 0.65, 1.0);
        }
    }

    @Override
    public LivingEntity getEntity() {
        if (this.summon == null) {
            IgnisKnight queen = new IgnisKnight(this.m_9236_());
            queen.setMagic(true);
            this.summon = queen;
        }
        return this.summon;
    }

    public IgnisKnight getIgnis() {
        return (IgnisKnight)this.getEntity();
    }

    @Override
    public SMElement getElement() {
        return SMElement.FLAME;
    }
}

