/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.boss.WitchSandryon;
import sweetmagic.init.entity.projectile.AbstractBossMagic;
import sweetmagic.util.PlayerHelper;

public class InfinitWandMagic
extends AbstractBossMagic {
    private int infiniteTime = 0;
    private static final int MAX_INFINITE_TIME = 175;

    public InfinitWandMagic(EntityType<? extends AbstractBossMagic> entityType, Level world) {
        super(entityType, world);
    }

    public InfinitWandMagic(double x, double y, double z, Level world) {
        this((EntityType<? extends AbstractBossMagic>)EntityInit.infinitWand, world);
        this.m_6034_(x, y, z);
    }

    public InfinitWandMagic(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(info);
    }

    @Override
    public void onUpdate() {
        if (this.target != null && this.target.m_6084_()) {
            this.setRotInit();
            this.attackMagic(this.target);
        }
        if (!(this.infiniteTime > 0 || this.target != null && this.target.m_6084_() || this.f_19797_ % 8 != 0)) {
            this.setTarget();
        }
    }

    public void attackMagic(LivingEntity target) {
        if (this.infiniteTime == 75 && this.getEntity() != null) {
            WitchSandryon sand = this.getsandryon();
            sand.setInfiniteWand(true);
        }
        if (this.infiniteTime++ < 175) {
            return;
        }
        double range = 24.0;
        float damage = 50.0f + this.getAddDamage();
        int addAttack = 10 + this.getAddAttack();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sever = (ServerLevel)level;
            SimpleParticleType par = ParticleTypes.f_123815_;
            List<LivingEntity> targetList = this.getEntityList(LivingEntity.class, (T e) -> e instanceof Enemy && e.m_6084_(), this.getAABB(this.getPos(target), range));
            for (LivingEntity entity : targetList) {
                List<MobEffectInstance> effecList = PlayerHelper.getEffectList(entity, PotionInit.BUFF);
                effecList.forEach(p -> entity.m_21195_(p.m_19544_()));
                this.attackDamage(entity, damage, true);
                this.addAttack(entity, damage, addAttack);
                entity.m_5496_(SoundEvents.f_11983_, 0.25f, 1.15f);
                float x = (float)entity.f_19854_ + this.rand.nextFloat() * 0.5f;
                float y = (float)entity.m_20186_() + this.rand.nextFloat() * 0.5f + 1.5f;
                float z = (float)entity.f_19856_ + this.rand.nextFloat() * 0.5f;
                for (int i = 0; i < 8; ++i) {
                    sever.m_8767_((ParticleOptions)par, (double)x, (double)y, (double)z, 2, 0.0, 0.0, 0.0, (double)0.1f);
                }
            }
        }
        this.infiniteTime = 0;
        if (this.getEntity() != null) {
            ((WitchSandryon)this.getEntity()).setInfiniteWand(false);
        }
    }

    public void setTarget() {
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> e instanceof Enemy && e.m_6084_(), 48.0);
        double dis = 0.0;
        this.target = null;
        for (LivingEntity entity : entityList) {
            if (this.target == null) {
                this.target = entity;
                dis = this.m_20280_((Entity)this.target);
                continue;
            }
            if (!(dis < this.m_20280_((Entity)entity))) continue;
            this.target = entity;
            dis = this.m_20280_((Entity)this.target);
        }
    }

    public BlockPos getPos(LivingEntity target) {
        if (this.target != null && this.target.m_6084_()) {
            return target.m_20183_();
        }
        return this.m_20183_();
    }

    @Override
    public LivingEntity getEntity() {
        if (this.summon == null) {
            WitchSandryon sand = new WitchSandryon(this.m_9236_());
            sand.setMagic(true);
            this.summon = sand;
        }
        return this.summon;
    }

    public WitchSandryon getsandryon() {
        return (WitchSandryon)this.getEntity();
    }

    @Override
    public SMElement getElement() {
        return SMElement.LIGHTNING;
    }
}

