/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.PhantomWolf;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class PoisonMagicShot
extends AbstractMagicShot {
    private LivingEntity entity = null;
    private static final EntityDataAccessor<Boolean> WOLF = PoisonMagicShot.setEntityData(ISMMob.BOOLEAN);

    public PoisonMagicShot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public PoisonMagicShot(double x, double y, double z, Level world) {
        this(EntityInit.poisonMagic, world);
        this.m_6034_(x, y, z);
    }

    public PoisonMagicShot(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(info);
    }

    public PoisonMagicShot(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
        this.setRange(4.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(WOLF, false);
    }

    public void setWolf(boolean isWolf) {
        this.set(WOLF, isWolf);
    }

    public boolean getWolf() {
        return this.get(WOLF);
    }

    @Override
    protected void entityHit(LivingEntity living) {
        int time = 60 * (this.getWandLevel() + 1);
        if (living instanceof Player && this.m_19749_() instanceof Player) {
            living.m_21195_(PotionInit.deadly_poison);
        } else if (this.addPotion(living, PotionInit.deadly_poison, time, this.getData())) {
            this.notHasDebuffAddAttack(living, time);
        }
        if (this.getData() >= 1) {
            this.rangeAttack(living.m_20183_(), this.getDamage() * this.getDamageRate(), this.getRange());
        } else {
            this.hitToSpawnParticle();
        }
        if (this.getData() >= 3) {
            // empty if block
        }
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        if (this.getData() >= 1) {
            float damageRate = this.getDamageRate() * 0.67f;
            this.rangeAttack(result.m_82425_().m_7494_(), this.getDamage() * damageRate, this.getRange() * (double)0.67f);
        } else {
            this.hitToSpawnParticle();
        }
        this.m_146870_();
    }

    public void rangeAttack(BlockPos bPos, float dame, double range) {
        List<LivingEntity> entityList;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Random rand = this.rand;
            double effectRange = range * range;
            Iterable<BlockPos> pList = this.getPosRangeList(bPos, range);
            SimpleParticleType par = ParticleInit.SMOKY;
            for (BlockPos pos : pList) {
                if (!this.checkDistance(pos, effectRange)) continue;
                double x = (double)pos.m_123341_() + rand.nextDouble() * 1.5 - 0.75;
                double y = (double)pos.m_123342_() + rand.nextDouble() * 1.5 - 0.75;
                double z = (double)pos.m_123343_() + rand.nextDouble() * 1.5 - 0.75;
                server.m_8767_((ParticleOptions)par, x, y, z, 0, (double)0.2627451f, 0.6784313917160034, 0.40392157435417175, 1.0);
            }
        }
        if ((entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range)).isEmpty()) {
            return;
        }
        double effectRange = range * range;
        int time = 60 * (this.getWandLevel() + 1);
        boolean isTier4 = this.getData() >= 3;
        for (LivingEntity entity : entityList) {
            if (!this.checkDistance(entity.m_20183_(), effectRange)) continue;
            this.attackDamage(entity, dame, false);
            if (this.addPotion(entity, PotionInit.deadly_poison, time, this.getData())) {
                this.notHasDebuffAddAttack(entity, time);
            }
            if (!isTier4) continue;
            this.addPotion(entity, PotionInit.magic_damage_receive, time, 1);
            if (!entity.m_21023_(PotionInit.reflash_effect)) continue;
            float rate = this.isBoss((Entity)entity) ? 0.025f : 0.1f;
            entity.m_21153_(Math.max(1.0f, entity.m_21223_() - entity.m_21233_() * rate));
        }
    }

    @Override
    protected void spawnParticleShort(ServerLevel sever, BlockPos pos) {
        float x = (float)pos.m_123341_() + this.getRandFloat(0.25f);
        float y = (float)pos.m_123342_() + this.getRandFloat(0.25f);
        float z = (float)pos.m_123343_() + this.getRandFloat(0.25f);
        for (int i = 0; i < 3; ++i) {
            sever.m_8767_((ParticleOptions)ParticleInit.POISON, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.15f);
        }
    }

    @Override
    public int getMinParticleTick() {
        return 3;
    }

    @Override
    protected void spawnParticle() {
        Vec3 vec = this.m_20184_();
        float addX = (float)(-vec.f_82479_ / 20.0);
        float addY = (float)(-vec.f_82480_ / 20.0);
        float addZ = (float)(-vec.f_82481_ / 20.0);
        Random rand = this.rand;
        for (int i = 0; i < 6; ++i) {
            float x = addX + this.getRandFloat(0.075f);
            float y = addY + this.getRandFloat(0.075f);
            float z = addZ + this.getRandFloat(0.075f);
            float f1 = (float)(this.m_20185_() - 0.5 + (double)rand.nextFloat() + vec.f_82479_ * (double)i / 4.0);
            float f2 = (float)(this.m_20186_() - 0.25 + (double)rand.nextFloat() * 0.5 + vec.f_82480_ * (double)i / 4.0);
            float f3 = (float)(this.m_20189_() - 0.5 + (double)rand.nextFloat() + vec.f_82481_ * (double)i / 4.0);
            this.addParticle((ParticleOptions)ParticleInit.POISON, f1, f2, f3, x, y, z);
        }
    }

    public void hitToSpawnParticle() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Random rand = this.rand;
        BlockPos pos = this.m_20183_();
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.m_123341_() + rand.nextDouble() * 3.0 - 1.5;
            double y = (double)pos.m_123342_() + rand.nextDouble() * 1.5 - 0.75;
            double z = (double)pos.m_123343_() + rand.nextDouble() * 3.0 - 1.5;
            server.m_8767_((ParticleOptions)ParticleInit.SMOKY, x, y, z, 0, (double)0.2627451f, 0.6784313917160034, 0.40392157435417175, 1.0);
        }
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("isWolf", this.getWolf());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setWolf(tags.m_128471_("isWolf"));
    }

    public LivingEntity getRenderEntity() {
        if (this.entity == null) {
            this.entity = new PhantomWolf(this.m_9236_());
        }
        return this.entity;
    }

    public float getDamageRate() {
        return switch (this.getData()) {
            case 1 -> 0.67f;
            case 2 -> 1.0f;
            case 3 -> 1.375f;
            default -> 0.5f;
        };
    }

    @Override
    public SMElement getElement() {
        return SMElement.TOXIC;
    }
}

