/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class ToxicCircle
extends AbstractMagicShot {
    public boolean isPlayer = false;
    private boolean isFall = false;

    public ToxicCircle(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public ToxicCircle(double x, double y, double z, Level world) {
        this(EntityInit.toxicCircle, world);
        this.m_6034_(x, y, z);
    }

    public ToxicCircle(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isClient()) {
            return;
        }
        if (!this.isFall) {
            this.m_20256_(this.m_20184_().m_82490_(0.8));
            Vec3 vec = this.m_20184_();
            if (Math.abs(vec.f_82479_) <= 0.1 && Math.abs(vec.f_82481_) <= 0.1) {
                this.isFall = true;
            }
        } else {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
        }
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        this.rangeAttack(result.m_82425_().m_7494_(), this.getDamage(), this.getRange());
        this.m_146870_();
    }

    /*
     * WARNING - void declaration
     */
    public void rangeAttack(BlockPos pos, float dame, double range) {
        this.m_5496_(SoundEvents.f_144242_, 3.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(pos, range), range);
        for (LivingEntity livingEntity : entityList) {
            if (this.isPlayer((Entity)livingEntity)) {
                if (livingEntity.m_21023_(PotionInit.deadly_poison) || livingEntity.m_21023_(PotionInit.reflash_effect)) {
                    this.attackDamage(livingEntity, dame, false);
                    continue;
                }
                this.addPotion(livingEntity, PotionInit.deadly_poison, 200, 1);
                this.attackDamage(livingEntity, dame * 0.25f, false);
                continue;
            }
            this.addPotion(livingEntity, PotionInit.deadly_poison, 300, 2);
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            void var7_9;
            ServerLevel server = (ServerLevel)level;
            boolean bl = false;
            while (var7_9 < 3) {
                for (int i = 0; i < 3; ++i) {
                    this.spawnParticleRing(server, (ParticleOptions)ParticleInit.POISON, 2 + var7_9 * 4, pos, -0.25 + (double)i * 0.5);
                }
                ++var7_9;
            }
        }
    }

    public void spawnParticle(ServerLevel server) {
        if (this.f_19797_ % 30 == 0) {
            this.spawnParticleCycle(server, this.f_19854_, this.f_19855_ + 0.25, this.f_19856_, 0.85, this.rand, 10);
        }
    }

    protected void spawnParticleCycle(ServerLevel server, double x, double y, double z, double range, Random rand, int count) {
        for (int i = 0; i < count; ++i) {
            this.spawnParticleCycle(server, (ParticleOptions)ParticleInit.CYCLE_TOXIC, x, y, z, Direction.UP, range, (float)i * 36.0f, false);
            this.spawnParticleCycle(server, (ParticleOptions)ParticleInit.CYCLE_TOXIC, x, y, z, Direction.NORTH, range, (float)i * 36.0f, false);
            this.spawnParticleCycle(server, (ParticleOptions)ParticleInit.CYCLE_TOXIC, x, y, z, Direction.EAST, range, (float)i * 36.0f, false);
        }
    }

    protected void spawnParticleCycle(ServerLevel server, ParticleOptions particle, double x, double y, double z, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 1;
        server.m_8767_(particle, x, y, z, 0, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * 6.0f), 1.0);
    }

    public Predicate<LivingEntity> getFilter(BlockPos pos, double range) {
        return e -> !e.m_5833_() && e.m_6084_() && this.checkDistances(pos, e.m_20183_(), range * range);
    }

    public boolean isPlayer(Entity entity) {
        return entity instanceof Player || entity instanceof AbstractSummonMob;
    }

    @Override
    public SMElement getElement() {
        return SMElement.TOXIC;
    }
}

