/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.entity.monster.boss.WindWitchMaster;
import sweetmagic.init.entity.projectile.AbstractBossMagic;
import sweetmagic.init.entity.projectile.TripleTornadoShot;

public class WindStormMagic
extends AbstractBossMagic {
    private int chargeTime = 0;
    private static final int MAX_CHARGETIME = 70;
    private List<LivingEntity> entityList = new ArrayList<LivingEntity>();

    public WindStormMagic(EntityType<? extends WindStormMagic> entityType, Level world) {
        super((EntityType<? extends AbstractBossMagic>)entityType, world);
    }

    public WindStormMagic(double x, double y, double z, Level world) {
        this((EntityType<? extends WindStormMagic>)EntityInit.windStorm, world);
        this.m_6034_(x, y, z);
    }

    public WindStormMagic(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(info);
    }

    @Override
    public void onUpdate() {
        if (this.target != null && this.target.m_6084_()) {
            this.setRotInit();
            if (this.chargeTime++ < 70) {
                return;
            }
            if (this.entityList.isEmpty()) {
                this.entityList = this.setTarget(false);
                if (this.entityList.size() > 1) {
                    this.entityList = this.entityList.stream().sorted((s1, s2) -> this.sortEntity((Entity)this, (Entity)s1, (Entity)s2)).toList();
                    this.target = this.entityList.get(0);
                }
            }
            this.attackMagic(this.target);
        }
        if (!(this.target != null && this.target.m_6084_() || this.f_19797_ % 8 != 0)) {
            this.setTarget(true);
        }
    }

    public void attackMagic(LivingEntity target) {
        if (this.isClient()) {
            return;
        }
        WandInfo info = null;
        if (this.getStack().m_41720_() instanceof IWand) {
            info = new WandInfo(this.getStack());
        }
        if (info == null) {
            return;
        }
        this.entityList = this.setTarget(false);
        boolean isWarden = target instanceof Warden;
        float damage = (isWarden ? 60.0f : 40.0f) + this.getAddDamage();
        LivingEntity player = (LivingEntity)this.m_19749_();
        int count = this.getData() >= 1 ? 8 : 4;
        int size = Math.min(count, this.entityList.size());
        boolean isSmall = count != size;
        damage = isSmall ? damage * 1.5f : damage;
        double range = isSmall ? 10.0 : 6.0;
        for (int i = 0; i < size; ++i) {
            LivingEntity living = this.entityList.get(i);
            if (living == null) continue;
            TripleTornadoShot entity = new TripleTornadoShot(player);
            entity.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, 1.0f, 0.0f);
            entity.m_6686_(0.0, 0.0, 0.0, 0.0f, 0.0f);
            entity.m_6034_(living.f_19854_, living.f_19855_, living.f_19856_);
            entity.setHitDead(false);
            entity.setNotDamage(true);
            entity.setRange(range);
            entity.setAddDamage(damage);
            entity.isPlayer = false;
            this.m_9236_().m_7967_((Entity)entity);
        }
        this.chargeTime = 0;
        this.setTarget(true);
    }

    public List<LivingEntity> setTarget(boolean isSetTarget) {
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> e instanceof Enemy && e.m_6084_(), 48.0);
        if (!isSetTarget) {
            return entityList;
        }
        double dis = 0.0;
        this.target = null;
        for (LivingEntity entity : entityList) {
            if (this.target == null) {
                this.target = entity;
                dis = this.m_20280_((Entity)this.target);
                continue;
            }
            if (!(dis < this.m_20280_((Entity)entity))) continue;
            this.target = entity;
            dis = this.m_20280_((Entity)this.target);
        }
        return entityList;
    }

    @Override
    public LivingEntity getEntity() {
        if (this.summon == null) {
            WindWitchMaster queen = new WindWitchMaster(this.m_9236_());
            queen.setMagic(true);
            this.summon = queen;
        }
        return this.summon;
    }

    @Override
    public SMElement getElement() {
        return SMElement.CYCLON;
    }
}

