/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.antlr.v4.runtime.misc.NotNull;
import sweetmagic.api.iitem.IMFTool;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.EnderBall;
import sweetmagic.init.item.magic.SMTierItem;

public class EnderWand
extends SMTierItem
implements IMFTool {
    private int maxMF = 20000;
    public static final List<EnchantmentCategory> ENCHACATELIST = Arrays.asList(EnchantInit.ISMFTOOL, EnchantInit.ISALL, EnchantInit.ISWAND_HARNESS);

    public EnderWand(String name) {
        super(name, 1);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int chargeTime) {
        this.magicAction(world, (Player)entity, stack, Math.min(40, this.m_8105_(stack) - chargeTime));
    }

    public void magicAction(Level world, Player player, ItemStack stack, float chargeTime) {
        int useMF;
        int mf = this.getMF(stack);
        if (mf < (useMF = this.getNeedMF(stack)) && !player.m_7500_() || player.m_21023_(PotionInit.non_destructive) || world.m_5776_()) {
            return;
        }
        float shotSpeed = 1.0f;
        float f = chargeTime >= 10.0f ? 3.0f * (chargeTime / 60.0f) : 0.0f;
        EnderBall entity = new EnderBall((LivingEntity)player);
        entity.setAddDamage(-1.99f);
        entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, shotSpeed += f, 0.0f);
        world.m_7967_((Entity)entity);
        this.playSound(player.m_9236_(), player, SoundEvents.f_11705_, 0.5f, 0.67f);
        if (!player.m_7500_()) {
            this.setMF(stack, mf - useMF);
        }
    }

    public int getNeedMF(ItemStack stack) {
        int useMF = 400;
        int costDown = Math.min(99, this.getEnchantLevel(EnchantInit.mfCostDown, stack) * 10);
        useMF = (int)((float)useMF * ((float)(100 - costDown) / 100.0f));
        return useMF;
    }

    @Override
    public void addTip(ItemStack stack, List<Component> toolTip) {
        toolTip.add((Component)this.getText(this.name).m_130940_(GREEN));
        toolTip.add((Component)this.getText(this.name + "_entity").m_130940_(GREEN));
        toolTip.add((Component)this.getText(this.name + "_food").m_130940_(GREEN));
        toolTip.add((Component)this.getText(this.name + "_charge").m_130940_(GREEN));
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("mf"), ": ", this.getLabel(this.format(this.getMF(stack)), WHITE)}).m_130940_(GREEN));
    }

    @Override
    public int getMaxMF(ItemStack stack) {
        int addMaxMF = this.getEnchantLevel(EnchantInit.maxMFUP, stack) * 10 * (this.maxMF / 100);
        return this.maxMF + addMaxMF;
    }

    @Override
    public void setMaxMF(int maxMF) {
        this.maxMF = maxMF;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment encha) {
        return ENCHACATELIST.contains(encha.f_44672_) || encha != Enchantments.f_44986_ && encha.f_44672_.m_7454_(stack.m_41720_());
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getEnchantLevel(Enchantment enchant, ItemStack stack) {
        return Math.min(EnchantmentHelper.m_44843_((Enchantment)enchant, (ItemStack)stack), 10);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return this.getMF(stack) >= this.getMaxMF(stack) ? 3211145 : 50175;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getMF(stack) != 0;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return Math.min(13, Math.round(13.0f * (float)this.getMF(stack) / (float)this.getMaxMF(stack)));
    }
}

