/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import org.jetbrains.annotations.Nullable;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.emagic.SMMagicType;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.SoundInit;
import sweetmagic.init.item.magic.BaseMagicItem;

public class MFWeather
extends BaseMagicItem {
    private final int burnTime;
    private final int rainTime;

    public MFWeather(String name, SMElement ele, int burnTime, int rainTime) {
        super(name, SMMagicType.CHARGE, ele, 1, 40, 10, true);
        this.burnTime = burnTime;
        this.rainTime = rainTime;
    }

    @Override
    public List<MutableComponent> magicToolTip(List<MutableComponent> toolTip) {
        toolTip.add(this.getText(this.name));
        return toolTip;
    }

    @Override
    public boolean onItemAction(Level world, Player player, WandInfo wandInfo, MagicInfo magicInfo) {
        this.changeWeather(world);
        this.playSound(world, (LivingEntity)player, SoundInit.CHANGETIME, 0.15f, 1.0f);
        return true;
    }

    public void changeWeather(Level world) {
        LevelData levelData;
        if (!world.m_5776_() && (levelData = world.m_7654_().m_129880_(Level.f_46428_).m_6106_()) instanceof ServerLevelData) {
            ServerLevelData info = (ServerLevelData)levelData;
            int time = this.getRainTime();
            info.m_6399_(time);
            info.m_6398_(time);
            info.m_5557_(time > 0);
            info.m_5565_(time > 0);
        }
    }

    public int getRainTime() {
        return this.rainTime;
    }

    public int getBurnTime(ItemStack stack, @Nullable RecipeType<?> recipeType) {
        return this.burnTime;
    }
}

