/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.emagic.SMMagicType;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.item.magic.BaseMagicItem;

public class RankUpMagic
extends BaseMagicItem {
    private final int data;
    private int needEXP = 0;

    public RankUpMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data) {
        super(name, SMMagicType.NORMAL, ele, tier, coolTime, useMF, true);
        this.data = data;
    }

    public RankUpMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data, String iconName) {
        super(name, SMMagicType.NORMAL, ele, tier, coolTime, useMF, true, iconName);
        this.data = data;
    }

    @Override
    public List<MutableComponent> magicToolTip(List<MutableComponent> toolTip) {
        if (this.data == 5) {
            toolTip.add(this.getText("magic_creative").m_130940_(GREEN));
        } else {
            toolTip.add(this.getText("magic_aether_force", new Object[]{this.format(this.addExp())}));
        }
        return toolTip;
    }

    @Override
    public boolean onItemAction(Level world, Player player, WandInfo wandInfo, MagicInfo magicInfo) {
        ItemStack stack = wandInfo.getStack();
        boolean flag = true;
        switch (this.data) {
            case 5: {
                flag = this.rankUpMagic(world, player, stack, wandInfo);
            }
        }
        return flag;
    }

    public boolean rankUpMagic(Level world, Player player, ItemStack stack, WandInfo info) {
        IWand wand = info.getWand();
        int level = wand.getWandLevel(info.getStack());
        this.needEXP = wand.needExp(wand.getMaxLevel(), level + 1, stack);
        return true;
    }

    @Override
    public int addExp() {
        return switch (this.data) {
            case 1 -> 1000;
            case 2 -> 3000;
            case 3 -> 8000;
            case 4 -> 40000;
            case 5 -> this.needEXP;
            default -> 200;
        };
    }

    @Override
    public boolean canItemMagic(Level world, Player player, WandInfo info) {
        IWand wand = info.getWand();
        return !wand.isCreativeWand() && info.getLevel() < wand.getMaxLevel();
    }

    @Override
    public boolean isUniqueMagic() {
        return true;
    }

    @Override
    public boolean isAllShrink() {
        return this.data != 5;
    }
}

