/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.antlr.v4.runtime.misc.NotNull;
import sweetmagic.api.iitem.IAmorUtil;
import sweetmagic.api.iitem.IChoker;
import sweetmagic.api.iitem.IMFTool;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.TabInit;

public class SMChoker
extends ArmorItem
implements IChoker {
    public final int data;
    private int tickTime = 0;
    private final String name;
    public int maxMF;
    private static final EquipmentSlot[] SLOT = new EquipmentSlot[]{EquipmentSlot.CHEST, EquipmentSlot.FEET, EquipmentSlot.MAINHAND};

    public SMChoker(String name, int data, int maxMF) {
        super(IAmorUtil.getArmorMaterial(data), ArmorItem.Type.HELMET, IAmorUtil.getArmorPro());
        this.name = name;
        this.data = data;
        this.setMaxMF(maxMF);
        ItemInit.itemMap.put(new ItemInit.ItemInfo((Item)this, TabInit.smMagicTab), this.name);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (world.m_5776_() || this.isMFEmpty(stack) || ++this.tickTime % 200 != 0) {
            return;
        }
        this.tickTime = 0;
        for (EquipmentSlot slot : SLOT) {
            IMFTool mfTool;
            Item item;
            ItemStack armor = player.m_6844_(slot);
            if (armor.m_41619_() || !((item = armor.m_41720_()) instanceof IMFTool) || (mfTool = (IMFTool)item).isMaxMF(armor)) continue;
            int mf = this.getMF(stack);
            int useMF = Math.min(this.getHealValue(), mf);
            int needMF = mfTool.insetMF(armor, useMF);
            this.setMF(stack, mf - needMF);
            if (!this.isMFEmpty(stack)) continue;
            return;
        }
    }

    public int getHealValue() {
        return switch (this.data) {
            case 1 -> 5000;
            case 2 -> 25000;
            default -> 1000;
        };
    }

    @Override
    public int getMaxMF(ItemStack stack) {
        int addMaxMF = this.getEnchantLevel(EnchantInit.maxMFUP, stack) * 10 * (this.maxMF / 100);
        return this.maxMF + addMaxMF;
    }

    @Override
    public void setMaxMF(int maxMF) {
        this.maxMF = maxMF;
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return this.getMF(stack) >= this.getMaxMF(stack) ? 3211145 : 50175;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getMF(stack) != 0;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return Math.min(13, Math.round(13.0f * (float)this.getMF(stack) / (float)this.getMaxMF(stack)));
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    @Override
    public int getTier() {
        return this.data + 1;
    }

    public void initializeClient(Consumer<IClientItemExtensions> con) {
        con.accept(IAmorUtil.ArmorRobeRender.INSTANCE);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "sweetmagic:textures/block/empty.png";
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment encha) {
        return ENCHACATELIST.contains(encha.f_44672_) || encha != Enchantments.f_44986_ && encha.f_44672_.m_7454_(stack.m_41720_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> toolTip, TooltipFlag flag) {
        toolTip.add((Component)this.getText("aether_choker").m_130940_(GOLD));
    }
}

