/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;
import org.antlr.v4.runtime.misc.NotNull;
import sweetmagic.api.iitem.IAmorUtil;
import sweetmagic.api.iitem.IRobe;
import sweetmagic.event.KeyPressEvent;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.tile.menu.container.BaseContainer;
import sweetmagic.key.SMKeybind;

public class SMRobe
extends ArmorItem
implements IRobe,
IAmorUtil {
    private final String name;
    public final int data;
    public int maxMF;

    public SMRobe(String name, int data, int maxMF) {
        super(IAmorUtil.getArmorMaterial(data), ArmorItem.Type.CHESTPLATE, IAmorUtil.getArmorPro());
        this.name = name;
        this.data = data;
        this.setMaxMF(maxMF);
        ItemInit.itemMap.put(new ItemInit.ItemInfo((Item)this, TabInit.smMagicTab), this.name);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        ImmutableMultimap.Builder map = ImmutableMultimap.builder();
        map.putAll(super.m_7167_(slot));
        map.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(IAmorUtil.SMATTACKREACH, "SM Reach", (double)(2.5f * (float)this.data), AttributeModifier.Operation.ADDITION));
        return slot == EquipmentSlot.CHEST ? map.build() : super.m_7167_(slot);
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    @Override
    public float getSMMobDamageCut() {
        return this.getTier() == 1 ? 0.67f : 0.5f;
    }

    @Override
    public float getMagicDamageCut() {
        return this.getTier() == 1 ? 0.67f : 0.35f;
    }

    @Override
    public void openGui(Level world, Player player, ItemStack stack) {
        if (!world.m_5776_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new BaseContainer.ContainerRobe(stack));
            this.playSound(world, player, SoundInit.ROBE, 0.0625f, 1.0f);
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> con) {
        con.accept(IAmorUtil.ArmorRobeRender.INSTANCE);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String typeIn) {
        return "sweetmagic:textures/armor/" + this.name + ".png";
    }

    @Override
    public int getMaxMF(ItemStack stack) {
        int addMaxMF = this.getEnchantLevel(EnchantInit.maxMFUP, stack) * 10 * (this.maxMF / 100);
        return this.maxMF + addMaxMF;
    }

    @Override
    public void setMaxMF(int maxMF) {
        this.maxMF = maxMF;
    }

    @Override
    public int getTier() {
        return this.data + 1;
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return this.getMF(stack) >= this.getMaxMF(stack) ? 3211145 : 50175;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getMF(stack) != 0;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return Math.min(13, Math.round(13.0f * (float)this.getMF(stack) / (float)this.getMaxMF(stack)));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return ENCHACATELIST.contains(enchant.f_44672_) || enchant != Enchantments.f_44986_ && enchant.f_44672_.m_7454_(stack.m_41720_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> toolTip, TooltipFlag flag) {
        MutableComponent keyOpen = KeyPressEvent.getKeyName(SMKeybind.OPEN);
        toolTip.add((Component)this.getTipArray(new Object[]{keyOpen.m_6881_(), this.getText("key"), this.getText("magicians_robe")}).m_130940_(RED));
    }
}

