/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.Level;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.emagic.SMMagicType;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.BloodMagicShot;
import sweetmagic.init.entity.projectile.BubbleMagicShot;
import sweetmagic.init.entity.projectile.BulletMagicShot;
import sweetmagic.init.entity.projectile.CherryMagicShot;
import sweetmagic.init.entity.projectile.CriticalMagicShot;
import sweetmagic.init.entity.projectile.CycloneMagicShot;
import sweetmagic.init.entity.projectile.DigMagicShot;
import sweetmagic.init.entity.projectile.ExplosionMagicShot;
import sweetmagic.init.entity.projectile.FireMagicShot;
import sweetmagic.init.entity.projectile.FrostMagicShot;
import sweetmagic.init.entity.projectile.GravityMagicShot;
import sweetmagic.init.entity.projectile.LightMagicShot;
import sweetmagic.init.entity.projectile.NormalMagicShot;
import sweetmagic.init.entity.projectile.PoisonMagicShot;
import sweetmagic.init.entity.projectile.RockBlastMagicShot;
import sweetmagic.init.item.magic.BaseMagicItem;

public class ShotMagic
extends BaseMagicItem {
    public final int data;

    public ShotMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data) {
        super(name, SMMagicType.SHOT, ele, tier, coolTime, useMF, false);
        this.data = data;
    }

    public ShotMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data, String iconName) {
        super(name, SMMagicType.SHOT, ele, tier, coolTime, useMF, false, iconName);
        this.data = data;
    }

    public ShotMagic(String name, SMElement ele, SMElement subEle, int tier, int coolTime, int useMF, int data, String iconName) {
        super(name, SMMagicType.SHOT, ele, subEle, tier, coolTime, useMF, false, iconName);
        this.data = data;
    }

    @Override
    public List<MutableComponent> magicToolTip(List<MutableComponent> toolTip) {
        switch (this.data) {
            case 4: {
                toolTip.add(this.getText(this.name));
                toolTip.add(this.getText(this.name + "_damage"));
                break;
            }
            case 19: {
                toolTip.add(this.getText("magic_blood_read"));
                toolTip.add(this.getText("magic_health", new Object[]{this.formatPar(50.0f, WHITE)}));
                toolTip.add(this.getText("blood_heart"));
                break;
            }
            case 20: {
                toolTip.add(this.getText("magic_blood_read"));
                toolTip.add(this.getText("magic_health", new Object[]{this.formatPar(75.0f, WHITE)}));
                toolTip.add(this.getText("magic_food0"));
                toolTip.add(this.getText("magic_food1", new Object[]{this.formatPar(50.0f, WHITE)}));
                toolTip.add(this.getText("blood_heart"));
                break;
            }
            case 18: {
                toolTip.add(this.getText("magic_bubleprison"));
                toolTip.add(this.getText(this.name));
                break;
            }
            case 21: {
                toolTip.add(this.getText(this.name));
                break;
            }
            case 23: {
                toolTip.add(this.getText("magic_illuminate", new Object[]{1}));
                toolTip.add(this.getText(this.name));
                toolTip.add(this.getText("magic_critical_damage", new Object[]{this.formatPar(5.0f, WHITE)}));
                break;
            }
            case 24: {
                toolTip.add(this.getText("magic_illuminate", new Object[]{3}));
                toolTip.add(this.getText("magic_holy_light"));
                toolTip.add(this.getText("magic_critical_damage", new Object[]{this.formatPar(7.5f, WHITE)}));
                break;
            }
            case 25: {
                toolTip.add(this.getText("magic_storm"));
                toolTip.add(this.getText(this.name));
                toolTip.add(this.getText("magic_tempest_storm", new Object[]{this.getEffectTip("bleeding").getString(), 1}));
                break;
            }
            case 28: {
                toolTip.add(this.getText("magic_bubleprison"));
                toolTip.add(this.getText("magic_scumefang"));
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                toolTip.add(this.getText("magic_rockblast", new Object[]{this.data - 28 + "-" + (this.data - 26)}));
                break;
            }
            case 32: {
                toolTip.add(this.getText("magic_blood_read"));
                toolTip.add(this.getText("magic_health", new Object[]{this.formatPar(100.0f, WHITE)}));
                toolTip.add(this.getText("magic_food0"));
                toolTip.add(this.getText("magic_food1", new Object[]{this.formatPar(75.0f, WHITE)}));
                toolTip.add(this.getText("magic_add"));
                break;
            }
            case 34: 
            case 35: {
                toolTip.add(this.getText(this.name));
                toolTip.add(this.getText(this.name + "_vulnerable"));
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                toolTip.add(this.getText("magic_cherry"));
                toolTip.add(this.getText("magic_cherry_vulnerable", new Object[]{this.getEnchaTip(Math.max(1, this.data - 36)).getString()}));
                break;
            }
            case 39: {
                toolTip.add(this.getText("magic_illuminate", new Object[]{5}));
                toolTip.add(this.getText(this.name, new Object[]{this.getEffectTip("flame").getString(), this.getMCTip("glowing").getString()}));
                toolTip.add(this.getText("magic_critical_damage", new Object[]{this.formatPar(10.0f, WHITE)}));
                break;
            }
            case 40: {
                toolTip.add(this.getText("magic_meteor"));
                toolTip.add(this.getText("magic_meteor_vulnerable"));
                break;
            }
            case 41: {
                toolTip.add(this.getText("magic_frostrain"));
                toolTip.add(this.getText("magic_frostrain_vulnerable"));
                break;
            }
            case 42: {
                String bleed = this.getEffectTip("bleeding").getString();
                toolTip.add(this.getText("magic_storm"));
                toolTip.add(this.getText("magic_gale", new Object[]{this.getEnchaTip(2).getString()}));
                toolTip.add(this.getText("magic_tempest_storm", new Object[]{bleed, 2}));
                toolTip.add(this.getText("magic_tempest_storm_damage", new Object[]{bleed}));
                break;
            }
            case 43: {
                toolTip.add(this.getText("magic_magia_destroy"));
                toolTip.add(this.getText(this.name));
                break;
            }
            case 45: {
                toolTip.add(this.getText(this.name, new Object[]{this.getEffectTip("deadly_poison").getString(), this.getEffectTip("magic_damage_receive").getString()}));
                toolTip.add(this.getText(this.name + "_dame", new Object[]{this.getEffectTip("reflash_effect").getString()}));
                break;
            }
            case 46: {
                toolTip.add(this.getText("magic_range_dig"));
                break;
            }
            case 47: {
                toolTip.add(this.getText("magic_rockblast", new Object[]{"5-8"}));
                break;
            }
            case 48: {
                toolTip.add(this.getText("magic_cherry"));
                toolTip.add(this.getText("magic_cherry_vulnerable", new Object[]{this.getEnchaTip(3).getString()}));
                break;
            }
            case 49: {
                toolTip.add(this.getText("magic_advance"));
                toolTip.add(this.getText(this.name));
                break;
            }
            case 50: {
                toolTip.add(this.getText("magic_bubleprison"));
                toolTip.add(this.getText("magic_scumefang"));
                toolTip.add(this.getText(this.name));
                break;
            }
            case 51: {
                toolTip.add(this.getText("magic_blood_read"));
                toolTip.add(this.getText("magic_health", new Object[]{this.formatPar(150.0f, WHITE)}));
                toolTip.add(this.getText("magic_food0"));
                toolTip.add(this.getText("magic_food1", new Object[]{this.formatPar(100.0f, WHITE)}));
                toolTip.add(this.getText("magic_add"));
                toolTip.add(this.getText("magic_buff"));
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                toolTip.add(this.getText("magic_critical_chance", new Object[]{this.formatPar(10.0f + (float)((this.data - 52) * 5), WHITE)}));
                toolTip.add(this.getText("magic_critical_damage", new Object[]{this.formatPar(8.0f + (float)((this.data - 52) * 4), WHITE)}));
                if (this.data < 53) break;
                toolTip.add(this.getText("magic_critical_range"));
                break;
            }
            default: {
                toolTip.add(this.getText(this.name));
            }
        }
        return toolTip;
    }

    @Override
    public boolean onItemAction(Level world, Player player, WandInfo wInfo, MagicInfo mInfo) {
        AbstractMagicShot entity = null;
        RandomSource rand = world.m_213780_();
        float level = wInfo.getLevel();
        float power = this.getPower(wInfo);
        float shotSpeed = 2.0f + level * 0.05f;
        FoodData foodData = player.m_36324_();
        boolean hasBlood = this.hasBloodSuckingRing(player);
        switch (this.data) {
            case 0: {
                entity = new LightMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 0.3f);
                break;
            }
            case 1: {
                entity = new FireMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power);
                break;
            }
            case 2: {
                entity = new FireMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.35f);
                entity.setRange(5.0);
                entity.setData(1);
                break;
            }
            case 3: {
                entity = new FrostMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power);
                break;
            }
            case 4: {
                entity = new FrostMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.75f);
                entity.setHitDead(false);
                entity.setData(1);
                break;
            }
            case 5: {
                entity = new CycloneMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power);
                entity.setRange(2.0);
                break;
            }
            case 6: {
                entity = new CycloneMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.25f);
                entity.setRange(6.0);
                entity.setData(1);
                break;
            }
            case 7: {
                entity = new ExplosionMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power);
                entity.setCapRelaxationDamage(entity.getAddDamage() * 0.15f);
                entity.setRange(3.0);
                break;
            }
            case 8: {
                entity = new ExplosionMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.25f);
                entity.setCapRelaxationDamage(entity.getAddDamage() * 0.2f);
                entity.setRange(6.0);
                entity.setData(1);
                break;
            }
            case 9: {
                entity = new GravityMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power);
                break;
            }
            case 10: {
                entity = new GravityMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.5f);
                entity.setRange(5.0);
                entity.setData(1);
                break;
            }
            case 11: {
                entity = new PoisonMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power);
                break;
            }
            case 12: {
                entity = new PoisonMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.5f);
                entity.setRange(7.5);
                entity.setData(1);
                break;
            }
            case 13: {
                entity = new DigMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 0.33f);
                break;
            }
            case 14: {
                entity = new DigMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 0.67f);
                entity.setData(1);
                break;
            }
            case 15: {
                entity = new NormalMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 0.65f);
                break;
            }
            case 16: {
                entity = new BulletMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 0.95f);
                entity.setRange(6.0);
                entity.setMaxLifeTime(70);
                break;
            }
            case 17: {
                entity = new BubbleMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power);
                entity.setCapRelaxationDamage(entity.getAddDamage() * 0.075f);
                break;
            }
            case 18: {
                entity = new BubbleMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.75f);
                entity.setCapRelaxationDamage(entity.getAddDamage() * 0.15f);
                entity.setData(1);
                break;
            }
            case 19: {
                entity = new BloodMagicShot(world, (LivingEntity)player, wInfo);
                float healthRate = player.m_21223_() >= player.m_21233_() * 0.5f ? 1.5f : 1.0f;
                entity.setAddDamage(entity.getAddDamage() + power * healthRate);
                if (player.m_7500_() || !(player.m_21223_() > 1.0f) || hasBlood) break;
                player.m_21153_(player.m_21223_() - 1.0f);
                break;
            }
            case 20: {
                entity = new BloodMagicShot(world, (LivingEntity)player, wInfo);
                float healthRate2 = player.m_21223_() >= player.m_21233_() * 0.5f ? 1.75f : 1.0f;
                float foodRate2 = foodData.m_38702_() >= 10 ? 1.5f : 1.0f;
                entity.setAddDamage(entity.getAddDamage() + power * healthRate2);
                entity.setData(1);
                entity.setRange(5.0 * (double)foodRate2);
                if (player.m_7500_() || !(player.m_21223_() > 1.0f) || hasBlood) break;
                player.m_21153_(player.m_21223_() - 1.0f);
                foodData.m_38705_(foodData.m_38702_() - 1);
                break;
            }
            case 21: {
                entity = new BulletMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.25f);
                entity.setRange(12.0);
                entity.setMaxLifeTime(80);
                entity.setBlockPenetration(true);
                break;
            }
            case 22: {
                entity = new ExplosionMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.75f);
                entity.setCapRelaxationDamage(entity.getAddDamage() * 0.25f);
                entity.setRange(9.0);
                entity.setData(2);
                break;
            }
            case 23: {
                entity = new LightMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.25f);
                entity.setBaseCriticalDamage(entity.getBaseCriticalDamage() + 0.05f);
                entity.setCapRelaxationDamage(entity.getAddDamage() * 0.05f);
                entity.setRange(4.0);
                entity.setData(1);
                break;
            }
            case 24: {
                entity = new LightMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.5f);
                entity.setBaseCriticalDamage(entity.getBaseCriticalDamage() + 0.075f);
                entity.setCapRelaxationDamage(entity.getAddDamage() * 0.1f);
                entity.setRange(9.0);
                entity.setData(2);
                break;
            }
            case 25: {
                entity = new CycloneMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.75f);
                entity.setRange(14.0);
                entity.setData(2);
                break;
            }
            case 26: {
                entity = new GravityMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.75f);
                entity.setRange(10.0);
                entity.setData(2);
                entity.setHitDead(false);
                break;
            }
            case 27: {
                entity = new PoisonMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.75f);
                entity.setRange(12.0);
                entity.setData(2);
                break;
            }
            case 28: {
                entity = new BubbleMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.25f);
                entity.setCapRelaxationDamage(entity.getAddDamage() * 0.225f);
                entity.setData(2);
                entity.setAddAttack(entity.getAddAttack() + 2);
                break;
            }
            case 29: {
                entity = new RockBlastMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.25f);
                entity.setData(0);
                entity.setAddAttack(entity.getAddAttack() + rand.m_188503_(3) + 1);
                break;
            }
            case 30: {
                entity = new RockBlastMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.65f);
                entity.setData(1);
                entity.setAddAttack(entity.getAddAttack() + rand.m_188503_(3) + 2);
                break;
            }
            case 31: {
                entity = new RockBlastMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.0f);
                entity.setData(2);
                entity.setAddAttack(entity.getAddAttack() + rand.m_188503_(3) + 3);
                break;
            }
            case 32: {
                entity = new BloodMagicShot(world, (LivingEntity)player, wInfo);
                float healthRate3 = player.m_21223_() >= player.m_21233_() * 0.5f ? 2.0f : 1.0f;
                float foodRate3 = foodData.m_38702_() >= 10 ? 1.75f : 1.0f;
                entity.setAddDamage(entity.getAddDamage() + power * healthRate3);
                entity.setData(2);
                entity.setRange(8.0f * foodRate3);
                if (player.m_7500_() || !(player.m_21223_() > 1.0f) || hasBlood) break;
                player.m_21153_(player.m_21223_() - 1.0f);
                foodData.m_38705_(foodData.m_38702_() - 1);
                break;
            }
            case 33: {
                entity = new DigMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power);
                entity.setData(2);
                entity.setBlockPenetration(true);
                entity.setMaxBreak(2);
                break;
            }
            case 34: {
                entity = new FireMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.0f);
                entity.setRange(8.25);
                entity.setData(2);
                break;
            }
            case 35: {
                entity = new FrostMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.0f);
                entity.setRange(8.25);
                entity.setData(2);
                break;
            }
            case 36: {
                entity = new CherryMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.0f);
                entity.setRange(1.0);
                entity.setData(0);
                break;
            }
            case 37: {
                entity = new CherryMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.33f);
                entity.setRange(4.0);
                entity.setData(1);
                break;
            }
            case 38: {
                entity = new CherryMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.75f);
                entity.setRange(10.0);
                entity.setData(2);
                break;
            }
            case 39: {
                entity = new LightMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.5f);
                entity.setBaseCriticalDamage(entity.getBaseCriticalDamage() + 0.1f);
                entity.setCapRelaxationDamage(entity.getAddDamage() * 0.15f);
                entity.setRange(12.0);
                entity.setData(3);
                break;
            }
            case 40: {
                entity = new FireMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.5f);
                entity.setRange(12.0);
                entity.setData(3);
                break;
            }
            case 41: {
                entity = new FrostMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.5f);
                entity.setRange(12.0);
                entity.setData(3);
                break;
            }
            case 42: {
                entity = new CycloneMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.25f);
                entity.setRange(18.5);
                entity.setData(3);
                break;
            }
            case 43: {
                entity = new ExplosionMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.5f);
                entity.setCapRelaxationDamage(entity.getAddDamage() * 0.3f);
                entity.setRange(14.0);
                entity.setData(3);
                entity.setAddAttack(3);
                break;
            }
            case 44: {
                entity = new GravityMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.5f);
                entity.setRange(15.0);
                entity.setData(3);
                entity.setHitDead(false);
                break;
            }
            case 45: {
                entity = new PoisonMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.25f);
                entity.setRange(15.0);
                entity.setData(3);
                break;
            }
            case 46: {
                entity = new DigMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.5f);
                entity.setData(3);
                entity.setBlockPenetration(true);
                entity.setMaxBreak(7);
                break;
            }
            case 47: {
                entity = new RockBlastMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.5f);
                entity.setData(3);
                entity.setAddAttack(entity.getAddAttack() + rand.m_188503_(4) + 5);
                break;
            }
            case 48: {
                entity = new CherryMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.25f);
                entity.setRange(15.0);
                entity.setData(3);
                break;
            }
            case 49: {
                entity = new BulletMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.67f);
                entity.setRange(20.0);
                entity.setMaxLifeTime(100);
                entity.setData(3);
                entity.setBlockPenetration(true);
                entity.setHitDead(false);
                break;
            }
            case 50: {
                entity = new BubbleMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.67f);
                entity.setCapRelaxationDamage(entity.getAddDamage() * 0.3f);
                entity.setData(3);
                entity.setAddAttack(entity.getAddAttack() + 3);
                break;
            }
            case 51: {
                entity = new BloodMagicShot(world, (LivingEntity)player, wInfo);
                float healthRate4 = player.m_21223_() >= player.m_21233_() * 0.5f ? 2.5f : 1.0f;
                float foodRate4 = foodData.m_38702_() >= 10 ? 2.0f : 1.0f;
                entity.setAddDamage(entity.getAddDamage() + power * healthRate4);
                entity.setData(3);
                entity.setRange(12.0f * foodRate4);
                if (!player.m_7500_() && player.m_21223_() > 1.0f && !hasBlood) {
                    player.m_21153_(player.m_21223_() - 1.0f);
                    foodData.m_38705_(foodData.m_38702_() - 1);
                }
                this.addPotion((LivingEntity)player, PotionInit.blood_curse, 0, 600);
                break;
            }
            case 52: {
                entity = new CriticalMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.1f);
                entity.setRange(0.0);
                entity.setCriticalChance(0.1f);
                entity.setBaseCriticalDamage(entity.getBaseCriticalDamage() + 0.08f);
                entity.setData(0);
                break;
            }
            case 53: {
                entity = new CriticalMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 1.75f);
                entity.setRange(2.0);
                entity.setCriticalChance(0.15f);
                entity.setBaseCriticalDamage(entity.getBaseCriticalDamage() + 0.12f);
                entity.setData(1);
                break;
            }
            case 54: {
                entity = new CriticalMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 2.25f);
                entity.setRange(4.0);
                entity.setCriticalChance(0.2f);
                entity.setBaseCriticalDamage(entity.getBaseCriticalDamage() + 0.16f);
                entity.setData(2);
                break;
            }
            case 55: {
                entity = new CriticalMagicShot(world, (LivingEntity)player, wInfo);
                entity.setAddDamage(entity.getAddDamage() + power * 3.0f);
                entity.setRange(6.0);
                entity.setCriticalChance(entity.getCriticalChance() + 0.25f);
                entity.setBaseCriticalDamage(entity.getBaseCriticalDamage() + 0.2f);
                entity.setData(3);
            }
        }
        entity.acceEffect(wInfo);
        entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, shotSpeed, 0.0f);
        world.m_7967_((Entity)entity);
        wInfo.getWand().shotSound(player);
        this.acceEffect(player, Float.valueOf(this.getPower(wInfo)));
        return true;
    }
}

