/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.sm;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import sweetmagic.api.util.ISMTip;
import sweetmagic.init.ItemInit;
import sweetmagic.init.TabInit;
import sweetmagic.util.WorldHelper;

public class SMItem
extends Item
implements ISMTip {
    public final String name;
    public static float SPEED = 6.0f;
    public final Random rand = new Random();

    public SMItem(String name) {
        super(SMItem.setItem());
        this.name = name;
        this.register(TabInit.smTab);
    }

    public SMItem(String name, CreativeModeTab tab) {
        super(SMItem.setItem());
        this.name = name;
        this.register(tab);
    }

    public SMItem(String name, Item.Properties pro, CreativeModeTab tab) {
        super(pro);
        this.name = name;
        this.register(tab);
    }

    public SMItem(String name, boolean flag) {
        super(new Item.Properties());
        this.name = name;
        this.register(null);
    }

    public void register(CreativeModeTab tab) {
        ItemInit.itemMap.put(new ItemInit.ItemInfo(this, tab), this.name);
    }

    public String getRegistryName() {
        return this.name;
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Entity entity, double range) {
        return WorldHelper.getEntityList(entity, enClass, this.getAABB(entity.m_20183_(), range));
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Entity entity, Predicate<T> filter, double range) {
        return WorldHelper.getEntityList(entity, enClass, filter, this.getAABB(entity.m_20183_(), range));
    }

    public AABB getAABB(BlockPos pos, double range) {
        return this.getAABB(pos, range, range, range);
    }

    public AABB getAABB(BlockPos pos, double x, double y, double z) {
        return WorldHelper.getAABB(pos, x, y, z);
    }

    public static Item.Properties setItem() {
        return new Item.Properties();
    }

    public static Item.Properties setItem(int value) {
        return SMItem.setItem().m_41503_(value);
    }

    public void spawnItem(Level world, BlockPos pos, ItemStack stack) {
        ItemEntity entity = new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.75f), (double)((float)pos.m_123343_() + 0.5f), stack);
        entity.m_32061_();
        entity.m_149678_();
        world.m_7967_((Entity)entity);
    }

    public void playSound(Entity entity, SoundEvent sound, float vol, float pitch) {
        entity.m_9236_().m_6269_(null, entity, sound, SoundSource.PLAYERS, vol, pitch);
    }

    protected void spawnParticleRing(Level world, ParticleOptions par, double range, double x, double y, double z, double addY, double ySpeed, double moveValue) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)world;
        y += addY;
        RandomSource rand = world.m_213780_();
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 1.0) {
            double yS = ySpeed;
            if (ySpeed != 0.0) {
                yS += (double)(rand.m_188501_() * 0.025f);
            }
            server.m_8767_(par, x + Math.cos(degree), y, z + Math.sin(degree), 0, 0.0, yS, 0.0, moveValue);
        }
    }

    protected void spawnParticleCycle(ServerLevel server, ParticleOptions par, double x, double y, double z, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 1;
        server.m_8767_(par, x, y, z, 0, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * SPEED), 1.0);
    }

    public float getRandFloat() {
        return this.rand.nextFloat() - this.rand.nextFloat();
    }

    public float getRandFloat(float rate) {
        return this.getRandFloat() * rate;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> toolTip, TooltipFlag flag) {
        this.addTip(stack, toolTip);
    }

    public void addTip(ItemStack stack, List<Component> toolTip) {
    }
}

