/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.util.RenderUtil;

public abstract class RenderAbstractTile<T extends TileAbstractSM>
implements BlockEntityRenderer<T> {
    private static final float FLUID_OFFSET = 0.005f;
    protected final float pi = 57.295776f;
    protected final Font font;
    protected final ItemRenderer iRender;
    protected final BlockRenderDispatcher bRender;
    protected final EntityRenderDispatcher eRender;
    protected static final int NO_OVERLAY = OverlayTexture.f_118083_;

    public RenderAbstractTile(BlockEntityRendererProvider.Context con) {
        this.font = con.m_173586_();
        this.iRender = con.m_234447_();
        this.bRender = con.m_173584_();
        this.eRender = con.m_234446_();
    }

    public int m_142163_() {
        return 48;
    }

    public void render(T tile, float parTick, PoseStack pose, MultiBufferSource buf, int light, int overlayLight) {
        if (tile.m_58904_() == null || ((TileAbstractSM)tile).isAir()) {
            return;
        }
        this.render(tile, parTick, new RenderUtil.RenderInfo(this.iRender, light, overlayLight, pose, buf, tile.m_58904_()));
    }

    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
    }

    public void renderLargeFluidCuboid(PoseStack pose, VertexConsumer ver, int light, int xd, float[] xBounds, int zd, float[] zBounds, float yMin, float yMax, TextureAtlasSprite still, int color) {
        if (yMin >= yMax) {
            return;
        }
        int yd = (int)(yMax - (float)((int)yMin));
        if ((double)yMax % 1.0 == 0.0) {
            --yd;
        }
        float[] yBounds = this.getBlockBounds(yd, yMin, yMax);
        Matrix4f matrix = pose.m_85850_().m_252922_();
        Vector3f from = new Vector3f();
        Vector3f to = new Vector3f();
        int rot = 0;
        for (int y = 0; y <= yd; ++y) {
            for (int z = 0; z <= zd; ++z) {
                for (int x = 0; x <= xd; ++x) {
                    from.set(xBounds[x], yBounds[y], zBounds[z]);
                    to.set(xBounds[x + 1], yBounds[y + 1], zBounds[z + 1]);
                    if (x == 0) {
                        this.putTexturedQuad(ver, matrix, still, from, to, Direction.WEST, color, light, rot, false);
                    }
                    if (x == xd) {
                        this.putTexturedQuad(ver, matrix, still, from, to, Direction.EAST, color, light, rot, false);
                    }
                    if (z == 0) {
                        this.putTexturedQuad(ver, matrix, still, from, to, Direction.NORTH, color, light, rot, false);
                    }
                    if (z == zd) {
                        this.putTexturedQuad(ver, matrix, still, from, to, Direction.SOUTH, color, light, rot, false);
                    }
                    if (y == yd) {
                        this.putTexturedQuad(ver, matrix, still, from, to, Direction.UP, color, light, rot, false);
                    }
                    if (y != 0) continue;
                    from.y = from.y() + 0.001f;
                    this.putTexturedQuad(ver, matrix, still, from, to, Direction.DOWN, color, light, rot, false);
                }
            }
        }
    }

    public float[] getBlockBounds(int delta) {
        return this.getBlockBounds(delta, 0.005f, (float)delta + 1.0f - 0.005f);
    }

    public float[] getBlockBounds(int delta, float start, float end) {
        float[] bounds = new float[2 + delta];
        bounds[0] = start;
        int offset = (int)start;
        for (int i = 1; i <= delta; ++i) {
            bounds[i] = i + offset;
        }
        bounds[delta + 1] = end;
        return bounds;
    }

    public TextureAtlasSprite getBlockSprite(ResourceLocation src) {
        return Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(src);
    }

    public int withBlockLight(int combinedLight, int blockLight) {
        return combinedLight & 0xFFFF0000 | Math.max(blockLight << 4, combinedLight & 0xFFFF);
    }

    public void putTexturedQuad(VertexConsumer ver, Matrix4f mat, TextureAtlasSprite sprite, Vector3f from, Vector3f to, Direction face, int color, int light, int rot, boolean flowing) {
        float u4;
        float v3;
        float u3;
        float maxV;
        float minV;
        float maxU;
        float minU;
        double size;
        float temp;
        float v1;
        float u2;
        float u1;
        float x1 = from.x();
        float y1 = from.y();
        float z1 = from.z();
        float x2 = to.x();
        float y2 = to.y();
        float z2 = to.z();
        float v2 = switch (face) {
            default -> {
                u1 = x1;
                u2 = x2;
                v1 = z2;
                yield z1;
            }
            case Direction.UP -> {
                u1 = x1;
                u2 = x2;
                v1 = -z1;
                yield -z2;
            }
            case Direction.NORTH -> {
                u1 = -x1;
                u2 = -x2;
                v1 = y1;
                yield y2;
            }
            case Direction.SOUTH -> {
                u1 = x2;
                u2 = x1;
                v1 = y1;
                yield y2;
            }
            case Direction.WEST -> {
                u1 = z2;
                u2 = z1;
                v1 = y1;
                yield y2;
            }
            case Direction.EAST -> {
                u1 = -z1;
                u2 = -z2;
                v1 = y1;
                yield y2;
            }
        };
        if (rot == 0 || rot == 270) {
            temp = v1;
            v1 = -v2;
            v2 = -temp;
        }
        if (rot >= 180) {
            temp = u1;
            u1 = -u2;
            u2 = -temp;
        }
        boolean reverse = u1 > u2;
        u1 = this.boundUV(u1, reverse);
        u2 = this.boundUV(u2, !reverse);
        reverse = v1 > v2;
        v1 = this.boundUV(v1, reverse);
        v2 = this.boundUV(v2, !reverse);
        double d = size = flowing ? 8.0 : 16.0;
        if (rot % 180 == 90) {
            minU = sprite.m_118367_((double)v1 * size);
            maxU = sprite.m_118367_((double)v2 * size);
            minV = sprite.m_118393_((double)u1 * size);
            maxV = sprite.m_118393_((double)u2 * size);
        } else {
            minU = sprite.m_118367_((double)u1 * size);
            maxU = sprite.m_118367_((double)u2 * size);
            minV = sprite.m_118393_((double)v1 * size);
            maxV = sprite.m_118393_((double)v2 * size);
        }
        float v4 = switch (rot) {
            default -> {
                u1 = minU;
                v1 = maxV;
                u2 = minU;
                v2 = minV;
                u3 = maxU;
                v3 = minV;
                u4 = maxU;
                yield maxV;
            }
            case 90 -> {
                u1 = minU;
                v1 = minV;
                u2 = maxU;
                v2 = minV;
                u3 = maxU;
                v3 = maxV;
                u4 = minU;
                yield maxV;
            }
            case 180 -> {
                u1 = maxU;
                v1 = minV;
                u2 = maxU;
                v2 = maxV;
                u3 = minU;
                v3 = maxV;
                u4 = minU;
                yield minV;
            }
            case 270 -> {
                u1 = maxU;
                v1 = maxV;
                u2 = minU;
                v2 = maxV;
                u3 = minU;
                v3 = minV;
                u4 = maxU;
                yield minV;
            }
        };
        int light1 = light & 0xFFFF;
        int light2 = light >> 16 & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        switch (face) {
            case DOWN: {
                ver.m_252986_(mat, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_5752_();
                break;
            }
            case UP: {
                ver.m_252986_(mat, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_5752_();
                break;
            }
            case NORTH: {
                ver.m_252986_(mat, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_5752_();
                break;
            }
            case SOUTH: {
                ver.m_252986_(mat, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_5752_();
                break;
            }
            case WEST: {
                ver.m_252986_(mat, x1, y1, z2).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x1, y2, z2).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x1, y2, z1).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x1, y1, z1).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_5752_();
                break;
            }
            case EAST: {
                ver.m_252986_(mat, x2, y1, z1).m_6122_(r, g, b, a).m_7421_(u1, v1).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x2, y2, z1).m_6122_(r, g, b, a).m_7421_(u2, v2).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x2, y2, z2).m_6122_(r, g, b, a).m_7421_(u3, v3).m_7120_(light1, light2).m_5752_();
                ver.m_252986_(mat, x2, y1, z2).m_6122_(r, g, b, a).m_7421_(u4, v4).m_7120_(light1, light2).m_5752_();
            }
        }
    }

    public float boundUV(float value, boolean upper) {
        if ((value %= 1.0f) == 0.0f) {
            return upper ? 1.0f : 0.0f;
        }
        return value < 0.0f ? value + 1.0f : value;
    }
}

