/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import sweetmagic.init.BlockInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileAetherLamplight;
import sweetmagic.init.tile.sm.TileAetherLanp;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.RenderUtil;

public class RenderAetherLamplight<T extends TileAetherLamplight>
extends RenderAbstractTile<T> {
    private static final Block LAMP = BlockInit.aether_lamplight_render;
    private static final Block SQUARE_L = BlockInit.magic_square_l_blank;
    private static final Block SQUARE_S = BlockInit.magic_square_l;

    public RenderAetherLamplight(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        float sin = (float)Math.sin((double)((float)gameTime + parTick) / 10.0);
        float fSin = sin * 50.0f;
        float f = ((float)gameTime + parTick) / 20.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        PoseStack pose = info.pose();
        MultiBufferSource buf = info.buf();
        int light = info.light();
        pose.m_85836_();
        pose.m_85837_(0.0, (double)sin * 0.067 + 0.2, 0.0);
        RenderUtil.renderBlock(info, RenderUtil.RenderColor.create(info), LAMP);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_(0.5, (double)sin * 0.067 + 0.2, 0.5);
        pose.m_252781_(Axis.f_252436_.m_252977_(angle));
        pose.m_85837_(-0.5, 0.0, -0.5);
        RenderUtil.RenderColor color2 = new RenderUtil.RenderColor((63.0f + fSin) / 255.0f, (184.0f + fSin) / 255.0f, (205.0f + fSin) / 255.0f, light, NO_OVERLAY);
        RenderUtil.renderBlock(info, color2, SQUARE_L);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_(0.5, (double)sin * 0.067 + 1.4, 0.5);
        pose.m_252781_(Axis.f_252436_.m_252977_(-angle * 1.1f));
        pose.m_85837_(-0.5, 0.0, -0.5);
        RenderUtil.RenderColor color3 = new RenderUtil.RenderColor((63.0f + sin * 49.0f) / 255.0f, (184.0f - sin * 71.0f) / 255.0f, 1.0f, light, NO_OVERLAY);
        RenderUtil.renderBlock(info, color3, SQUARE_S);
        pose.m_85849_();
        if (!((TileAetherLamplight)tile).isRangeView) {
            return;
        }
        Iterable<BlockPos> posList = ((TileAbstractSM)tile).getRangePosUnder(tile.m_58899_(), ((TileAetherLamplight)tile).range);
        Level world = tile.m_58904_();
        double posX = tile.m_58899_().m_123341_();
        double posY = tile.m_58899_().m_123342_();
        double posZ = tile.m_58899_().m_123343_();
        for (BlockPos pos : posList) {
            TileSMMagic magic;
            BlockEntity blockEntity = ((TileAbstractSM)tile).getTile(pos);
            if (!(blockEntity instanceof TileSMMagic) || !(magic = (TileSMMagic)blockEntity).getReceive() || magic instanceof TileAetherLamplight || magic instanceof TileAetherLanp) continue;
            VoxelShape voxel = world.m_8055_(pos).m_60812_((BlockGetter)world, pos);
            VertexConsumer con = buf.m_6299_(RenderType.m_173247_());
            this.drawShape(pose, con, voxel, -posX + (double)pos.m_123341_(), -posY + (double)pos.m_123342_() + 0.01, -posZ + (double)pos.m_123343_());
        }
    }

    private void drawShape(PoseStack pose, VertexConsumer con, VoxelShape voxel, double x, double y, double z) {
        Matrix4f mat4 = pose.m_85850_().m_252922_();
        Matrix3f mat3 = pose.m_85850_().m_252943_();
        voxel.m_83224_((x1, y1, z1, x2, y2, z2) -> {
            con.m_252986_(mat4, (float)(x1 + x), (float)(y1 + y), (float)(z1 + z)).m_85950_(1.0f, 0.14901961f, 0.19215687f, 1.0f).m_252939_(mat3, 5.0f, 5.0f, 5.0f).m_5752_();
            con.m_252986_(mat4, (float)(x2 + x), (float)(y2 + y), (float)(z2 + z)).m_85950_(1.0f, 0.14901961f, 0.19215687f, 1.0f).m_252939_(mat3, 5.0f, 5.0f, 5.0f).m_5752_();
        });
    }
}

