/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileAltarCreat;
import sweetmagic.util.RenderUtil;
import sweetmagic.util.WorldHelper;

public class RenderAltarCreat<T extends TileAltarCreat>
extends RenderAbstractTile<T> {
    private static final float size = 0.45f;
    private static final Block SQUARE = BlockInit.magic_square_s;

    public RenderAltarCreat(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        if (!((TileAltarCreat)tile).isHaveBlock || !((TileAltarCreat)tile).isRangeBlock) {
            if (!((TileAltarCreat)tile).isHaveBlock) {
                this.renderHaveBlock(tile, parTick, info);
            }
            if (!((TileAltarCreat)tile).isRangeBlock) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && z == 0 || ((TileAbstractSM)tile).getState(WorldHelper.offset(tile.m_58899_(), x, -1.0, z)).m_204336_(TagInit.AC_BLOCK)) continue;
                        this.renderRangeBlock(tile, parTick, info, x, z);
                    }
                }
            }
        } else if (((TileAltarCreat)tile).isCraft) {
            PoseStack pose = info.pose();
            int count = ((TileAltarCreat)tile).craftList.size() - 1;
            int nowTick = ((TileAltarCreat)tile).nowTick * (!((TileAltarCreat)tile).quickCraft ? 1 : 2);
            float posY = 1.0f + (float)nowTick * 0.0065f;
            int gameTime = ((TileAbstractSM)tile).getClientTime();
            float rotY = ((float)gameTime + parTick) / 90.0f;
            for (int i = 1; i < count + 1; ++i) {
                ItemStack stack = (ItemStack)((TileAltarCreat)tile).craftList.get(i);
                if (stack.m_41619_()) continue;
                pose.m_85836_();
                pose.m_252880_(0.5f, posY, 0.5f);
                pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 10.0f) * (double)0.15f + (double)0.2f, 0.0);
                Objects.requireNonNull(this);
                pose.m_252781_(Axis.f_252436_.m_252977_(rotY * 57.295776f + (float)(i * (360 / count)) + (float)nowTick * 6.75f));
                pose.m_85841_(0.45f, 0.45f, 0.45f);
                pose.m_252880_(1.0f - 0.0055f * (float)nowTick, 0.0f, 0.0f);
                info.itemRender(stack);
                pose.m_85849_();
            }
            float rot = gameTime % 360;
            pose.m_85836_();
            pose.m_252880_(0.5f, posY, 0.5f);
            pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) * 0.1f) * (double)0.15f + (double)0.2f, 0.0);
            pose.m_85841_(0.45f, 0.45f, 0.45f);
            pose.m_252781_(Axis.f_252436_.m_252977_(rot));
            info.itemRender((ItemStack)((TileAltarCreat)tile).craftList.get(0));
            pose.m_85849_();
            this.renderSquare((TileAltarCreat)tile, parTick, info);
        }
    }

    public void renderHaveBlock(T tile, float parTick, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.0, -0.95, 0.0);
        RenderUtil.renderTransBlock(pose, info.buf(), RenderUtil.RenderColor.create(info), ((TileAltarCreat)tile).getNeedBlock().m_49966_(), 0.6f);
        pose.m_85849_();
    }

    public void renderRangeBlock(T tile, float parTick, RenderUtil.RenderInfo info, int x, int z) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_((double)x, -0.97, (double)z);
        RenderUtil.renderTransBlock(pose, info.buf(), RenderUtil.RenderColor.create(info), ((TileAltarCreat)tile).getRangeBlock().m_49966_(), 0.55f);
        pose.m_85849_();
    }

    public void renderSquare(TileAltarCreat tile, float parTick, RenderUtil.RenderInfo info) {
        float maxSize = 1.0f;
        float addValue = 0.0125f;
        float size = Math.min(maxSize, 0.125f + (float)tile.nowTick * addValue);
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 1.0, 0.5);
        int gameTime = tile.getClientTime();
        pose.m_85841_(size, size, size);
        float f = ((float)gameTime + parTick) / -20.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_252781_(Axis.f_252436_.m_252977_(angle));
        pose.m_85837_(-0.5, 0.0, -0.5);
        RenderUtil.renderBlock(pose, info.buf(), new RenderUtil.RenderColor(0.28235295f, 1.0f, 1.0f, info.light(), info.overlay()), SQUARE);
        pose.m_85849_();
    }
}

