/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileAltarCreatStar;
import sweetmagic.util.RenderUtil;
import sweetmagic.util.WorldHelper;

public class RenderAltarCreatStar<T extends TileAltarCreatStar>
extends RenderAbstractTile<T> {
    private static final float size = 0.45f;
    private static final Block SQUARE = BlockInit.magic_square_l;
    private static final Block SQUARE_BLANK = BlockInit.magic_square_l_blank;

    public RenderAltarCreatStar(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        if (!((TileAltarCreatStar)tile).isHaveBlock || !((TileAltarCreatStar)tile).isRangeBlock) {
            if (!((TileAltarCreatStar)tile).isHaveBlock) {
                this.renderHaveBlock(tile, parTick, info);
            }
            if (!((TileAltarCreatStar)tile).isRangeBlock) {
                BlockPos pos = tile.m_58899_().m_7495_();
                List<BlockPos> dcPosList = Arrays.asList(pos.m_122012_(), pos.m_122019_(), pos.m_122029_(), pos.m_122024_());
                List<BlockPos> acPosList = Arrays.asList(pos.m_122013_(2), pos.m_122020_(2), pos.m_122030_(2), pos.m_122025_(2), WorldHelper.offset(pos, -1.0, 0.0, -1.0), WorldHelper.offset(pos, 1.0, 0.0, -1.0), WorldHelper.offset(pos, -1.0, 0.0, 1.0), WorldHelper.offset(pos, 1.0, 0.0, 1.0));
                Block dc = ((TileAltarCreatStar)tile).getRangeBlock();
                Block ac = ((TileAltarCreatStar)tile).getOverRangeBlock();
                dcPosList.forEach(p -> this.renderRangeBlock(tile, parTick, info, (BlockPos)p, TagInit.DC_BLOCK, dc));
                acPosList.forEach(p -> this.renderRangeBlock(tile, parTick, info, (BlockPos)p, TagInit.AC_BLOCK, ac));
            }
        } else if (((TileAltarCreatStar)tile).isCraft) {
            int count = ((TileAltarCreatStar)tile).craftList.size() - 1;
            int nowTick = ((TileAltarCreatStar)tile).nowTick * (!((TileAltarCreatStar)tile).quickCraft ? 1 : 2);
            float posY = 1.0f + (float)nowTick * 0.0065f;
            int gameTime = ((TileAbstractSM)tile).getClientTime();
            float rotY = ((float)gameTime + parTick) / 90.0f;
            PoseStack pose = info.pose();
            for (int i = 1; i < count + 1; ++i) {
                ItemStack stack = (ItemStack)((TileAltarCreatStar)tile).craftList.get(i);
                if (stack.m_41619_()) continue;
                pose.m_85836_();
                pose.m_252880_(0.5f, posY, 0.5f);
                pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 10.0f) * (double)0.15f + (double)0.2f, 0.0);
                Objects.requireNonNull(this);
                pose.m_252781_(Axis.f_252436_.m_252977_(rotY * 57.295776f + (float)(i * (360 / count)) + (float)nowTick * 6.75f));
                pose.m_85841_(0.45f, 0.45f, 0.45f);
                pose.m_252880_(1.0f - 0.0055f * (float)nowTick, 0.0f, 0.0f);
                info.itemRender(stack);
                pose.m_85849_();
            }
            ItemStack stack = (ItemStack)((TileAltarCreatStar)tile).craftList.get(0);
            float rot = gameTime % 360;
            pose.m_85836_();
            pose.m_252880_(0.5f, posY, 0.5f);
            pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) * 0.1f) * (double)0.15f + (double)0.2f, 0.0);
            pose.m_85841_(0.45f, 0.45f, 0.45f);
            pose.m_252781_(Axis.f_252436_.m_252977_(rot));
            info.itemRender(stack);
            pose.m_85849_();
            this.renderSquare(tile, parTick, info);
        }
    }

    public void renderHaveBlock(T tile, float parTick, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.0, -0.95, 0.0);
        RenderUtil.renderTransBlock(pose, info.buf(), RenderUtil.RenderColor.create(info), ((TileAltarCreatStar)tile).getNeedBlock().m_49966_(), 0.67f);
        pose.m_85849_();
    }

    public void renderRangeBlock(T tile, float parTick, RenderUtil.RenderInfo info, BlockPos pos, TagKey<Block> tag, Block crystal) {
        if (((TileAbstractSM)tile).getState(pos).m_204336_(TagInit.AC_BLOCK)) {
            return;
        }
        PoseStack pose = info.pose();
        pose.m_85836_();
        BlockPos p = tile.m_58899_();
        pose.m_85837_((double)(pos.m_123341_() - p.m_123341_()), -0.97, (double)(pos.m_123343_() - p.m_123343_()));
        RenderUtil.renderTransBlock(pose, info.buf(), RenderUtil.RenderColor.create(info), crystal.m_49966_(), 0.5f);
        pose.m_85849_();
    }

    public void renderSquare(T tile, float parTick, RenderUtil.RenderInfo info) {
        float maxSize = 1.5f;
        float addValue = 0.0125f;
        float size = Math.min(maxSize, 0.125f + (float)((TileAltarCreatStar)tile).nowTick * addValue);
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 1.35, 0.5);
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        pose.m_85841_(size, size, size);
        float f = ((float)gameTime + parTick) / -20.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_252781_(Axis.f_252436_.m_252977_(angle));
        pose.m_85837_(-0.5, 0.0, -0.5);
        RenderUtil.renderBlock(info, new RenderUtil.RenderColor(0.28235295f, 1.0f, 1.0f, info.light(), info.overlay()), SQUARE);
        pose.m_85849_();
        maxSize = 3.0f;
        addValue = 0.025f;
        size = Math.min(maxSize, 0.25f + (float)((TileAltarCreatStar)tile).nowTick * addValue);
        pose.m_85836_();
        pose.m_85837_(0.5, 0.15, 0.5);
        pose.m_85841_(size, size, size);
        pose.m_252781_(Axis.f_252436_.m_252977_(-angle));
        pose.m_85837_(-0.5, 0.0, -0.5);
        RenderUtil.renderBlock(info, new RenderUtil.RenderColor(0.28235295f, 1.0f, 1.0f, info.light(), info.overlay()), SQUARE_BLANK);
        pose.m_85849_();
    }
}

