/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import sweetmagic.init.BlockInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileCrystalPedal;
import sweetmagic.util.RenderUtil;

public class RenderCrystalPedal<T extends TileCrystalPedal>
extends RenderAbstractTile<T> {
    public static final ResourceLocation BEAM_LOCATION = new ResourceLocation("textures/entity/beacon_beam.png");

    public RenderCrystalPedal(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.875, 0.5);
        pose.m_85837_(0.0, Math.sin((double)((float)gameTime + parTick) * 0.1) * 0.05, 0.0);
        float rotY = ((float)gameTime + parTick) * 0.03f;
        Objects.requireNonNull(this);
        pose.m_252781_(Axis.f_252436_.m_252977_(rotY * 57.295776f));
        pose.m_85841_(2.0f, 2.0f, 2.0f);
        info.itemRenderNo(new ItemStack((ItemLike)BlockInit.spawn_stone_d));
        pose.m_85849_();
        float[] par6 = new float[]{1.0f, 1.0f, 1.0f};
        this.renderBeam(info.pose(), info.buf(), parTick, gameTime, 0, 1024, par6);
    }

    public void renderBeam(PoseStack pose, MultiBufferSource buf, float par1, long par3, int par4, int par5, float[] par6) {
        ResourceLocation tex = BEAM_LOCATION;
        float par2 = 1.0f;
        float par7 = 0.125f;
        float par8 = 0.125f;
        int i = par4 + par5;
        pose.m_85836_();
        pose.m_85837_(0.5, 0.0, 0.5);
        float f = (float)Math.floorMod(par3, 40) + par1;
        float f1 = par5 < 0 ? f : -f;
        float f2 = Mth.m_14187_((float)(f1 * 0.2f - (float)Mth.m_14143_((float)(f1 * 0.1f))));
        float f3 = par6[0];
        float f4 = par6[1];
        float f5 = par6[2];
        pose.m_85836_();
        pose.m_252781_(Axis.f_252436_.m_252977_(f * 2.25f - 45.0f));
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = -par7;
        float f12 = -par7;
        float f15 = -1.0f + f2;
        float f16 = (float)par5 * par2 * (0.5f / par7) + f15;
        this.renderPart(pose, buf.m_6299_(RenderType.m_110460_((ResourceLocation)tex, (boolean)false)), f3, f4, f5, 1.0f, par4, i, 0.0f, par7, par7, 0.0f, f9, 0.0f, 0.0f, f12, 0.0f, 1.0f, f16, f15);
        pose.m_85849_();
        f8 = f9 = -par8;
        f6 = f9;
        float f7 = f9;
        f15 = -1.0f + f2;
        f16 = (float)par5 * par2 + f15;
        this.renderPart(pose, buf.m_6299_(RenderType.m_110460_((ResourceLocation)tex, (boolean)true)), f3, f4, f5, 0.125f, par4, i, f6, f7, par8, f8, f9, par8, par8, par8, 0.0f, 1.0f, f16, f15);
        pose.m_85849_();
    }

    private void renderPart(PoseStack pose, VertexConsumer ver, float r, float g, float b, float alpha, int par1, int par2, float par3, float par4, float par5, float par6, float par7, float par8, float par9, float par10, float par11, float par12, float par13, float par14) {
        PoseStack.Pose poseLast = pose.m_85850_();
        Matrix4f ma4 = poseLast.m_252922_();
        Matrix3f ma3 = poseLast.m_252943_();
        this.renderQuad(ma4, ma3, ver, r, g, b, alpha, par1, par2, par3, par4, par5, par6, par11, par12, par13, par14);
        this.renderQuad(ma4, ma3, ver, r, g, b, alpha, par1, par2, par9, par10, par7, par8, par11, par12, par13, par14);
        this.renderQuad(ma4, ma3, ver, r, g, b, alpha, par1, par2, par5, par6, par9, par10, par11, par12, par13, par14);
        this.renderQuad(ma4, ma3, ver, r, g, b, alpha, par1, par2, par7, par8, par3, par4, par11, par12, par13, par14);
    }

    private void renderQuad(Matrix4f ma4, Matrix3f ma3, VertexConsumer ver, float r, float g, float b, float alpha, int par1, int par2, float par3, float par4, float par5, float par6, float par7, float par8, float par9, float par10) {
        this.addVertex(ma4, ma3, ver, r, g, b, alpha, par2, par3, par4, par8, par9);
        this.addVertex(ma4, ma3, ver, r, g, b, alpha, par1, par3, par4, par8, par10);
        this.addVertex(ma4, ma3, ver, r, g, b, alpha, par1, par5, par6, par7, par10);
        this.addVertex(ma4, ma3, ver, r, g, b, alpha, par2, par5, par6, par7, par9);
    }

    private void addVertex(Matrix4f ma4, Matrix3f ma3, VertexConsumer ver, float r, float g, float b, float alpha, int par1, float par2, float par3, float par4, float par5) {
        ver.m_252986_(ma4, par2, (float)par1, par3).m_85950_(r, g, b, alpha).m_7421_(par4, par5).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(ma3, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public boolean shouldRenderOffScreen(T tile) {
        return true;
    }

    @Override
    public int m_142163_() {
        return 256;
    }

    public boolean shouldRender(T tile, Vec3 vec) {
        return Vec3.m_82512_((Vec3i)tile.m_58899_()).m_82542_(1.0, 0.0, 1.0).m_82509_((Position)vec.m_82542_(1.0, 0.0, 1.0), (double)this.m_142163_());
    }
}

