/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import sweetmagic.init.block.sm.IrisCreation;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileIrisCreation;
import sweetmagic.util.RenderUtil;

public class RenderIrisCreation<T extends TileIrisCreation>
extends RenderAbstractTile<T> {
    public RenderIrisCreation(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        if (!((TileIrisCreation)tile).isCraft) {
            return;
        }
        PoseStack pose = info.pose();
        boolean under = (Boolean)((TileAbstractSM)tile).getState(tile.m_58899_()).m_61143_((Property)IrisCreation.UNDER);
        int ticlTime = ((TileIrisCreation)tile).clientTime;
        int craftTime = ((TileIrisCreation)tile).craftTime;
        ItemStack stack = ((TileIrisCreation)tile).craftList.get(0);
        float size = 0.3f;
        pose.m_85836_();
        pose.m_85837_(0.5, under ? 0.75 : 0.075, 0.5);
        pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_((float)ticlTime * 5.0f));
        pose.m_85841_(size, size, size);
        info.itemRenderNo(stack);
        pose.m_85849_();
        float rotY = (float)ticlTime / 90.0f;
        int maxSize = ((TileIrisCreation)tile).craftList.size();
        float progress = 1.0f - (float)craftTime / (float)((TileIrisCreation)tile).maxCraftTime;
        for (int i = 1; i < maxSize; ++i) {
            stack = ((TileIrisCreation)tile).craftList.get(i);
            pose.m_85836_();
            pose.m_85837_(0.5, under ? 0.75 : 0.075, 0.5);
            pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            Objects.requireNonNull(this);
            pose.m_252781_(Axis.f_252403_.m_252977_(rotY * 57.295776f + (float)(i * (360 / (maxSize - 1))) + (float)ticlTime * 6.75f));
            pose.m_85841_(size, size, size);
            pose.m_252880_(0.85f * progress, 0.0f, 0.0f);
            info.itemRenderNo(stack);
            pose.m_85849_();
        }
    }
}

