/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Quaternionf;
import sweetmagic.init.BlockInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMagiaChest;
import sweetmagic.util.RenderUtil;

public class RenderMagiaChest<T extends TileMagiaChest>
extends RenderAbstractTile<T> {
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private static final ItemStack crystal = new ItemStack((ItemLike)BlockInit.crystal_core);
    private static final ItemStack side0 = new ItemStack((ItemLike)BlockInit.magia_chest_side0);
    private static final ItemStack side1 = new ItemStack((ItemLike)BlockInit.magia_chest_side1);

    public RenderMagiaChest(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        float f1 = ((float)gameTime + parTick) * 3.0f;
        float f = ((float)gameTime + parTick) / 8.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        double addY = Math.sin((double)((float)gameTime + parTick) * 0.1) / 10.0;
        PoseStack pose = info.pose();
        pose.m_85836_();
        RenderUtil.renderBlock(pose, info.buf(), RenderUtil.RenderColor.create(info), BlockInit.magia_chest);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.75 + addY, 0.5);
        pose.m_252781_(Axis.f_252436_.m_252977_(f1));
        pose.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        pose.m_252781_(Axis.f_252436_.m_252977_(angle * 0.5f));
        info.itemRender(crystal);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.75 + addY, 0.5);
        pose.m_85841_(1.1f, 1.1f, 1.1f);
        pose.m_252781_(Axis.f_252529_.m_252977_(45.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_(f1));
        pose.m_252781_(Axis.f_252436_.m_252977_(angle));
        info.itemRender(side0);
        pose.m_85849_();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.75 + addY, 0.5);
        pose.m_85841_(1.1f, 1.1f, 1.1f);
        pose.m_252781_(Axis.f_252529_.m_252977_(45.0f));
        pose.m_252781_(Axis.f_252403_.m_252977_(f1));
        pose.m_252781_(Axis.f_252436_.m_252977_(-angle));
        info.itemRender(side1);
        pose.m_85849_();
        ItemStack stack = ((TileMagiaChest)tile).getTargetBlock();
        if (!stack.m_41619_()) {
            pose.m_85836_();
            pose.m_85837_(0.5, 0.75 + addY, 0.5);
            pose.m_85841_(0.67f, 0.67f, 0.67f);
            pose.m_252781_(Axis.f_252436_.m_252977_(-f1));
            pose.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
            pose.m_252781_(Axis.f_252436_.m_252977_(-angle * 0.2f));
            info.itemRender(stack);
            pose.m_85849_();
        }
    }

    @Override
    public int m_142163_() {
        return 64;
    }
}

