/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import sweetmagic.init.BlockInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMagiaRewrite;
import sweetmagic.util.RenderUtil;

public class RenderMagiaRewrite<T extends TileMagiaRewrite>
extends RenderAbstractTile<T> {
    private static final ItemStack BOT = new ItemStack((ItemLike)BlockInit.magia_rewrite_bot);
    private static final ItemStack TOP = new ItemStack((ItemLike)BlockInit.magia_rewrite_top);
    private static final BlockState MAIN = BlockInit.magia_rewrite.m_49966_();

    public RenderMagiaRewrite(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, PoseStack pose, MultiBufferSource buf, int light, int overlayLight) {
        if (tile.m_58904_() == null || ((TileAbstractSM)tile).isAir()) {
            return;
        }
        RenderUtil.RenderInfo info = new RenderUtil.RenderInfo(this.iRender, light, OverlayTexture.f_118083_, pose, buf, tile.m_58904_());
        this.renderModelItem(tile, BOT, 0.0f, parTick, info, false);
        this.renderModelItem(tile, TOP, 0.0125f, parTick, info, true);
        this.renderModelMain(tile, parTick, info);
        this.renderItem(tile, parTick, info);
    }

    public void renderModelItem(T tile, ItemStack stack, float y, float parTick, RenderUtil.RenderInfo info, boolean isReverce) {
        boolean isCraft = ((TileMagiaRewrite)tile).isCraft;
        float addY = 0.0f;
        float addAngle = 0.0f;
        if (isCraft) {
            int craftTick = ((TileMagiaRewrite)tile).craftTick;
            float rate = 1.0f;
            addY = isReverce ? Math.min((float)craftTick * 0.00375f, 0.3f) : Math.min((float)craftTick * 0.00125f, 0.1f);
            rate += Math.min((float)craftTick * 0.03f, 5.5f);
            if (((TileMagiaRewrite)tile).craftTime > 25) {
                int time = 300 - craftTick;
                if (((TileMagiaRewrite)tile).craftTime >= 27) {
                    addY = isReverce ? Math.max((float)time * 0.01f, 0.0f) : Math.max((float)time * 0.0033333f, 0.0f);
                }
            }
            addAngle += (float)craftTick * rate;
        }
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.5 + (double)y + (double)addY, 0.5);
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 10.0f) * 0.05, 0.0);
        pose.m_85841_(1.0f, 1.0f, 1.0f);
        float f = ((float)gameTime + parTick + addAngle) / 40.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f * (float)(isReverce ? -1 : 1);
        pose.m_252781_(Axis.f_252436_.m_252977_(angle));
        info.itemRender(stack);
        pose.m_85849_();
    }

    public void renderModelMain(T tile, float parTick, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.0, 0.0, 0.0);
        RenderUtil.renderBlock(tile.m_58904_(), tile.m_58899_(), MAIN, this.bRender, pose, info.buf(), info.overlay());
        pose.m_85849_();
    }

    public void renderItem(T tile, float parTick, RenderUtil.RenderInfo info) {
        boolean isCraft = ((TileMagiaRewrite)tile).isCraft;
        ItemStack stack = ((TileMagiaRewrite)tile).getInputItem().m_41777_();
        if (stack.m_41619_() && (stack = ((TileMagiaRewrite)tile).outStack).m_41619_()) {
            stack = ((TileMagiaRewrite)tile).getOutItem();
        }
        if (stack.m_41619_() && !isCraft) {
            return;
        }
        float addY = 0.0f;
        if (isCraft) {
            stack = ((TileMagiaRewrite)tile).outStack;
            int craftTick = ((TileMagiaRewrite)tile).craftTick;
            addY = Math.min((float)craftTick * 0.00625f, 0.5f);
            if (((TileMagiaRewrite)tile).craftTime >= 26) {
                int time = 300 - craftTick;
                addY = Math.max((float)time * 0.0125f, 0.0f);
            }
        }
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.55 + (double)addY, 0.5);
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 15.0f) * 0.025, 0.0);
        pose.m_85841_(0.25f, 0.25f, 0.25f);
        float f = ((float)gameTime + parTick) / 40.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_252781_(Axis.f_252436_.m_252977_(angle));
        info.itemRender(stack);
        pose.m_85849_();
    }
}

