/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileParallelInterfere;
import sweetmagic.util.RenderUtil;

public class RenderParallelInterfere<T extends TileParallelInterfere>
extends RenderAbstractTile<T> {
    private static final ResourceLocation MAGIC_BOOK = SweetMagicCore.getSRC("textures/entity/magicbook.png");
    private static final ItemStack SQUARE = new ItemStack((ItemLike)BlockInit.magic_square_h);
    private final BookModel bookModel;
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)MAGIC_BOOK);

    public RenderParallelInterfere(BlockEntityRendererProvider.Context con) {
        super(con);
        this.bookModel = new BookModel(con.m_173582_(ModelLayers.f_171271_));
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        this.renderBook(tile, parTick, info);
        this.renderSquare(tile, parTick, info);
    }

    public void renderBook(T tile, float parTick, RenderUtil.RenderInfo info) {
        float f1;
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.85, 0.5);
        float f = (float)((TileParallelInterfere)tile).time + parTick;
        pose.m_85837_(0.0, (double)(0.1f + Mth.m_14031_((float)(f * 0.1f)) * 0.01f), 0.0);
        for (f1 = ((TileParallelInterfere)tile).rot - ((TileParallelInterfere)tile).oRot; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        float f2 = ((TileParallelInterfere)tile).oRot + f1 * parTick;
        pose.m_252781_(Axis.f_252436_.m_252961_(-f2));
        pose.m_252781_(Axis.f_252403_.m_252977_(80.0f));
        float f3 = Mth.m_14179_((float)parTick, (float)((TileParallelInterfere)tile).oFlip, (float)((TileParallelInterfere)tile).flip);
        float f4 = Mth.m_14187_((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = Mth.m_14187_((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = Mth.m_14179_((float)parTick, (float)((TileParallelInterfere)tile).oOpen, (float)((TileParallelInterfere)tile).open);
        this.bookModel.m_102292_(f, Mth.m_14036_((float)f4, (float)0.0f, (float)1.0f), Mth.m_14036_((float)f5, (float)0.0f, (float)1.0f), f6);
        VertexConsumer vert = info.buf().m_6299_(RENDER_TYPE).m_85950_(0.0f, 0.0f, 0.0f, 1.0f);
        this.bookModel.m_102316_(pose, vert, info.light(), info.overlay(), 1.0f, 1.0f, 1.0f, 1.0f);
        pose.m_85849_();
    }

    public void renderSquare(T tile, float parTick, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 1.35, 0.5);
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        pose.m_85837_(0.0, Math.sin((double)((float)gameTime + parTick) / 10.0) * 0.025, 0.0);
        float size = 2.0f;
        pose.m_85841_(size, size, size);
        float f = ((float)gameTime + parTick) / -20.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_252781_(Axis.f_252436_.m_252977_(angle));
        info.itemRender(SQUARE);
        pose.m_85849_();
    }
}

