/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TilePedalCreate;
import sweetmagic.util.RenderUtil;

public class RenderPedalCreate<T extends TilePedalCreate>
extends RenderAbstractTile<T> {
    private static final float size = 0.45f;

    public RenderPedalCreate(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        if (!((TilePedalCreate)tile).isHaveBlock) {
            pose.m_85836_();
            pose.m_85837_(0.0, -0.95, 0.0);
            RenderUtil.renderTransBlock(pose, info.buf(), RenderUtil.RenderColor.create(info), ((TilePedalCreate)tile).getNeedBlock().m_49966_(), 0.55f);
            pose.m_85849_();
        } else if (((TilePedalCreate)tile).isCraft) {
            int count = ((TilePedalCreate)tile).craftList.size() - 1;
            int nowTick = ((TilePedalCreate)tile).nowTick * (!((TilePedalCreate)tile).quickCraft ? 1 : 2);
            float posY = 1.0f + (float)nowTick * 0.0065f;
            int gameTime = ((TileAbstractSM)tile).getClientTime();
            float rotY = ((float)gameTime + parTick) / 90.0f;
            for (int i = 1; i < count + 1; ++i) {
                ItemStack stack = ((TilePedalCreate)tile).craftList.get(i);
                if (stack.m_41619_()) continue;
                pose.m_85836_();
                pose.m_252880_(0.5f, posY, 0.5f);
                pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 10.0f) * (double)0.15f + (double)0.2f, 0.0);
                Objects.requireNonNull(this);
                pose.m_252781_(Axis.f_252436_.m_252977_(rotY * 57.295776f + (float)(i * (360 / count)) + (float)nowTick * 6.75f));
                pose.m_85841_(0.45f, 0.45f, 0.45f);
                pose.m_252880_(1.0f - 0.0055f * (float)nowTick, 0.0f, 0.0f);
                info.itemRenderNo(stack);
                pose.m_85849_();
            }
            ItemStack stack = ((TilePedalCreate)tile).craftList.get(0);
            float rot = gameTime % 360;
            pose.m_85836_();
            pose.m_252880_(0.5f, posY, 0.5f);
            pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) * 0.1f) * (double)0.15f + (double)0.2f, 0.0);
            pose.m_85841_(0.45f, 0.45f, 0.45f);
            pose.m_252781_(Axis.f_252436_.m_252977_(rot));
            info.itemRenderNo(stack);
            pose.m_85849_();
        }
    }
}

