/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import sweetmagic.init.entity.monster.boss.BraveSkeleton;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;

public class BraveSkeletonLayer<T extends BraveSkeleton, M extends HumanoidModel<T>>
extends AbstractEntityLayer<T, M> {
    private static final ItemStack SWORD = new ItemStack((ItemLike)Items.f_42388_);
    private static final ItemStack BOW = new ItemStack((ItemLike)Items.f_42411_);

    public BraveSkeletonLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity) {
        ItemStack tool1 = ((BraveSkeleton)entity).getArrow() ? BOW : SWORD;
        ItemStack tool2 = ((BraveSkeleton)entity).getArrow() ? SWORD : BOW;
        this.renderItem(entity, pose, buf, light, tool1, true);
        this.renderItem(entity, pose, buf, light, tool2, false);
    }

    protected void renderItem(T entity, PoseStack pose, MultiBufferSource buf, int light, ItemStack stack, boolean isHand) {
        pose.m_85836_();
        boolean isSword = stack.m_150930_(Items.f_42388_);
        if (isSword) {
            pose.m_85841_(1.25f, 1.75f, 1.25f);
        }
        if (isHand) {
            double addX = isSword ? -0.05 : 0.0;
            double addZ = isSword ? 0.125 : 0.0;
            ((HumanoidModel)this.m_117386_()).m_6002_(HumanoidArm.RIGHT, pose);
            pose.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            pose.m_85837_(0.0 + addX, 0.15, -0.65 + addZ);
        } else {
            double addZ;
            double addY = isSword ? -0.5 : 0.0;
            double d = addZ = isSword ? 0.15 : 0.0;
            if (isSword) {
                pose.m_252781_(Axis.f_252403_.m_252977_(-30.0f));
                pose.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            } else {
                pose.m_252781_(Axis.f_252529_.m_252977_(10.0f));
                pose.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            }
            pose.m_85837_(0.1, 0.5 + addY, 0.0 + addZ);
        }
        this.renderItem(entity, stack, pose, buf, light);
        pose.m_85849_();
    }
}

