/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.monster.boss.DemonsBelial;
import sweetmagic.init.render.entity.model.DemonsBelialModel;

public class DemonsBelialHeartLayer<T extends DemonsBelial, M extends DemonsBelialModel<T>>
extends RenderLayer<T, M> {
    private final ResourceLocation tex;
    private final ResourceLocation mainTex;
    private final AlphaFunction<T> alpha;
    private final DrawSelector<T, M> draw;
    private final DrawSelector<T, M> main;

    public DemonsBelialHeartLayer(RenderLayerParent<T, M> render, ResourceLocation tex, ResourceLocation mainTex, AlphaFunction<T> alpha, DrawSelector<T, M> draw, DrawSelector<T, M> main) {
        super(render);
        this.tex = tex;
        this.mainTex = mainTex;
        this.alpha = alpha;
        this.draw = draw;
        this.main = main;
    }

    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity, float swing, float swingAmount, float parTick, float ageTick, float headYaw, float headPitch) {
        this.renderModel(pose, buf, light, entity, parTick, ageTick);
        this.renderHeart(pose, buf, light, entity, parTick, ageTick);
    }

    public void renderModel(PoseStack pose, MultiBufferSource buf, int light, T entity, float parTick, float ageTick) {
        List<ModelPart> list = this.main.getPartsToDraw((DemonsBelialModel)this.m_117386_());
        list.forEach(p -> {
            p.f_104207_ = true;
        });
        if (entity.m_6084_()) {
            return;
        }
        pose.m_85836_();
        ((DemonsBelialModel)this.m_117386_()).m_142109_().m_171331_().forEach(part -> {
            part.f_233556_ = true;
        });
        list.forEach(p -> {
            p.f_233556_ = false;
        });
        VertexConsumer vert = buf.m_6299_(RenderType.m_234338_((ResourceLocation)this.mainTex));
        float maxDeathTime = ((DemonsBelial)entity).getMaxDeathTime();
        ((DemonsBelialModel)this.m_117386_()).m_7695_(pose, vert, light, LivingEntityRenderer.m_115338_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, (maxDeathTime - (float)((DemonsBelial)entity).f_20919_) / maxDeathTime);
        ModelPart part2 = ((DemonsBelialModel)this.m_117386_()).m_142109_();
        part2.f_104207_ = true;
        list.forEach(p -> {
            p.f_104207_ = false;
        });
        part2.m_171331_().forEach(p -> {
            p.f_233556_ = false;
        });
        pose.m_85849_();
    }

    public void renderHeart(PoseStack pose, MultiBufferSource buf, int light, T entity, float parTick, float ageTick) {
        if (((AbstractSMBoss)entity).m_20145_()) {
            return;
        }
        pose.m_85836_();
        pose.m_85841_(0.67f, 0.67f, 0.67f);
        pose.m_252880_(-0.025f, 0.0f, -0.14f);
        List<ModelPart> list = this.draw.getPartsToDraw((DemonsBelialModel)this.m_117386_());
        ((DemonsBelialModel)this.m_117386_()).m_142109_().m_171331_().forEach(part -> {
            part.f_233556_ = true;
        });
        list.forEach(part -> {
            part.f_233556_ = false;
        });
        VertexConsumer vert = buf.m_6299_(RenderType.m_234338_((ResourceLocation)this.tex));
        ((DemonsBelialModel)this.m_117386_()).m_7695_(pose, vert, light, LivingEntityRenderer.m_115338_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, this.alpha.apply(entity, parTick, ageTick));
        ((DemonsBelialModel)this.m_117386_()).m_142109_().m_171331_().forEach(part -> {
            part.f_233556_ = false;
        });
        pose.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface AlphaFunction<T> {
        public float apply(T var1, float var2, float var3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface DrawSelector<T, M> {
        public List<ModelPart> getPartsToDraw(M var1);
    }
}

