/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.monster.boss.ElshariaCurious;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;
import sweetmagic.init.render.entity.model.HolyModel;
import sweetmagic.util.RenderUtil;

public class ElshariaCuriousLayer<T extends ElshariaCurious, M extends EntityModel<T>>
extends AbstractEntityLayer<T, M> {
    private static final Block RING = BlockInit.kogen;
    private static final ItemStack STACK = new ItemStack((ItemLike)ItemInit.angel_wing_old);

    public ElshariaCuriousLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
        this.setModel(new HolyModel(this.getModel(con, HolyModel.LAYER)));
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity, float swing, float swingAmount, float parTick, float ageTick, float netHeadYaw, float headPitch) {
        this.renderAngelWingBig(entity, pose, buf, light, false);
        this.renderAngelWingBig(entity, pose, buf, light, true);
        this.renderAngelRing(entity, pose, buf, light);
        this.renderShadow((AbstractSMBoss)entity, pose, buf, swing, swingAmount, parTick, light, ageTick, netHeadYaw, headPitch, 0.5f, 0.0f, 1.15f);
    }

    public void renderAngelWingBig(T entity, PoseStack pose, MultiBufferSource buf, int light, boolean isReverse) {
        float scale = ((ElshariaCurious)entity).getCharge() ? 2.5f : 1.35f;
        float reverseRate = isReverse ? -1.0f : 1.0f;
        pose.m_85836_();
        pose.m_252880_(-0.15f * reverseRate, -0.15f, 0.15f);
        pose.m_252781_(Axis.f_252392_.m_252977_((60.0f + 20.0f * Mth.m_14031_((float)((float)((ElshariaCurious)entity).f_19797_ * 0.1f))) * reverseRate));
        pose.m_85841_(scale, -scale, scale);
        this.render.m_269530_(entity, STACK, ItemDisplayContext.FIXED, false, pose, buf, light);
        pose.m_85849_();
    }

    public void renderAngelRing(T entity, PoseStack pose, MultiBufferSource buf, int light) {
        float scale = ((ElshariaCurious)entity).getCharge() ? 2.0f : 1.15f;
        pose.m_85836_();
        pose.m_85841_(scale, scale, scale);
        pose.m_252880_(-0.5f, -0.5f, -0.5f);
        RenderUtil.renderBlock(pose, buf, new RenderUtil.RenderColor(1.0f, 1.0f, 1.0f, light, OverlayTexture.f_118083_), RING);
        pose.m_85849_();
    }
}

