/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.monster.boss.IgnisKnight;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;
import sweetmagic.init.render.entity.model.IgnisModel;
import sweetmagic.util.RenderUtil;

public class IgnisKnightLayer<T extends IgnisKnight, M extends IgnisModel<T>>
extends AbstractEntityLayer<T, M> {
    private static final ItemStack ARMOR = new ItemStack((ItemLike)ItemInit.ignis_armor);
    private static final ItemStack HAMMER = new ItemStack((ItemLike)ItemInit.cosmic_ignis_hammer);
    private static final Block SQUARE_BLOCK = BlockInit.magic_square_l_blank;
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/entity/ignis_knight.png");

    public IgnisKnightLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
        this.setModel(new IgnisModel(this.getModel(con, IgnisModel.LAYER)));
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity, float swing, float swingAmount, float parTick, float ageTick, float headYaw, float headPitch) {
        this.renderShadow((AbstractSMBoss)entity, pose, buf, swing, swingAmount, parTick, light, ageTick, headYaw, headPitch, 0.5f, -0.65f, 1.15f);
        this.renderArmWithItem(entity, pose, buf, light, parTick);
    }

    protected void renderArmWithItem(T entity, PoseStack pose, MultiBufferSource buf, int light, float parTick) {
        int size;
        int attackType = ((IgnisKnight)entity).getAttackType();
        int gameTime = ((IgnisKnight)entity).f_19797_;
        if (entity.m_20096_() && attackType == 2 && ((IgnisKnight)entity).getSwing()) {
            pose.m_85836_();
            pose.m_85837_(0.0, Math.sin(((float)gameTime + parTick) / 15.0f) * 0.02, 0.0);
            pose.m_85841_(10.0f, 10.0f, 10.0f);
            float angle = ((float)gameTime + parTick) / 20.0f * 57.295776f;
            pose.m_252781_(Axis.f_252436_.m_252977_(angle));
            pose.m_85837_(-0.5, 0.14, -0.5);
            RenderUtil.RenderColor color = new RenderUtil.RenderColor(0.44313726f, 0.8745098f, 1.0f, light, OverlayTexture.f_118083_);
            RenderUtil.renderBlock(pose, buf, color, SQUARE_BLOCK);
            pose.m_85849_();
        }
        int n = size = ((AbstractSMBoss)entity).getLectern() ? ((IgnisKnight)entity).getArmor() : ((AbstractSMBoss)entity).getHealthArmorProgress(8);
        if (size > 0) {
            float pi = 57.295776f;
            float rotY = ((float)gameTime + parTick) / 90.0f;
            float scale = 1.15f;
            for (int i = 0; i < size; ++i) {
                pose.m_85836_();
                pose.m_252880_(0.0f, 0.35f, 0.0f);
                pose.m_252781_(Axis.f_252436_.m_252977_(rotY * pi + (float)(i * (360 / size)) + (float)gameTime * 10.5f));
                pose.m_85841_(scale, scale, scale);
                pose.m_252880_(1.4945f, 0.0f, 0.0f);
                this.renderItemFix(entity, ARMOR, pose, buf, light);
                pose.m_85849_();
            }
        }
        IgnisModel model = (IgnisModel)this.m_117386_();
        model.translateAndRotate(model.getArm(true), pose);
        boolean hasTag = HAMMER.m_41782_();
        if (attackType == 2 && !hasTag) {
            HAMMER.m_41663_(EnchantInit.aethercharm, 0);
        } else if (hasTag) {
            HAMMER.m_41751_(new CompoundTag());
        }
        pose.m_85836_();
        pose.m_252781_(Axis.f_252529_.m_252977_(225.0f));
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        pose.m_85837_(0.0, -0.2, -0.5);
        pose.m_252781_(Axis.f_252403_.m_252977_(230.0f));
        pose.m_85837_(0.1, 0.2, 0.05);
        this.renderItem(entity, HAMMER, pose, buf, light);
        pose.m_85849_();
    }

    @Override
    protected ResourceLocation getTex() {
        return TEX;
    }
}

