/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.monster.boss.QueenFrost;
import sweetmagic.init.render.entity.layer.AbstractEntityLayer;
import sweetmagic.init.render.entity.model.QuenModel;
import sweetmagic.util.RenderUtil;

public class QueenFrostLayer<T extends QueenFrost, M extends EntityModel<T>>
extends AbstractEntityLayer<T, M> {
    private ItemStack stack = ItemStack.f_41583_;
    private static final Block SQUARE_BLANK = BlockInit.magic_square_l_blank;
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/entity/queenfrost.png");

    public QueenFrostLayer(RenderLayerParent<T, M> layer, EntityRendererProvider.Context con) {
        super(layer, con);
        this.setModel(new QuenModel(this.getModel(con, QuenModel.LAYER)));
    }

    @Override
    public void render(PoseStack pose, MultiBufferSource buf, int light, T entity, float swing, float swingAmount, float parTick, float ageTick, float netHeadYaw, float headPitch) {
        int size = ((AbstractSMBoss)entity).getLectern() ? ((QueenFrost)entity).getArmor() : ((AbstractSMBoss)entity).getHealthArmorProgress(8);
        float pi = 57.295776f;
        long gameTime = ((QueenFrost)entity).f_19797_;
        float rotY = ((float)gameTime + parTick) / 90.0f;
        float scale = 1.15f;
        if (this.stack.m_41619_()) {
            this.stack = new ItemStack((ItemLike)Blocks.f_50354_);
        }
        for (int i = 0; i < size; ++i) {
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.35f, 0.0f);
            pose.m_252781_(Axis.f_252436_.m_252977_(rotY * pi + (float)(i * (360 / size)) + (float)gameTime * 10.5f));
            pose.m_85841_(scale, scale, scale);
            pose.m_252880_(1.4945f, 0.0f, 0.0f);
            this.renderItemFix(entity, this.stack, pose, buf, light);
            pose.m_85849_();
        }
        float rgb = Math.min((float)((QueenFrost)entity).f_19797_ / 40.0f, 1.0f) * 0.5f;
        this.renderShadow((AbstractSMBoss)entity, pose, buf, swing, swingAmount, parTick, light, ageTick, netHeadYaw, headPitch, rgb, 0.0f, 1.15f);
        if (((QueenFrost)entity).isLaser()) {
            scale = 2.0f;
            pose.m_85836_();
            pose.m_85841_(scale, scale, scale);
            pose.m_85837_(0.0, 0.1, -0.25);
            float f = ((float)gameTime + parTick) / -20.0f;
            Objects.requireNonNull(this);
            float angle = f * 57.295776f;
            pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            pose.m_252781_(Axis.f_252436_.m_252977_(-angle));
            pose.m_85837_(-0.5, 0.0, -0.5);
            RenderUtil.RenderInfo info = new RenderUtil.RenderInfo(null, light, OverlayTexture.f_118083_, pose, buf, entity.m_9236_());
            RenderUtil.renderBlock(info, new RenderUtil.RenderColor(0.28235295f, 1.0f, 1.0f, info.light(), info.overlay()), SQUARE_BLANK);
            pose.m_85849_();
        }
    }

    @Override
    protected ResourceLocation getTex() {
        return TEX;
    }
}

