/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import org.joml.Vector3f;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.AnimationInit;
import sweetmagic.init.entity.monster.boss.DemonsBelial;

public class DemonsBelialModel<T extends DemonsBelial>
extends HierarchicalModel<T> {
    private static final Vector3f ANIMA_VEC = new Vector3f();
    public static final ModelLayerLocation LAYER = DemonsBelialModel.getLayer("demonsbelial");
    private final ModelPart root;
    protected final ModelPart bone;
    public final ModelPart body;
    public final ModelPart head;
    protected final ModelPart rightTendril;
    protected final ModelPart leftTendril;
    protected final ModelPart leftLeg;
    public final ModelPart leftArm;
    protected final ModelPart leftRibcage;
    public final ModelPart rightArm;
    protected final ModelPart rightLeg;
    protected final ModelPart rightRibcage;
    private final List<ModelPart> heartList;
    private final List<ModelPart> allList;

    public DemonsBelialModel(ModelPart part) {
        super(RenderType::m_110458_);
        this.root = part;
        this.bone = part.m_171324_("bone");
        this.body = this.bone.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.rightLeg = this.bone.m_171324_("right_leg");
        this.leftLeg = this.bone.m_171324_("left_leg");
        this.rightArm = this.body.m_171324_("right_arm");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightTendril = this.head.m_171324_("right_tendril");
        this.leftTendril = this.head.m_171324_("left_tendril");
        this.rightRibcage = this.body.m_171324_("right_ribcage");
        this.leftRibcage = this.body.m_171324_("left_ribcage");
        this.heartList = ImmutableList.of((Object)this.body);
        this.allList = ImmutableList.of((Object)this.body, (Object)this.head, (Object)this.rightTendril, (Object)this.leftTendril, (Object)this.leftLeg, (Object)this.leftArm, (Object)this.leftRibcage, (Object)this.rightArm, (Object)this.rightLeg, (Object)this.rightRibcage);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        PartDefinition bone = part.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-9.0f, -13.0f, -4.0f, 18.0f, 21.0f, 11.0f), PartPose.m_171419_((float)0.0f, (float)-21.0f, (float)0.0f));
        body.m_171599_("right_ribcage", CubeListBuilder.m_171558_().m_171514_(90, 11).m_171481_(-2.0f, -11.0f, -0.1f, 9.0f, 21.0f, 0.0f), PartPose.m_171419_((float)-7.0f, (float)-2.0f, (float)-4.0f));
        body.m_171599_("left_ribcage", CubeListBuilder.m_171558_().m_171514_(90, 11).m_171480_().m_171481_(-7.0f, -11.0f, -0.1f, 9.0f, 21.0f, 0.0f).m_171555_(false), PartPose.m_171419_((float)7.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-8.0f, -16.0f, -5.0f, 16.0f, 16.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)0.0f));
        head.m_171599_("right_tendril", CubeListBuilder.m_171558_().m_171514_(52, 32).m_171481_(-16.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f), PartPose.m_171419_((float)-4.0f, (float)-16.0f, (float)0.0f));
        head.m_171599_("left_tendril", CubeListBuilder.m_171558_().m_171514_(58, 0).m_171481_(0.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f), PartPose.m_171419_((float)4.0f, (float)-16.0f, (float)0.0f));
        body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(44, 50).m_171481_(-4.0f, 0.0f, -4.0f, 8.0f, 28.0f, 8.0f), PartPose.m_171419_((float)-13.0f, (float)-13.0f, (float)1.0f));
        body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 58).m_171481_(-4.0f, 0.0f, -4.0f, 8.0f, 28.0f, 8.0f), PartPose.m_171419_((float)13.0f, (float)-13.0f, (float)1.0f));
        bone.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(76, 48).m_171481_(-3.1f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.m_171419_((float)-5.9f, (float)-13.0f, (float)0.0f));
        bone.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(76, 76).m_171481_(-2.9f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.m_171419_((float)5.9f, (float)-13.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }

    public void setupAnim(T entity, float swing, float swingAmount, float ageTick, float headYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.animateHeadLookTarget(headYaw, headPitch);
        this.animateIdlePose(ageTick);
        if (!((DemonsBelial)entity).getNoMove()) {
            this.animateWalk(swing, swingAmount);
        }
        this.rightTendril.f_104205_ = 0.375f;
        this.leftTendril.f_104205_ = -0.375f;
        this.m_233381_(((DemonsBelial)entity).defalutAttackAnim, AnimationInit.BELIAL_ATTACK, ageTick);
        this.m_233381_(((DemonsBelial)entity).landingAnim, AnimationInit.BELIAL_LANDING, ageTick);
        this.m_233381_(((DemonsBelial)entity).laserAnim, AnimationInit.BELIAL_LASER, ageTick);
        this.m_233381_(((DemonsBelial)entity).swingAnim, AnimationInit.BELIAL_SWING, ageTick);
        this.m_233381_(((DemonsBelial)entity).meteorAnim, AnimationInit.BELIAL_METEOR, ageTick);
        this.m_233381_(((DemonsBelial)entity).downAnim, AnimationInit.BELIAL_DOWN, ageTick);
    }

    private void animateHeadLookTarget(float headYaw, float headPitch) {
        this.head.f_104203_ = headPitch * (float)Math.PI / 180.0f;
        this.head.f_104204_ = headYaw * (float)Math.PI / 180.0f;
    }

    private void animateIdlePose(float ageTick) {
        float f = ageTick * 0.1f;
        float f1 = Mth.m_14089_((float)f);
        float f2 = Mth.m_14031_((float)f);
        this.head.f_104205_ += 0.06f * f1;
        this.head.f_104203_ += 0.06f * f2;
        this.body.f_104205_ += 0.025f * f2;
        this.body.f_104203_ += 0.025f * f1;
    }

    private void animateWalk(float swing, float swingAmount) {
        float f = Math.min(0.5f, 3.0f * swingAmount);
        float f1 = swing * 0.8662f;
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Math.min(0.35f, f);
        this.head.f_104205_ += 0.3f * f3 * f;
        this.head.f_104203_ += 1.2f * Mth.m_14089_((float)(f1 + 1.5707964f)) * f4;
        this.body.f_104205_ = 0.1f * f3 * f;
        this.body.f_104203_ = 1.0f * f2 * f4;
        this.leftLeg.f_104203_ = 1.0f * f2 * f;
        this.rightLeg.f_104203_ = 1.0f * Mth.m_14089_((float)(f1 + (float)Math.PI)) * f;
        this.leftArm.f_104203_ = -(0.8f * f2 * f);
        this.leftArm.f_104205_ = 0.0f;
        this.rightArm.f_104203_ = -(0.8f * f3 * f);
        this.rightArm.f_104205_ = 0.0f;
        this.resetArmPoses();
    }

    private void resetArmPoses() {
        this.leftArm.f_104204_ = 0.0f;
        this.leftArm.f_104202_ = 1.0f;
        this.leftArm.f_104200_ = 13.0f;
        this.leftArm.f_104201_ = -13.0f;
        this.rightArm.f_104204_ = 0.0f;
        this.rightArm.f_104202_ = 1.0f;
        this.rightArm.f_104200_ = -13.0f;
        this.rightArm.f_104201_ = -13.0f;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public List<ModelPart> getHeartPartList() {
        return this.heartList;
    }

    public List<ModelPart> getRootPartList() {
        return this.allList;
    }

    public static ModelLayerLocation getLayer(String name) {
        return new ModelLayerLocation(SweetMagicCore.getSRC(name), "main");
    }

    public void translateAndRotate(ModelPart arm, PoseStack pose) {
        if (arm.f_104205_ != 0.0f) {
            pose.m_252781_(Axis.f_252403_.m_252961_(arm.f_104205_));
        }
        if (arm.f_104204_ != 0.0f) {
            pose.m_252781_(Axis.f_252436_.m_252961_(arm.f_104204_));
        }
        if (arm.f_104203_ != 0.0f) {
            pose.m_252781_(Axis.f_252529_.m_252961_(arm.f_104203_));
        }
        if (arm.f_233553_ != 1.0f || arm.f_233554_ != 1.0f || arm.f_233555_ != 1.0f) {
            pose.m_85841_(arm.f_233553_, arm.f_233554_, arm.f_233555_);
        }
    }

    public void m_233381_(AnimationState state, AnimationDefinition def, float par1) {
        state.m_216974_(par1, 1.0f);
        state.m_216979_(e -> KeyframeAnimations.m_232319_((HierarchicalModel)this, (AnimationDefinition)def, (long)e.m_216981_(), (float)1.0f, (Vector3f)ANIMA_VEC));
    }
}

