/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Arrays;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.Monster;
import sweetmagic.init.render.entity.model.SMBaseModel;

public class TempestModel<T extends Monster>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER = SMBaseModel.getLayer("blaze_tempest");
    private final ModelPart root;
    private final ModelPart[] upperBodyParts;
    private final ModelPart head;

    public TempestModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.upperBodyParts = new ModelPart[12];
        Arrays.setAll(this.upperBodyParts, s -> root.m_171324_(TempestModel.getPartName(s)));
    }

    private static String getPartName(int par1) {
        return "part" + par1;
    }

    public static LayerDefinition createBodyLayer() {
        int i;
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        float f = 0.0f;
        part.m_171599_("head", SMBaseModel.getCubeList(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        CubeListBuilder cube = SMBaseModel.getCubeList(0, 16).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f);
        for (i = 0; i < 6; ++i) {
            float f1 = Mth.m_14089_((float)f) * 18.0f;
            float f2 = -2.0f + Mth.m_14089_((float)((float)(i * 2) * 0.25f));
            float f3 = Mth.m_14031_((float)f) * 18.0f;
            part.m_171599_(TempestModel.getPartName(i), cube, PartPose.m_171419_((float)f1, (float)f2, (float)f3));
            f += 1.0f;
        }
        f = 0.7853982f;
        for (i = 6; i < 12; ++i) {
            float f4 = Mth.m_14089_((float)f) * 7.0f;
            float f6 = 2.0f + Mth.m_14089_((float)((float)(i * 2) * 0.25f));
            float f8 = Mth.m_14031_((float)f) * 7.0f;
            part.m_171599_(TempestModel.getPartName(i), cube, PartPose.m_171419_((float)f4, (float)f6, (float)f8));
            f += 1.0f;
        }
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entity, float swing, float swingAmount, float ageTick, float headYaw, float headPitch) {
        int i;
        float f = ageTick * (float)Math.PI * -0.1f;
        for (i = 0; i < 6; ++i) {
            this.upperBodyParts[i].f_104201_ = 0.0f + Mth.m_14089_((float)(((float)(i * 2) + ageTick) * 0.25f));
            this.upperBodyParts[i].f_104200_ = Mth.m_14089_((float)f) * 11.0f;
            this.upperBodyParts[i].f_104202_ = Mth.m_14031_((float)f) * 11.0f;
            f += 1.0f;
        }
        f = 0.7853982f + ageTick * (float)Math.PI * 0.1f;
        for (i = 6; i < 12; ++i) {
            this.upperBodyParts[i].f_104201_ = 13.0f + Mth.m_14089_((float)(((float)(i * 2) + ageTick) * 0.25f));
            this.upperBodyParts[i].f_104200_ = Mth.m_14089_((float)f) * 7.0f;
            this.upperBodyParts[i].f_104202_ = Mth.m_14031_((float)f) * 7.0f;
            f += 1.0f;
        }
        this.head.f_104204_ = headYaw * (float)Math.PI / 180.0f;
        this.head.f_104203_ = headPitch * (float)Math.PI / 180.0f;
    }

    public void m_7695_(PoseStack pose, VertexConsumer ver, int light, int overlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(pose, ver, light, overlay, red, green, blue, alpha);
    }

    public void translateAndRotate(ModelPart arm, PoseStack pose) {
        pose.m_85837_((double)(arm.f_104200_ / 16.0f), (double)(arm.f_104201_ / 16.0f), (double)(arm.f_104202_ / 16.0f));
        if (arm.f_104205_ != 0.0f) {
            pose.m_252781_(Axis.f_252403_.m_252961_(arm.f_104205_));
        }
        if (arm.f_104204_ != 0.0f) {
            pose.m_252781_(Axis.f_252436_.m_252961_(arm.f_104204_));
        }
        if (arm.f_104203_ != 0.0f) {
            pose.m_252781_(Axis.f_252529_.m_252961_(arm.f_104203_));
        }
        if (arm.f_233553_ != 1.0f || arm.f_233554_ != 1.0f || arm.f_233555_ != 1.0f) {
            pose.m_85841_(arm.f_233553_, arm.f_233554_, arm.f_233555_);
        }
    }
}

