/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.HumanoidArm;
import org.joml.Vector3f;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.AnimationInit;
import sweetmagic.init.entity.animal.WitchAllay;
import sweetmagic.init.render.entity.model.SMBaseModel;

public class WitchAllayModel<T extends WitchAllay>
extends HierarchicalModel<T>
implements ArmedModel {
    private static final Vector3f ANIMA_VEC = new Vector3f();
    private final float pi = (float)Math.PI / 180;
    public static final ModelLayerLocation LAYER = WitchAllayModel.getLayer("witch_allay");
    private final ModelPart root;
    public final ModelPart head;
    private final ModelPart body;
    private final ModelPart right_arm;
    private final ModelPart right_wing;
    private final ModelPart left_wing;

    public WitchAllayModel(ModelPart part) {
        this.root = part.m_171324_("root");
        this.head = this.root.m_171324_("head");
        this.body = this.root.m_171324_("body");
        this.right_arm = this.body.m_171324_("right_arm");
        this.right_wing = this.body.m_171324_("right_wing");
        this.left_wing = this.body.m_171324_("left_wing");
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.m_171576_();
        PartDefinition root = part.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)23.5f, (float)0.0f));
        root.m_171599_("head", SMBaseModel.getCubeList(0, 0).m_171488_(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, SMBaseModel.getCube(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.99f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", SMBaseModel.getCubeList(0, 10).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, SMBaseModel.getCube(0.0f)).m_171514_(0, 16).m_171488_(-1.5f, 0.0f, -1.0f, 3.0f, 5.0f, 2.0f, SMBaseModel.getCube(-0.2f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        body.m_171599_("right_arm", SMBaseModel.getCubeList(23, 0).m_171488_(-0.75f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, SMBaseModel.getCube(-0.01f)), PartPose.m_171419_((float)-1.75f, (float)0.5f, (float)0.0f));
        body.m_171599_("left_arm", SMBaseModel.getCubeList(23, 6).m_171488_(-0.25f, -0.5f, -1.0f, 1.0f, 4.0f, 2.0f, SMBaseModel.getCube(-0.01f)), PartPose.m_171419_((float)1.75f, (float)0.5f, (float)0.0f));
        body.m_171599_("right_wing", SMBaseModel.getCubeList(16, 14).m_171488_(0.0f, 1.0f, 0.0f, 0.0f, 5.0f, 8.0f, SMBaseModel.getCube(0.0f)), PartPose.m_171419_((float)-0.5f, (float)0.0f, (float)0.65f));
        body.m_171599_("left_wing", SMBaseModel.getCubeList(16, 14).m_171488_(0.0f, 1.0f, 0.0f, 0.0f, 5.0f, 8.0f, SMBaseModel.getCube(0.0f)), PartPose.m_171419_((float)0.5f, (float)0.0f, (float)0.65f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void setupAnim(T entity, float swing, float swingAmount, float ageTick, float headYaw, float headPitch) {
        float f12;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float f = ageTick * 20.0f * this.pi + swingAmount;
        float f1 = Mth.m_14089_((float)f) * (float)Math.PI * 0.15f;
        float f2 = ageTick - (float)((WitchAllay)((Object)entity)).f_19797_;
        float f3 = ageTick * 9.0f * this.pi;
        float f4 = Math.min(swingAmount / 0.3f, 1.0f);
        float f5 = 1.0f - f4;
        if (((WitchAllay)((Object)entity)).getDancing()) {
            float f7 = ageTick * 8.0f * this.pi + swingAmount;
            float f8 = Mth.m_14089_((float)f7) * 16.0f * this.pi;
            float f9 = ((WitchAllay)((Object)entity)).getSpinningProgress(f2);
            float f10 = Mth.m_14089_((float)f7) * 14.0f * this.pi;
            float f11 = Mth.m_14089_((float)f7) * 30.0f * this.pi;
            this.root.f_104204_ = ((WitchAllay)((Object)entity)).isSpinning() ? (float)Math.PI * 4 * f9 : this.root.f_104204_;
            this.root.f_104205_ = f8 * (1.0f - f9);
            this.head.f_104204_ = f11 * (1.0f - f9);
            this.head.f_104205_ = f10 * (1.0f - f9);
        } else {
            this.head.f_104203_ = headPitch * this.pi;
            this.head.f_104204_ = headYaw * this.pi;
        }
        this.right_wing.f_104203_ = 0.43633232f;
        this.right_wing.f_104204_ = -0.61086524f + f1;
        this.left_wing.f_104203_ = 0.43633232f;
        this.left_wing.f_104204_ = 0.61086524f - f1;
        this.body.f_104203_ = f12 = f4 * 0.6981317f;
        this.root.f_104201_ += (float)Math.cos(f3) * 0.25f * f5;
        this.m_233381_(((WitchAllay)((Object)entity)).magicAttackAnim, AnimationInit.ALLAY_ATTACK, ageTick);
        this.m_233381_(((WitchAllay)((Object)entity)).winkAnim, AnimationInit.ALLAY_WINK, ageTick);
        this.m_233381_(((WitchAllay)((Object)entity)).summonAnim, AnimationInit.ALLAY_SUMMON, ageTick);
    }

    public void m_7695_(PoseStack pose, VertexConsumer ver, int par1, int par2, float par3, float par4, float par5, float par6) {
        this.root.m_104301_(pose, ver, par1, par2);
    }

    public void translateToBody(PoseStack pose) {
        this.root.m_104299_(pose);
        this.body.m_104299_(pose);
        pose.m_85837_(0.0, -0.09375, 0.09375);
        pose.m_85841_(0.7f, 0.7f, 0.7f);
        pose.m_85837_(0.0625, -1.0, -0.15);
    }

    public void m_6002_(HumanoidArm arm, PoseStack pose) {
        this.root.m_104299_(pose);
        this.body.m_104299_(pose);
        pose.m_85837_(0.0, -0.09375, 0.09375);
        pose.m_252781_(Axis.f_252529_.m_252961_(this.right_arm.f_104203_ + 0.43633232f));
        pose.m_85841_(0.7f, 0.7f, 0.7f);
        pose.m_85837_(0.0625, 0.0, 0.0);
    }

    public void m_233381_(AnimationState state, AnimationDefinition def, float par1) {
        state.m_216974_(par1, 1.0f);
        state.m_216979_(e -> KeyframeAnimations.m_232319_((HierarchicalModel)this, (AnimationDefinition)def, (long)e.m_216981_(), (float)1.0f, (Vector3f)ANIMA_VEC));
    }

    public static ModelLayerLocation getLayer(String name) {
        return new ModelLayerLocation(SweetMagicCore.getSRC(name), "main");
    }
}

