/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.animal.WitchFox;
import sweetmagic.init.render.entity.model.SMBaseModel;

public class WitchFoxModel<T extends WitchFox>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LAYER = WitchFoxModel.getLayer("witchfox");
    public final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;

    public WitchFoxModel(ModelPart part) {
        super(true, 8.0f, 3.35f);
        this.head = part.m_171324_("head");
        this.body = part.m_171324_("body");
        this.rightHindLeg = part.m_171324_("right_hind_leg");
        this.leftHindLeg = part.m_171324_("left_hind_leg");
        this.rightFrontLeg = part.m_171324_("right_front_leg");
        this.leftFrontLeg = part.m_171324_("left_front_leg");
        this.tail = this.body.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition par = mesh.m_171576_();
        PartDefinition par1 = par.m_171599_("head", SMBaseModel.getCubeList(1, 5).m_171481_(-3.0f, -2.0f, -5.0f, 8.0f, 6.0f, 6.0f), PartPose.m_171419_((float)-1.0f, (float)16.5f, (float)-3.0f));
        par1.m_171599_("right_ear", SMBaseModel.getCubeList(8, 1).m_171481_(-3.0f, -4.0f, -4.0f, 2.0f, 2.0f, 1.0f), PartPose.f_171404_);
        par1.m_171599_("left_ear", SMBaseModel.getCubeList(15, 1).m_171481_(3.0f, -4.0f, -4.0f, 2.0f, 2.0f, 1.0f), PartPose.f_171404_);
        par1.m_171599_("nose", SMBaseModel.getCubeList(6, 18).m_171481_(-1.0f, 2.01f, -8.0f, 4.0f, 2.0f, 3.0f), PartPose.f_171404_);
        PartDefinition par2 = par.m_171599_("body", SMBaseModel.getCubeList(24, 15).m_171481_(-3.0f, 3.999f, -3.5f, 6.0f, 11.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-6.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeDeformation cube = new CubeDeformation(0.001f);
        CubeListBuilder build = SMBaseModel.getCubeList(4, 24).m_171488_(2.0f, 0.5f, -1.0f, 2.0f, 6.0f, 2.0f, cube);
        CubeListBuilder build1 = SMBaseModel.getCubeList(13, 24).m_171488_(2.0f, 0.5f, -1.0f, 2.0f, 6.0f, 2.0f, cube);
        par.m_171599_("right_hind_leg", build1, PartPose.m_171419_((float)-5.0f, (float)17.5f, (float)7.0f));
        par.m_171599_("left_hind_leg", build, PartPose.m_171419_((float)-1.0f, (float)17.5f, (float)7.0f));
        par.m_171599_("right_front_leg", build1, PartPose.m_171419_((float)-5.0f, (float)17.5f, (float)0.0f));
        par.m_171599_("left_front_leg", build, PartPose.m_171419_((float)-1.0f, (float)17.5f, (float)0.0f));
        par2.m_171599_("tail", SMBaseModel.getCubeList(30, 0).m_171481_(2.0f, 0.0f, -1.0f, 4.0f, 9.0f, 5.0f), PartPose.m_171423_((float)-4.0f, (float)15.0f, (float)-1.0f, (float)-0.05235988f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)48, (int)32);
    }

    public void prepareMobModel(T entity, float par1, float par2, float par3) {
        this.body.f_104203_ = 1.5707964f;
        this.tail.f_104203_ = -0.05235988f;
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(par1 * 0.6662f)) * 1.4f * par2;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(par1 * 0.6662f)) * 1.4f * par2;
        this.head.m_104227_(-1.0f, 16.5f, -3.0f);
        this.head.f_104204_ = 0.0f;
        this.head.f_104205_ = ((WitchFox)((Object)entity)).getHeadRollAngle(par3);
        this.rightHindLeg.f_104207_ = true;
        this.leftHindLeg.f_104207_ = true;
        this.rightFrontLeg.f_104207_ = true;
        this.leftFrontLeg.f_104207_ = true;
        this.body.m_104227_(0.0f, 16.0f, -6.0f);
        this.body.f_104205_ = 0.0f;
        this.rightHindLeg.m_104227_(-5.0f, 17.5f, 7.0f);
        this.leftHindLeg.m_104227_(-1.0f, 17.5f, 7.0f);
        this.tail.f_104205_ = -0.01f;
        this.tail.f_104204_ = -0.01f;
        this.tail.m_104227_(-4.0f, 15.0f, -2.0f);
        if (((WitchFox)((Object)entity)).m_6047_()) {
            this.body.f_104203_ = 1.6755161f;
            float f = ((WitchFox)((Object)entity)).getCrouchAmount(par3);
            this.body.m_104227_(0.0f, 16.0f + ((WitchFox)((Object)entity)).getCrouchAmount(par3), -6.0f);
            this.head.m_104227_(-1.0f, 16.5f + f, -3.0f);
            this.head.f_104204_ = 0.0f;
        } else if (((AbstractSummonMob)((Object)entity)).getShit()) {
            this.body.f_104203_ = 0.5235988f;
            this.body.m_104227_(0.0f, 9.0f, -3.0f);
            this.tail.f_104205_ = 0.0f;
            this.tail.f_104203_ = 1.15f + Mth.m_14031_((float)((float)((WitchFox)((Object)entity)).f_19797_ * 0.0875f)) * 0.15f;
            this.tail.m_104227_(-4.0f, 17.0f, 0.0f);
            this.head.m_104227_(-1.0f, 10.0f, -0.25f);
            this.head.f_104203_ = 0.0f;
            this.head.f_104204_ = 0.0f;
            if (this.f_102610_) {
                this.head.m_104227_(-1.0f, 13.0f, -3.75f);
            }
            this.rightHindLeg.f_104203_ = -1.3089969f;
            this.rightHindLeg.m_104227_(-5.0f, 21.5f, 6.75f);
            this.leftHindLeg.f_104203_ = -1.3089969f;
            this.leftHindLeg.m_104227_(-1.0f, 21.5f, 6.75f);
            this.rightFrontLeg.f_104203_ = -0.2617994f;
            this.leftFrontLeg.f_104203_ = -0.2617994f;
        }
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg);
    }

    public void setupAnim(T entity, float swing, float swingAmount, float ageTick, float headYaw, float headPitch) {
        if (!((WitchFox)((Object)entity)).m_6047_()) {
            this.head.f_104203_ = 0.0f;
            this.head.f_104204_ = 0.0f;
        }
        if (((WitchFox)((Object)entity)).m_6047_()) {
            float f;
            this.body.f_104204_ = f = Mth.m_14089_((float)ageTick) * 0.01f;
            this.rightHindLeg.f_104205_ = f;
            this.leftHindLeg.f_104205_ = f;
            this.rightFrontLeg.f_104205_ = f / 2.0f;
            this.leftFrontLeg.f_104205_ = f / 2.0f;
        }
    }

    public static ModelLayerLocation getLayer(String name) {
        return new ModelLayerLocation(SweetMagicCore.getSRC(name), "main");
    }
}

