/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.entity.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.entity.animal.WitchWolf;
import sweetmagic.init.render.entity.model.SMBaseModel;

@OnlyIn(value=Dist.CLIENT)
public class WitchWolfModel<T extends LivingEntity>
extends ColorableAgeableListModel<T> {
    public static final ModelLayerLocation LAYER = WitchWolfModel.getLayer("witchwolf");
    private final ModelPart head;
    private final ModelPart realHead;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart realTail;
    private final ModelPart upperBody;

    public WitchWolfModel(ModelPart par) {
        this.head = par.m_171324_("head");
        this.realHead = this.head.m_171324_("real_head");
        this.body = par.m_171324_("body");
        this.upperBody = par.m_171324_("upper_body");
        this.rightHindLeg = par.m_171324_("right_hind_leg");
        this.leftHindLeg = par.m_171324_("left_hind_leg");
        this.rightFrontLeg = par.m_171324_("right_front_leg");
        this.leftFrontLeg = par.m_171324_("left_front_leg");
        this.tail = par.m_171324_("tail");
        this.realTail = this.tail.m_171324_("real_tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition par = mesh.m_171576_();
        PartDefinition par1 = par.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)13.5f, (float)-7.0f));
        par1.m_171599_("real_head", SMBaseModel.getCubeList(0, 0).m_171481_(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f).m_171514_(16, 14).m_171481_(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f).m_171514_(16, 14).m_171481_(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f).m_171514_(0, 10).m_171481_(-0.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f), PartPose.f_171404_);
        par.m_171599_("body", SMBaseModel.getCubeList(18, 14).m_171481_(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        par.m_171599_("upper_body", SMBaseModel.getCubeList(21, 0).m_171481_(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f), PartPose.m_171423_((float)-1.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder cube = SMBaseModel.getCubeList(0, 18).m_171481_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f);
        par.m_171599_("right_hind_leg", cube, PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)7.0f));
        par.m_171599_("left_hind_leg", cube, PartPose.m_171419_((float)0.5f, (float)16.0f, (float)7.0f));
        par.m_171599_("right_front_leg", cube, PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)-4.0f));
        par.m_171599_("left_front_leg", cube, PartPose.m_171419_((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition par2 = par.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        par2.m_171599_("real_tail", SMBaseModel.getCubeList(9, 18).m_171481_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.tail, (Object)this.upperBody);
    }

    public void prepareMobModel(T entity, float par1, float par2, float par3) {
        WitchWolf wolf;
        this.tail.f_104204_ = Mth.m_14089_((float)(par1 * 0.6662f)) * 1.4f * par2;
        if (entity instanceof WitchWolf && (wolf = (WitchWolf)entity).m_21825_()) {
            this.upperBody.m_104227_(-1.0f, 16.0f, -3.0f);
            this.upperBody.f_104203_ = 1.2566371f;
            this.upperBody.f_104204_ = 0.0f;
            this.body.m_104227_(0.0f, 18.0f, 0.0f);
            this.body.f_104203_ = 0.7853982f;
            this.tail.m_104227_(-1.0f, 21.0f, 6.0f);
            this.rightHindLeg.m_104227_(-2.5f, 22.7f, 2.0f);
            this.rightHindLeg.f_104203_ = 4.712389f;
            this.leftHindLeg.m_104227_(0.5f, 22.7f, 2.0f);
            this.leftHindLeg.f_104203_ = 4.712389f;
            this.rightFrontLeg.f_104203_ = 5.811947f;
            this.rightFrontLeg.m_104227_(-2.49f, 17.0f, -4.0f);
            this.leftFrontLeg.f_104203_ = 5.811947f;
            this.leftFrontLeg.m_104227_(0.51f, 17.0f, -4.0f);
        } else {
            this.body.m_104227_(0.0f, 14.0f, 2.0f);
            this.body.f_104203_ = 1.5707964f;
            this.upperBody.m_104227_(-1.0f, 14.0f, -3.0f);
            this.upperBody.f_104203_ = this.body.f_104203_;
            this.tail.m_104227_(-1.0f, 12.0f, 8.0f);
            this.rightHindLeg.m_104227_(-2.5f, 16.0f, 7.0f);
            this.leftHindLeg.m_104227_(0.5f, 16.0f, 7.0f);
            this.rightFrontLeg.m_104227_(-2.5f, 16.0f, -4.0f);
            this.leftFrontLeg.m_104227_(0.5f, 16.0f, -4.0f);
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(par1 * 0.6662f)) * 1.4f * par2;
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
            this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
            this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(par1 * 0.6662f)) * 1.4f * par2;
        }
        if (entity instanceof WitchWolf) {
            wolf = (WitchWolf)entity;
            this.realHead.f_104205_ = wolf.getHeadRollAngle(par3) + wolf.getBodyRollAngle(par3, 0.0f);
            this.upperBody.f_104205_ = wolf.getBodyRollAngle(par3, -0.08f);
            this.body.f_104205_ = wolf.getBodyRollAngle(par3, -0.16f);
            this.realTail.f_104205_ = wolf.getBodyRollAngle(par3, -0.2f);
        }
    }

    public void setupAnim(T entity, float swing, float swingAmount, float ageTick, float headYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.tail.f_104203_ = 0.75f + Mth.m_14089_((float)(ageTick * 0.01f)) * 0.3f;
    }

    public static ModelLayerLocation getLayer(String name) {
        return new ModelLayerLocation(SweetMagicCore.getSRC(name), "main");
    }
}

