/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.ItemInit;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.gui.util.SMRenderTex;
import sweetmagic.init.tile.menu.AccessoryTableMenu;
import sweetmagic.init.tile.sm.TileAccessoryTable;

public class GuiAccessoryTable
extends GuiSMBase<AccessoryTableMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_accessory_processing.png");
    private static final ItemStack STAR = new ItemStack((ItemLike)ItemInit.starlight);
    private final TileAccessoryTable tile;

    public GuiAccessoryTable(final AccessoryTableMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(176, 172);
        this.tile = menu.tile;
        SMButton.SMButtonTip buttonTip = new SMButton.SMButtonTip("", -18, 14, this.tile){

            public boolean isFlagText(TileAccessoryTable tile) {
                Integer value = (Integer)GuiAccessoryTable.this.stackCountMap.get(menu.slotList.get(2));
                return value != null && tile.canCraft(value);
            }

            @Override
            public String getTip() {
                return this.isFlagText(GuiAccessoryTable.this.tile) ? "addstack_start" : GuiAccessoryTable.this.tile.getTip();
            }
        };
        SMButton button = new SMButton(MISC, 128, 38, 114, 15, 32, 12, buttonTip){

            @Override
            public boolean isButtonRender() {
                TileAccessoryTable tile = (TileAccessoryTable)this.getButtonTip().getTile();
                Integer value = (Integer)GuiAccessoryTable.this.stackCountMap.get(menu.slotList.get(2));
                return value != null && tile.canCraft(value);
            }
        };
        this.addButtonMap(0, button);
        this.addButtonMap(1, new SMButton(MISC, 136, 61, 137, 47, 14, 14, new SMButton.SMButtonTip("change_output", -18, 26, "change_output_tip")));
        this.addRenderTexList(new SMRenderTex(MISC, 7, 7, 0, 0, 11, 77, new SMRenderTex.MFRenderGage(this.tile, true)));
    }

    @Override
    public void m_88315_(GuiGraphics pose, int mouseX, int mouseY, float parTick) {
        this.renderMagiaStack(pose, mouseX, mouseY, parTick, ((AccessoryTableMenu)this.menu).slotList, (NonNullList<Slot>)((AccessoryTableMenu)this.menu).f_38839_);
    }

    @Override
    public void renderTooltip(GuiGraphics pose, ItemStack stack, int x, int y) {
        this.renderMagiaStackTooltip(pose, stack, x, y, ((AccessoryTableMenu)this.menu).slotList);
    }

    @Override
    protected void m_7286_(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        int x = this.getWidth();
        int y = this.getHeight();
        Integer value = (Integer)this.stackCountMap.get(((AccessoryTableMenu)this.menu).slotList.get(2));
        if (value == null || !this.tile.canCraft(value)) {
            pose.m_280218_(MISC, x + 128, y + 38, 20, 0, 32, 14);
        }
        if (this.tile.craftTime > 0) {
            int progress = this.tile.getProgress(52);
            this.blit(pose, x + 73, y + 17, 197, 17, progress, 57);
        }
        this.renderSlotItem(((AccessoryTableMenu)this.menu).starSlot, STAR, pose);
    }

    @Override
    protected void m_280003_(GuiGraphics pose, int mouseX, int mouseY) {
        super.m_280003_(pose, mouseX, mouseY);
        this.renderItemLabel(((AccessoryTableMenu)this.menu).starSlot, STAR, pose, mouseX, mouseY, this.createTipList(STAR, "slot_need"));
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

