/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.tile.gui;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.tile.gui.GuiSMBase;
import sweetmagic.init.tile.gui.util.SMButton;
import sweetmagic.init.tile.menu.AetherCraftTableMenu;
import sweetmagic.init.tile.sm.TileAetherCraftTable;

public class GuiAetherCraftTable
extends GuiSMBase<AetherCraftTableMenu> {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_aether_crafttable.png");
    public final TileAetherCraftTable tile;
    private int startIndex = 0;
    private boolean scrollingView = false;

    public GuiAetherCraftTable(AetherCraftTableMenu menu, Inventory pInv, Component title) {
        super(menu, pInv, title);
        this.setGuiSize(190, 241);
        this.tile = menu.tile;
        this.addButtonMap(0, new SMButton(TEX, 170, 99, 194, 99, 16, 16, new SMButton.SMButtonTip("id_sort", 10, -4)));
        this.addButtonMap(1, new SMButton(TEX, 170, 119, 194, 119, 16, 16, new SMButton.SMButtonTip("name_sort", 10, -4)));
        this.addButtonMap(2, new SMButton(TEX, 170, 139, 194, 139, 16, 16, new SMButton.SMButtonTip("chest_sort", 10, -4)));
        this.addButtonMap(3, new SMButton(TEX, 170, 159, 194, 159, 16, 16, new SMButton.SMButtonTip("ascending_order", 10, -4)));
        this.addButtonMap(4, new SMButton(TEX, 170, 179, 194, 179, 16, 16, new SMButton.SMButtonTip("inventory_sort", 10, -4)));
    }

    @Override
    public void m_88315_(GuiGraphics pose, int mouseX, int mouseY, float parTick) {
        this.renderMagiaStack(pose, mouseX, mouseY, parTick, (NonNullList<Slot>)((AetherCraftTableMenu)this.menu).f_38839_, (NonNullList<Slot>)((AetherCraftTableMenu)this.menu).f_38839_);
    }

    @Override
    public boolean checkStackCount(int count) {
        return count <= 64;
    }

    @Override
    protected void m_7286_(GuiGraphics pose, float parTick, int mouseX, int mouseY) {
        super.m_7286_(pose, parTick, mouseX, mouseY);
        this.scrollingView = !this.canScroll();
        int x = this.getWidth() + 174;
        int y = (int)((float)(this.getHeight() + 8) + 73.0f * ((AetherCraftTableMenu)this.menu).scrollOffset);
        if (this.isRender(x, y, mouseX, mouseY, 12, 15)) {
            this.scrollingView = true;
        }
        if (((AetherCraftTableMenu)this.menu).scrollOffset >= 1.0f && ((AetherCraftTableMenu)this.menu).maxSlots % 9 != 0) {
            for (int i = 0; i < 9 - ((AetherCraftTableMenu)this.menu).maxSlots % 9; ++i) {
                pose.m_280218_(this.getTEX(), this.getWidth() + 151 - i * 18, this.getHeight() + 79, 216, 0, 18, 18);
            }
        } else if (((AetherCraftTableMenu)this.menu).maxSlots < 45) {
            int grayslot = 45 - ((AetherCraftTableMenu)this.menu).maxSlots;
            for (int i = 0; i < grayslot; ++i) {
                pose.m_280218_(this.getTEX(), this.getWidth() + 151 - i % 9 * 18, this.getHeight() + 79 - i / 9 * 18, 216, 0, 18, 18);
            }
        }
        pose.m_280218_(this.getTEX(), x, y, 195 + (this.scrollingView ? 8 : 0), 0, 8, 15);
    }

    @Override
    public void renderTooltip(GuiGraphics pose, ItemStack stack, int x, int y) {
        List<Component> tipList = this.getTooltipFromItem(stack);
        int vMax = this.f_97734_.m_6641_();
        if (vMax > 64) {
            int vCount = (Integer)this.stackCountMap.get(this.f_97734_);
            String count = this.format(vCount) + "/";
            String max = this.format(vMax);
            String par = " (" + this.format((float)vCount / (float)vMax * 100.0f) + "%)";
            tipList.add((Component)this.getLabel(count + max + par, GOLD));
        }
        this.renderTooltip(pose, tipList, stack.m_150921_(), x, y);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (this.canScroll() && this.scrollingView) {
            int i = this.f_97736_ + 23;
            int j = i + 87;
            int maxSlots = ((AetherCraftTableMenu)this.menu).maxSlots;
            int offscreenRows = maxSlots / 9 - 5;
            if (maxSlots > 9 && maxSlots % 9 != 0) {
                ++offscreenRows;
            }
            ((AetherCraftTableMenu)this.menu).scrollOffset = ((float)mouseY - (float)i + 5.0f) / ((float)(j - i) - 15.0f);
            ((AetherCraftTableMenu)this.menu).scrollOffset = Mth.m_14036_((float)((AetherCraftTableMenu)this.menu).scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(((AetherCraftTableMenu)this.menu).scrollOffset * (float)offscreenRows) + 0.5);
            ((AetherCraftTableMenu)this.menu).updateSlotPos(this.startIndex);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (!this.canScroll()) {
            return super.m_6050_(mouseX, mouseY, scrollDelta);
        }
        if (Screen.m_96638_() || this.canScrolled(mouseX, mouseY)) {
            int maxSlots = ((AetherCraftTableMenu)this.menu).maxSlots;
            int offscreenRows = maxSlots / 9 - 5;
            if (maxSlots > 9 && maxSlots % 9 != 0) {
                ++offscreenRows;
            }
            ((AetherCraftTableMenu)this.menu).scrollOffset = (float)((double)((AetherCraftTableMenu)this.menu).scrollOffset - scrollDelta / (double)offscreenRows);
            ((AetherCraftTableMenu)this.menu).scrollOffset = Mth.m_14036_((float)((AetherCraftTableMenu)this.menu).scrollOffset, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(((AetherCraftTableMenu)this.menu).scrollOffset * (float)offscreenRows) + 0.5);
            ((AetherCraftTableMenu)this.menu).updateSlotPos(this.startIndex);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    public boolean canScrolled(double mouseX, double mouseY) {
        int x = this.getWidth() + 7;
        int y = this.getHeight() + 7;
        boolean mousetweaksLoaded = SweetMagicCore.mousetweaksLoaded;
        if (mousetweaksLoaded && (double)x <= mouseX && mouseX <= (double)(x + 161) && (double)y <= mouseY && mouseY <= (double)(y + 89)) {
            return false;
        }
        x = this.getWidth() + 44;
        y = this.getHeight() + 101;
        if (mousetweaksLoaded && (double)x <= mouseX && mouseX <= (double)(x + 105) && (double)y <= mouseY && mouseY <= (double)(y + 52)) {
            return false;
        }
        x = this.getWidth() + 7;
        y = this.getHeight() + 158;
        return !mousetweaksLoaded || !((double)x <= mouseX) || !(mouseX <= (double)(x + 161)) || !((double)y <= mouseY) || !(mouseY <= (double)(y + 75));
    }

    public void addPage(double scrollDelta) {
        int maxSlots = ((AetherCraftTableMenu)this.menu).maxSlots;
        int offscreenRows = maxSlots / 9 - 5;
        if (maxSlots > 9 && maxSlots % 9 != 0) {
            ++offscreenRows;
        }
        ((AetherCraftTableMenu)this.menu).scrollOffset = (float)((double)((AetherCraftTableMenu)this.menu).scrollOffset - scrollDelta / (double)offscreenRows);
        ((AetherCraftTableMenu)this.menu).scrollOffset = Mth.m_14036_((float)((AetherCraftTableMenu)this.menu).scrollOffset, (float)0.0f, (float)1.0f);
        this.startIndex = (int)((double)(((AetherCraftTableMenu)this.menu).scrollOffset * (float)offscreenRows) + 0.5);
        ((AetherCraftTableMenu)this.menu).updateSlotPos(this.startIndex);
    }

    public boolean canScroll() {
        return ((AetherCraftTableMenu)this.menu).maxSlots >= 45;
    }

    @Override
    protected ResourceLocation getTEX() {
        return TEX;
    }
}

